/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.hutool.http.HtmlUtil;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterXssWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;

    ParameterXssWrapper(HttpServletRequest request) {
        super(request);
        this.parameters = ParameterXssWrapper.doXss(request.getParameterMap(), false);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameters.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public static Map<String, String[]> doXss(Map<String, String[]> map, boolean convertUtf8) {
        if (null == map) {
            return null;
        }
        Iterator<Map.Entry<String, String[]>> iterator = map.entrySet().iterator();
        HashMap<String, String[]> valuesMap = new HashMap<String, String[]>(map.size());
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String key = entry.getKey();
            String[] values = entry.getValue();
            if ((values = ParameterXssWrapper.doXss(values, convertUtf8)) == null) continue;
            valuesMap.put(key, values);
        }
        return valuesMap;
    }

    private static String[] doXss(String[] values, boolean convertUtf8) {
        if (values == null) {
            return null;
        }
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (convertUtf8) {
                values[i] = ParameterXssWrapper.getUTF8(values[i]);
            }
            values[i] = HtmlUtil.escape((String)values[i]);
        }
        return values;
    }

    private static String getUTF8(String str) {
        if (str == null) {
            return null;
        }
        return new String(str.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }
}

