/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.SystemClock;
import cn.hutool.core.io.FileUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.controller.base.RequestUtil;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public abstract class AbstractBaseControl
extends BaseCallbackController {
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    @Override
    public void resetInfo() {
        super.resetInfo();
    }

    protected String getIp() {
        return ServletUtil.getClientIP((HttpServletRequest)this.getRequest(), (String[])new String[0]);
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    protected String getCookieValue(String name) {
        Cookie cookie = ServletUtil.getCookie((HttpServletRequest)this.getRequest(), (String)name);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    protected String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected String getParameter(String name, String def) {
        String value = this.getRequest().getParameter(name);
        return value == null ? def : value;
    }

    protected int getParameterInt(String name, int def) {
        return Convert.toInt((Object)this.getParameter(name), (Integer)def);
    }

    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    protected long getParameterLong(String name, long def) {
        String value = this.getParameter(name);
        if (value == null) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    protected long getParameterLong(String name) {
        return this.getParameterLong(name, 0L);
    }

    protected Map<String, String> getRefererParameter() throws UnsupportedEncodingException {
        String referer = this.getHeader("Referer");
        return RequestUtil.convertUrlMap(referer);
    }

    protected <T> T getObject(Class<T> tClass) {
        return (T)ServletUtil.toBean((ServletRequest)this.getRequest(), tClass, (boolean)true);
    }

    public static void clearResources() {
        THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.remove();
    }

    protected MultipartHttpServletRequest getMultiRequest() {
        HttpServletRequest request = this.getRequest();
        if (request instanceof MultipartHttpServletRequest) {
            return (MultipartHttpServletRequest)request;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
            if (multipartHttpServletRequest != null) {
                return multipartHttpServletRequest;
            }
            multipartHttpServletRequest = new StandardMultipartHttpServletRequest(request);
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(multipartHttpServletRequest);
            return multipartHttpServletRequest;
        }
        throw new IllegalArgumentException("not MultipartHttpServletRequest");
    }

    protected MultipartFile getFile(String name) {
        return this.getMultiRequest().getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        return this.getMultiRequest().getFiles(name);
    }

    protected String upload(String name) throws IOException {
        return this.upload(new String[]{name})[0];
    }

    protected String[] upload(String ... name) throws IOException {
        Objects.requireNonNull(name);
        String[] path = new String[name.length];
        String localPath = MultipartFileConfig.getFileTempPath();
        int len = path.length;
        for (int i = 0; i < len; ++i) {
            String fileName;
            String item = name[i];
            MultipartFile multiFile = this.getFile(item);
            if (multiFile == null || (fileName = multiFile.getOriginalFilename()) == null || fileName.length() <= 0) continue;
            String filePath = FileUtil.normalize((String)String.format("%s/%s_%s", localPath, SystemClock.now(), fileName));
            FileUtil.writeFromStream((InputStream)multiFile.getInputStream(), (String)filePath);
            path[i] = filePath;
        }
        return path;
    }
}

