/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.multipart;

import ch.qos.logback.core.util.FileSize;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.UnicodeUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MultipartFileBuilder {
    private MultipartHttpServletRequest multipartHttpServletRequest;
    private long maxSize = 0L;
    private Set<String> fieldNames = new HashSet<String>();
    private boolean multiple;
    private String[] fileExt;
    private String contentTypePrefix;
    private String[] inputStreamType;
    private String savePath;
    private boolean useOriginalFilename;

    public MultipartFileBuilder setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public MultipartFileBuilder setMaxSize(String maxSize) {
        this.maxSize = FileSize.valueOf((String)maxSize).getSize();
        return this;
    }

    public MultipartFileBuilder setUseOriginalFilename(boolean useOriginalFilename) {
        this.useOriginalFilename = useOriginalFilename;
        return this;
    }

    public MultipartFileBuilder addFieldName(String fieldName) {
        this.fieldNames.add(fieldName);
        return this;
    }

    public MultipartFileBuilder setMultiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public MultipartFileBuilder setFileExt(String ... fileExt) {
        this.fileExt = fileExt;
        return this;
    }

    public MultipartFileBuilder setInputStreamType(String ... inputStreamType) {
        this.inputStreamType = inputStreamType;
        return this;
    }

    public MultipartFileBuilder setContentTypePrefix(String contentTypePrefix) {
        this.contentTypePrefix = contentTypePrefix;
        return this;
    }

    public MultipartFileBuilder setSavePath(String savePath) {
        this.savePath = savePath;
        return this;
    }

    private void checkSaveOne() {
        if (this.fieldNames.size() != 1) {
            throw new IllegalArgumentException("fieldNames size:" + this.fieldNames.size() + "  use save");
        }
        if (this.multiple) {
            throw new IllegalArgumentException("multiple use saves");
        }
    }

    public String save() throws IOException {
        this.checkSaveOne();
        String[] paths = this.saves();
        return paths[0];
    }

    public String[] saves() throws IOException {
        if (this.fieldNames.isEmpty()) {
            throw new IllegalArgumentException("fieldNames:empty");
        }
        String[] paths = new String[this.fieldNames.size()];
        int index = 0;
        for (String fieldName : this.fieldNames) {
            if (this.multiple) {
                List multipartFiles = this.multipartHttpServletRequest.getFiles(fieldName);
                for (MultipartFile multipartFile : multipartFiles) {
                    paths[index++] = this.saveAndName(multipartFile)[0];
                }
                continue;
            }
            MultipartFile multipartFile = this.multipartHttpServletRequest.getFile(fieldName);
            paths[index++] = this.saveAndName(multipartFile)[0];
        }
        return paths;
    }

    public String[] saveAndName() throws IOException {
        this.checkSaveOne();
        List<String[]> list = this.saveAndNames();
        return list.get(0);
    }

    public List<String[]> saveAndNames() throws IOException {
        if (this.fieldNames.isEmpty()) {
            throw new IllegalArgumentException("fieldNames:empty");
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String fieldName : this.fieldNames) {
            if (this.multiple) {
                List multipartFiles = this.multipartHttpServletRequest.getFiles(fieldName);
                for (MultipartFile multipartFile : multipartFiles) {
                    String[] info = this.saveAndName(multipartFile);
                    list.add(info);
                }
                continue;
            }
            MultipartFile multipartFile = this.multipartHttpServletRequest.getFile(fieldName);
            String[] info = this.saveAndName(multipartFile);
            list.add(info);
        }
        return list;
    }

    private String[] saveAndName(MultipartFile multiFile) throws IOException {
        String filePath;
        String fileName = multiFile.getOriginalFilename();
        if (StrUtil.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("fileName:\u4e0d\u80fd\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
        }
        long fileSize = multiFile.getSize();
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("fileSize:\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (this.fileExt != null) {
            String checkName = fileName.toLowerCase();
            boolean find = false;
            for (String ext : this.fileExt) {
                find = checkName.endsWith("." + ext.toLowerCase());
                if (find) break;
            }
            if (!find) {
                throw new IllegalArgumentException("fileExt:\u7c7b\u578b\u9519\u8bef:" + checkName);
            }
        }
        if (this.maxSize > 0L && fileSize > this.maxSize) {
            throw new IllegalArgumentException("maxSize:too big:" + fileSize + ">" + this.maxSize);
        }
        if (this.inputStreamType != null) {
            InputStream inputStream = multiFile.getInputStream();
            String fileType = FileTypeUtil.getType((InputStream)inputStream);
            for (String type : this.inputStreamType) {
                if (type.equalsIgnoreCase(fileType)) continue;
                throw new IllegalArgumentException("inputStreamType:\u7c7b\u578b\u9519\u8bef:" + fileType + "  " + type);
            }
        }
        String localPath = this.savePath != null ? this.savePath : MultipartFileConfig.getFileTempPath();
        if (this.useOriginalFilename) {
            filePath = FileUtil.normalize((String)String.format("%s/%s", localPath, fileName));
        } else {
            String saveFileName = UnicodeUtil.toUnicode((String)fileName);
            filePath = FileUtil.normalize((String)String.format("%s/%s_%s", localPath, IdUtil.objectId(), saveFileName));
        }
        FileUtil.writeFromStream((InputStream)multiFile.getInputStream(), (String)filePath);
        if (this.contentTypePrefix != null) {
            Path source = Paths.get(filePath, new String[0]);
            String contentType = Files.probeContentType(source);
            if (contentType == null) {
                FileUtil.del((String)filePath);
                throw new IllegalArgumentException("contentTypePrefix:\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5931\u8d25");
            }
            if (!contentType.startsWith(this.contentTypePrefix)) {
                FileUtil.del((String)filePath);
                throw new IllegalArgumentException("contentTypePrefix:\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e:" + contentType);
            }
        }
        return new String[]{filePath, fileName};
    }

    public MultipartFileBuilder(MultipartHttpServletRequest multipartHttpServletRequest) {
        Objects.requireNonNull(multipartHttpServletRequest);
        this.multipartHttpServletRequest = multipartHttpServletRequest;
    }
}

