/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HtmlUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.common.request.MultipartParameterXssWrapper;
import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.CharacterEncodingFilter;

public class XssFilter
extends CharacterEncodingFilter {
    private static final ThreadLocal<Long> REQUEST_TIME = new ThreadLocal();
    private static final ThreadLocal<StringBuffer> REQUEST_INFO = new ThreadLocal();
    private static final ThreadLocal<Map<String, String>> REQUEST_HEADER_MAP = new ThreadLocal();
    private static final ThreadLocal<Map<String, String[]>> REQUEST_PARAMETERS_MAP = new ThreadLocal();
    private static long request_timeout_log = -1L;
    private static boolean LOG;
    private static boolean XSS;

    private static void cleanThreadLocal() {
        REQUEST_HEADER_MAP.remove();
        REQUEST_INFO.remove();
        REQUEST_TIME.remove();
        REQUEST_PARAMETERS_MAP.remove();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        REQUEST_TIME.set(System.currentTimeMillis());
        File location = (File)request.getServletContext().getAttribute("javax.servlet.context.tempdir");
        if (!location.exists() && !location.mkdirs()) {
            throw new IOException(location.getPath() + " \u4e34\u65f6\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        boolean isFile = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        Object newRequest = isFile ? new MultipartParameterXssWrapper(request) : new ParameterXssWrapper(request);
        this.requestLog((HttpServletRequest)newRequest);
        super.doFilterInternal((HttpServletRequest)newRequest, response, filterChain);
        this.responseLog(response);
        XssFilter.cleanThreadLocal();
    }

    private void requestLog(HttpServletRequest request) {
        if (!LOG) {
            return;
        }
        Map<String, String> header = BaseCallbackController.getHeaderMapValues(request);
        REQUEST_HEADER_MAP.set(header);
        Map parameters = request.getParameterMap();
        REQUEST_PARAMETERS_MAP.set(parameters);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(request.getRequestURI()).append(",ip:").append(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0])).append(" parameters:");
        if (parameters != null) {
            Set entries = parameters.entrySet();
            stringBuffer.append("{");
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                stringBuffer.append(key).append(":");
                String[] value = (String[])entry.getValue();
                if (value != null) {
                    for (int i = 0; i < value.length; ++i) {
                        if (i != 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(HtmlUtil.unescape((String)value[i]));
                    }
                }
                stringBuffer.append(";");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(",header:").append(header);
        DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST).info(stringBuffer.toString());
        REQUEST_INFO.set(stringBuffer);
    }

    private void responseLog(HttpServletResponse response) {
        Long timeOut;
        if (!LOG) {
            return;
        }
        int status = response.getStatus();
        if (status != HttpStatus.OK.value() && status != HttpStatus.FOUND.value()) {
            String stringBuffer = "status:" + status + ",url:" + REQUEST_INFO.get();
            DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST_ERROR).error(stringBuffer);
            return;
        }
        long time = System.currentTimeMillis() - REQUEST_TIME.get();
        if (request_timeout_log == -1L && (request_timeout_log = Convert.toLong((Object)(timeOut = (Long)SpringUtil.getEnvironment().getProperty("request.timeout", Long.class, (Object)3000L)), (Long)3000L).longValue()) <= 0L) {
            request_timeout_log = 0L;
        }
        if (request_timeout_log > 0L && time > request_timeout_log) {
            String stringBuffer = "time:" + time + ",url:" + REQUEST_INFO.get();
            DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST_ERROR).error(stringBuffer);
        }
    }

    static Map<String, String[]> doXss(Map<String, String[]> map) {
        if (null == map) {
            return null;
        }
        Iterator<Map.Entry<String, String[]>> iterator = map.entrySet().iterator();
        HashMap<String, String[]> valuesMap = new HashMap<String, String[]>(map.size());
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String key = entry.getKey();
            String[] values = entry.getValue();
            if ((values = XssFilter.doXss(values)) == null) continue;
            valuesMap.put(key, values);
        }
        return valuesMap;
    }

    private static String[] doXss(String[] values) {
        if (values == null) {
            return null;
        }
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (null == values[i]) continue;
            values[i] = XssFilter.autoToUtf8(values[i]);
            if (!XSS) continue;
            values[i] = HtmlUtil.escape((String)values[i]).replace("&quot;", "\"");
        }
        return values;
    }

    private static String autoToUtf8(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return str;
        }
        String newStr = CharsetUtil.convert((String)str, (Charset)StandardCharsets.ISO_8859_1, (Charset)StandardCharsets.UTF_8);
        if (str.length() >= newStr.length()) {
            return str;
        }
        return newStr;
    }

    static {
        try {
            LOG = (Boolean)SpringUtil.getEnvironment().getProperty("request.log", Boolean.class, (Object)true);
        }
        catch (ConversionFailedException ignored) {
            LOG = false;
        }
        try {
            XSS = (Boolean)SpringUtil.getEnvironment().getProperty("request.parameterXss", Boolean.class, (Object)true);
        }
        catch (ConversionFailedException ignored) {
            XSS = true;
        }
    }
}

