/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.jiangzeyin.common.request.XssFilter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterXssWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;

    ParameterXssWrapper(HttpServletRequest request) {
        super(request);
        Charset charset = ParameterXssWrapper.getCharset(request);
        this.parameters = XssFilter.doXss(request.getParameterMap(), charset);
    }

    static Charset getCharset(HttpServletRequest request) {
        String contentType = request.getContentType();
        String charsetName = ReUtil.get((Pattern)HttpUtil.CHARSET_PATTERN, (String)contentType, (int)1);
        Charset charset = null;
        if (StrUtil.isNotBlank((CharSequence)charsetName)) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameters.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }
}

