/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.pool;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.pool.PolicyHandler;
import cn.jiangzeyin.pool.PoolConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.AbstractQueue;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadPoolService {
    private static final ConcurrentHashMap<Class, PoolCacheInfo> POOL_CACHE_INFO_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    private ThreadPoolService() {
    }

    public static synchronized ExecutorService newCachedThreadPool(Class class1) {
        if (class1 == null) {
            throw new NullPointerException();
        }
        PoolCacheInfo poolCacheInfo = POOL_CACHE_INFO_CONCURRENT_HASH_MAP.computeIfAbsent(class1, aClass -> {
            PoolCacheInfo poolCacheInfo1 = ThreadPoolService.createPool(class1);
            DefaultSystemLog.LOG().info(class1 + "\u7ebf\u7a0b\u6c60\u7533\u8bf7\u6210\u529f:" + poolCacheInfo1);
            return poolCacheInfo1;
        });
        return poolCacheInfo.poolExecutor;
    }

    private static PoolCacheInfo createPool(Class tClass) {
        ThreadPoolExecutorPool threadPoolExecutor;
        AbstractQueue blockingQueue;
        ProxyHandler proxyHandler;
        PoolConfig poolConfig = tClass.getAnnotation(PoolConfig.class);
        SystemThreadFactory systemThreadFactory = new SystemThreadFactory(tClass.getName());
        if (poolConfig == null) {
            proxyHandler = new ProxyHandler(PolicyHandler.Caller);
            blockingQueue = new SynchronousQueue();
            threadPoolExecutor = new ThreadPoolExecutorPool(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)blockingQueue), systemThreadFactory, proxyHandler);
        } else {
            proxyHandler = new ProxyHandler(poolConfig.HANDLER());
            int corePoolSize = poolConfig.value();
            blockingQueue = corePoolSize == 0 ? new SynchronousQueue() : new LinkedBlockingQueue();
            threadPoolExecutor = new ThreadPoolExecutorPool(corePoolSize, poolConfig.maximumPoolSize(), poolConfig.keepAliveTime(), poolConfig.UNIT(), (BlockingQueue<Runnable>)((Object)blockingQueue), systemThreadFactory, proxyHandler);
            threadPoolExecutor.setQueueMaxSize(poolConfig.queueMaxSize());
        }
        return new PoolCacheInfo(threadPoolExecutor, (BlockingQueue<Runnable>)((Object)blockingQueue), proxyHandler, systemThreadFactory);
    }

    public static int getPoolQueuedTasks(Class tClass) {
        PoolCacheInfo poolCacheInfo = POOL_CACHE_INFO_CONCURRENT_HASH_MAP.get(tClass);
        if (poolCacheInfo == null) {
            return 0;
        }
        return poolCacheInfo.blockingQueue.size();
    }

    public static int getPoolRejectedExecutionCount(Class tclass) {
        PoolCacheInfo poolCacheInfo = POOL_CACHE_INFO_CONCURRENT_HASH_MAP.get(tclass);
        if (poolCacheInfo == null) {
            return 0;
        }
        return poolCacheInfo.handler.getRejectedExecutionCount();
    }

    public static JSONArray getThreadPoolStatusInfo() {
        JSONArray jsonArray = new JSONArray();
        for (Map.Entry<Class, PoolCacheInfo> entry : POOL_CACHE_INFO_CONCURRENT_HASH_MAP.entrySet()) {
            PoolCacheInfo poolCacheInfo = entry.getValue();
            String name = ClassUtil.getShortClassName((String)entry.getKey().getName());
            JSONObject jsonObject = ThreadPoolService.convertInfo(name, poolCacheInfo);
            jsonArray.add((Object)jsonObject);
        }
        jsonArray.sort((o1, o2) -> {
            JSONObject jsonObject1 = (JSONObject)o1;
            JSONObject jsonObject2 = (JSONObject)o2;
            return jsonObject2.getLong("taskCount").compareTo(jsonObject1.getLong("taskCount"));
        });
        return jsonArray;
    }

    private static JSONObject convertInfo(String name, PoolCacheInfo poolCacheInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        ThreadPoolExecutorPool threadPoolExecutor = poolCacheInfo.poolExecutor;
        jsonObject.put("corePoolSize", (Object)threadPoolExecutor.getCorePoolSize());
        jsonObject.put("poolSize", (Object)threadPoolExecutor.getPoolSize());
        jsonObject.put("activeCount", (Object)threadPoolExecutor.getActiveCount());
        jsonObject.put("largestPoolSize", (Object)threadPoolExecutor.getLargestPoolSize());
        jsonObject.put("completedTaskCount", (Object)threadPoolExecutor.getCompletedTaskCount());
        jsonObject.put("taskCount", (Object)threadPoolExecutor.getTaskCount());
        jsonObject.put("queueSize", (Object)poolCacheInfo.blockingQueue.size());
        jsonObject.put("rejectedExecutionCount", (Object)poolCacheInfo.handler.getRejectedExecutionCount());
        jsonObject.put("maxThreadNumber", (Object)poolCacheInfo.systemThreadFactory.threadNumber.get());
        jsonObject.put("maximumPoolSize", (Object)threadPoolExecutor.getMaximumPoolSize());
        return jsonObject;
    }

    public static void shutdown() {
        for (Map.Entry<Class, PoolCacheInfo> entry : POOL_CACHE_INFO_CONCURRENT_HASH_MAP.entrySet()) {
            DefaultSystemLog.LOG().info(String.format("\u5173\u95ed%s\u4f7f\u7528\u7684\u7ebf\u7a0b\u6c60", entry.getKey()));
            entry.getValue().poolExecutor.shutdown();
            String name = ClassUtil.getShortClassName((String)entry.getKey().getName());
            JSONObject jsonObject = ThreadPoolService.convertInfo(name, entry.getValue());
            DefaultSystemLog.LOG().info("\u5173\u95ed\u5b8c\u6210:" + jsonObject);
        }
    }

    private static class ThreadPoolExecutorPool
    extends ThreadPoolExecutor {
        private int queueMaxSize = 0;

        ThreadPoolExecutorPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        void setQueueMaxSize(int queueMaxSize) {
            this.queueMaxSize = queueMaxSize;
        }

        @Override
        public void execute(Runnable command) {
            this.checkQueueSize();
            super.execute(command);
        }

        @Override
        public Future<?> submit(Runnable task) {
            this.checkQueueSize();
            return super.submit(task);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            this.checkQueueSize();
            return super.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            this.checkQueueSize();
            return super.submit(task, result);
        }

        private void checkQueueSize() {
            int queueSize;
            if (this.queueMaxSize > 0 && (queueSize = this.getQueue().size()) > this.queueMaxSize) {
                throw new RuntimeException("queue size :" + queueSize + "  >" + this.queueMaxSize);
            }
        }
    }

    static class SystemThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        SystemThreadFactory(String poolName) {
            SecurityManager s;
            if (StrUtil.isEmpty((CharSequence)poolName)) {
                poolName = "pool";
            }
            this.group = (s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class ProxyHandler
    implements RejectedExecutionHandler {
        private final AtomicInteger handlerCount = new AtomicInteger(0);
        private final RejectedExecutionHandler rejectedExecutionHandler;

        ProxyHandler(PolicyHandler policyHandler) {
            RejectedExecutionHandler rejectedExecutionHandler1 = null;
            switch (policyHandler) {
                case Abort: {
                    rejectedExecutionHandler1 = new ThreadPoolExecutor.AbortPolicy();
                    break;
                }
                case Caller: {
                    rejectedExecutionHandler1 = new ThreadPoolExecutor.CallerRunsPolicy();
                    break;
                }
                case Discard: {
                    rejectedExecutionHandler1 = new ThreadPoolExecutor.DiscardPolicy();
                    break;
                }
                case DiscardOldest: {
                    rejectedExecutionHandler1 = new ThreadPoolExecutor.DiscardOldestPolicy();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u6682\u65f6\u4e0d\u652f\u6301");
                }
            }
            this.rejectedExecutionHandler = rejectedExecutionHandler1;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.handlerCount.getAndIncrement();
            this.rejectedExecutionHandler.rejectedExecution(r, executor);
        }

        int getRejectedExecutionCount() {
            return this.handlerCount.get();
        }
    }

    private static class PoolCacheInfo {
        private final ThreadPoolExecutorPool poolExecutor;
        private final BlockingQueue<Runnable> blockingQueue;
        private final ProxyHandler handler;
        private final SystemThreadFactory systemThreadFactory;

        PoolCacheInfo(ThreadPoolExecutorPool poolExecutor, BlockingQueue<Runnable> blockingQueue, ProxyHandler handler, SystemThreadFactory systemThreadFactory) {
            this.poolExecutor = poolExecutor;
            this.blockingQueue = blockingQueue;
            this.handler = handler;
            this.systemThreadFactory = systemThreadFactory;
        }

        public String toString() {
            return this.poolExecutor.toString() + " MaximumPoolSize:" + this.poolExecutor.getMaximumPoolSize() + " CorePoolSize:" + this.poolExecutor.getCorePoolSize() + " LargestPoolSize:" + this.poolExecutor.getLargestPoolSize() + " blockingQueue:" + this.blockingQueue.size() + " RejectedExecutionCount:" + this.handler.getRejectedExecutionCount();
        }
    }
}

