/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.ApplicationBuilder;
import cn.jiangzeyin.common.CommonInitPackage;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.event.ApplicationEventClient;
import cn.jiangzeyin.common.spring.event.ApplicationEventLoad;
import cn.jiangzeyin.pool.ThreadPoolService;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Configuration
public class SpringUtil
implements ApplicationListener,
ApplicationContextAware {
    private static volatile ApplicationContext applicationContext;

    private static synchronized void setApplicationContexts(ApplicationContext applicationContext) {
        SpringUtil.applicationContext = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtil.setApplicationContexts(applicationContext);
        DefaultSystemLog.init();
        Set<ApplicationEventLoad> applicationEventLoads = ApplicationBuilder.getInstance().getApplicationEventLoads();
        if (applicationEventLoads != null) {
            for (ApplicationEventLoad applicationEventLoad : applicationEventLoads) {
                applicationEventLoad.applicationLoad();
            }
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ServletRequestHandledEvent servletRequestHandledEvent;
        if (event instanceof ApplicationFailedEvent) {
            System.err.println("Common-Boot \u542f\u52a8\u5931\u8d25");
            ApplicationFailedEvent applicationFailedEvent = (ApplicationFailedEvent)event;
            applicationFailedEvent.getException().printStackTrace();
            return;
        }
        Set<ApplicationEventClient> applicationEventClients = ApplicationBuilder.getInstance().getApplicationEventClients();
        if (applicationEventClients != null) {
            for (ApplicationEventClient applicationEventClient : applicationEventClients) {
                applicationEventClient.onApplicationEvent(event);
            }
        }
        if (event instanceof ApplicationReadyEvent) {
            CommonInitPackage.init();
            DefaultSystemLog.LOG().info("common-boot \u542f\u52a8\u5b8c\u6210");
            return;
        }
        if (event instanceof ContextClosedEvent) {
            DefaultSystemLog.LOG().info("common-boot \u5173\u95ed\u7a0b\u5e8f");
            ThreadPoolService.shutdown();
            return;
        }
        if (event instanceof ServletRequestHandledEvent && (servletRequestHandledEvent = (ServletRequestHandledEvent)event).wasFailure()) {
            DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST).info("error:" + servletRequestHandledEvent.toString());
        }
    }

    public static ApplicationContext getApplicationContext() {
        Assert.notNull((Object)applicationContext, (String)"application is null");
        return applicationContext;
    }

    public static Object getBean(String name) {
        return SpringUtil.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringUtil.getApplicationContext().getBean(name, clazz);
    }

    public static Environment getEnvironment() {
        return ApplicationBuilder.getInstance().getEnvironment();
    }

    public static String getApplicationId() {
        return SpringUtil.getEnvironment().getProperty("spring.application.name");
    }

    public static <T> T registerSingleton(Class<T> tClass) {
        Objects.requireNonNull(tClass);
        AutowireCapableBeanFactory autowireCapableBeanFactory = SpringUtil.getApplicationContext().getAutowireCapableBeanFactory();
        Object obj = autowireCapableBeanFactory.createBean(tClass);
        String beanName = StrUtil.upperFirst((CharSequence)tClass.getSimpleName());
        ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)SpringUtil.getApplicationContext();
        ConfigurableListableBeanFactory configurableListableBeanFactory = configurableApplicationContext.getBeanFactory();
        configurableListableBeanFactory.registerSingleton(beanName, obj);
        return (T)obj;
    }
}

