/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.controller.base.AbstractController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    private static final ThreadLocal<HandlerMethod> HANDLER_METHOD_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<BaseCallbackController> BASE_CALLBACK_CONTROLLER_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpSession> HTTP_SESSION_THREAD_LOCAL = new ThreadLocal();

    protected void clearResources() {
        HTTP_SESSION_THREAD_LOCAL.remove();
        HANDLER_METHOD_THREAD_LOCAL.remove();
        BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.remove();
    }

    public static HttpSession getSession() {
        return HTTP_SESSION_THREAD_LOCAL.get();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HTTP_SESSION_THREAD_LOCAL.set(request.getSession());
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            HANDLER_METHOD_THREAD_LOCAL.set(handlerMethod);
            Object object = handlerMethod.getBean();
            Class<?> controlClass = object.getClass();
            if (BaseCallbackController.class.isAssignableFrom(controlClass)) {
                BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.set((BaseCallbackController)object);
            }
        }
        return true;
    }

    protected HandlerMethod getHandlerMethod() {
        return HANDLER_METHOD_THREAD_LOCAL.get();
    }

    protected void reload() {
        BaseCallbackController baseCallbackController = BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.get();
        if (baseCallbackController != null) {
            baseCallbackController.resetInfo();
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (response.getStatus() != HttpStatus.OK.value()) {
            DefaultSystemLog.LOG().info("\u8bf7\u6c42\u9519\u8bef:" + request.getRequestURI() + "  " + response.getStatus());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            DefaultSystemLog.ERROR().error("controller \u5f02\u5e38:" + request.getRequestURL(), (Throwable)ex);
        }
        AbstractController.clearResources();
        this.clearResources();
    }
}

