/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.hutool.core.util.ClassUtil;
import cn.jiangzeyin.common.AutoPropertiesClass;
import cn.jiangzeyin.common.AutoPropertiesMethod;
import cn.jiangzeyin.common.EnableCommonBoot;
import cn.jiangzeyin.common.PreLoadMethod;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.spring.event.ApplicationEventClient;
import cn.jiangzeyin.common.spring.event.ApplicationEventLoad;
import cn.jiangzeyin.common.validator.ParameterInterceptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;

public class ApplicationBuilder
extends SpringApplicationBuilder {
    private static volatile ApplicationBuilder applicationBuilder;
    private Class applicationClass;
    private SpringApplication application;
    private Environment environment;
    private Set<ApplicationEventClient> applicationEventClients;
    private Set<ApplicationEventLoad> applicationEventLoads;
    private Set<Class<? extends BaseInterceptor>> interceptorClass;
    private Set<HttpMessageConverter<?>> httpMessageConverters;
    private Set<Class<? extends HandlerMethodArgumentResolver>> handlerMethodArgumentResolvers;
    private static final ConcurrentHashMap<String, Object> PRESET_PARAMETER;
    private final HashSet<Class> cacheLoadProperties = new HashSet();

    public static void put(String key, Object value) {
        PRESET_PARAMETER.put(key, value);
    }

    public static Object get(String key) {
        return PRESET_PARAMETER.get(key);
    }

    public static ApplicationBuilder createBuilder(Class<?> ... sources) throws Exception {
        return new ApplicationBuilder(sources);
    }

    protected ApplicationBuilder(Class<?> ... sources) throws Exception {
        super((Class[])sources);
        this.application = this.application();
        if (applicationBuilder != null && !ApplicationBuilder.isRestart()) {
            throw new IllegalArgumentException("duplicate create");
        }
        this.applicationClass = this.application.getMainApplicationClass();
        this.banner((environment, sourceClass, out) -> {
            this.environment = environment;
            String msg = environment.getProperty("banner.msg", "boot Application starting");
            out.println(msg);
        });
        EnableCommonBoot enableCommonBoot = this.applicationClass.getAnnotation(EnableCommonBoot.class);
        if (enableCommonBoot == null) {
            this.addLoadPage("cn.jiangzeyin");
        } else if (enableCommonBoot.parameterValidator()) {
            this.addInterceptor(ParameterInterceptor.class);
        }
        this.loadProperties("cn.jiangzeyin");
        applicationBuilder = this;
    }

    public static ApplicationBuilder getInstance() {
        if (applicationBuilder == null) {
            throw new RuntimeException("Application not start");
        }
        return applicationBuilder;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            throw new RuntimeException("Application not start");
        }
        return this.environment;
    }

    public Set<ApplicationEventClient> getApplicationEventClients() {
        return this.applicationEventClients;
    }

    public Set<ApplicationEventLoad> getApplicationEventLoads() {
        return this.applicationEventLoads;
    }

    public Set<Class<? extends BaseInterceptor>> getInterceptorClass() {
        return this.interceptorClass;
    }

    public Set<HttpMessageConverter<?>> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public ApplicationBuilder addHttpMessageConverter(HttpMessageConverter<?> httpMessageConverter) {
        Objects.requireNonNull(httpMessageConverter);
        if (this.httpMessageConverters == null) {
            this.httpMessageConverters = new HashSet();
        }
        this.httpMessageConverters.add(httpMessageConverter);
        return this;
    }

    public ApplicationBuilder addInterceptor(Class<? extends BaseInterceptor> cls) {
        Objects.requireNonNull(cls);
        if (this.interceptorClass == null) {
            this.interceptorClass = new HashSet<Class<? extends BaseInterceptor>>();
        }
        this.interceptorClass.add(cls);
        return this;
    }

    public ApplicationBuilder addApplicationEventLoad(ApplicationEventLoad applicationEventLoad) {
        Objects.requireNonNull(applicationEventLoad);
        if (this.applicationEventLoads == null) {
            this.applicationEventLoads = new HashSet<ApplicationEventLoad>();
        }
        this.applicationEventLoads.add(applicationEventLoad);
        return this;
    }

    public ApplicationBuilder addApplicationEventClient(ApplicationEventClient applicationEventClient) {
        Objects.requireNonNull(applicationEventClient);
        if (this.applicationEventClients == null) {
            this.applicationEventClients = new HashSet<ApplicationEventClient>();
        }
        this.applicationEventClients.add(applicationEventClient);
        return this;
    }

    public ApplicationBuilder addHandlerMethodArgumentResolver(Class<? extends HandlerMethodArgumentResolver> cls) {
        Objects.requireNonNull(cls);
        if (this.handlerMethodArgumentResolvers == null) {
            this.handlerMethodArgumentResolvers = new HashSet<Class<? extends HandlerMethodArgumentResolver>>();
        }
        this.handlerMethodArgumentResolvers.add(cls);
        return this;
    }

    public Set<Class<? extends HandlerMethodArgumentResolver>> getHandlerMethodArgumentResolvers() {
        return this.handlerMethodArgumentResolvers;
    }

    public ApplicationBuilder addLoadPage(String packageName) throws NoSuchFieldException, IllegalAccessException {
        String fliedName;
        ComponentScan proxy;
        if (StringUtils.isEmpty((Object)packageName)) {
            throw new IllegalArgumentException("packageName");
        }
        ComponentScan componentScan = this.applicationClass.getAnnotation(ComponentScan.class);
        if (componentScan == null) {
            SpringBootApplication springBootApplication = this.applicationClass.getAnnotation(SpringBootApplication.class);
            if (springBootApplication == null) {
                throw new IllegalArgumentException("please add " + SpringBootApplication.class);
            }
            proxy = springBootApplication;
            fliedName = "scanBasePackages";
        } else {
            proxy = componentScan;
            fliedName = "value";
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
        Field value = invocationHandler.getClass().getDeclaredField("memberValues");
        value.setAccessible(true);
        Map memberValues = (Map)value.get(invocationHandler);
        String[] values = (String[])memberValues.get(fliedName);
        String[] newValues = new String[]{packageName};
        newValues = StringUtils.mergeStringArrays((String[])values, (String[])newValues);
        memberValues.put(fliedName, newValues);
        return this;
    }

    public static boolean isRestart() {
        String name = Thread.currentThread().getName();
        return "restartedMain".equalsIgnoreCase(name);
    }

    public ApplicationBuilder loadProperties(String packageName) throws Exception {
        Set list = ClassUtil.scanPackageByAnnotation((String)packageName, AutoPropertiesClass.class);
        for (Class cls : list) {
            if (this.cacheLoadProperties.contains(cls)) continue;
            Method[] methods = cls.getDeclaredMethods();
            if (methods != null) {
                for (Method method : methods) {
                    AutoPropertiesMethod autoPropertiesMethod = method.getAnnotation(AutoPropertiesMethod.class);
                    if (autoPropertiesMethod == null) continue;
                    method.setAccessible(true);
                    ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                    Type type = parameterizedType.getRawType();
                    Class retCls = (Class)type;
                    int modifiers = method.getModifiers();
                    Class<?>[] parameters = method.getParameterTypes();
                    if (parameters.length <= 0 && Map.class == retCls && Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers)) {
                        Map map = (Map)method.invoke(null, new Object[0]);
                        if (map == null) continue;
                        this.properties(map);
                        continue;
                    }
                    throw new IllegalArgumentException(cls + "  " + method + "  " + PreLoadMethod.class + " must use empty parameters static Map private");
                }
            }
            this.cacheLoadProperties.add(cls);
        }
        return this;
    }

    static {
        PRESET_PARAMETER = new ConcurrentHashMap();
    }
}

