/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.cache.CacheConfig;
import cn.jiangzeyin.cache.CacheConfigField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class CacheInfo {
    private final String key;
    private long cacheTime;

    CacheInfo(String key, long cacheTime) {
        this.key = key;
        this.cacheTime = cacheTime;
    }

    void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    String getKey() {
        return this.key;
    }

    long getCacheTime() {
        return this.cacheTime;
    }

    static Map<String, CacheInfo> loadClass(Class cls) throws IllegalAccessException {
        Field[] fields;
        if (cls == null) {
            throw new NullPointerException();
        }
        HashMap<String, CacheInfo> map = new HashMap<String, CacheInfo>();
        CacheConfig cacheConfig = cls.getAnnotation(CacheConfig.class);
        for (Field field : fields = cls.getFields()) {
            if (field.getType() != String.class || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            CacheConfigField cacheConfigField = field.getAnnotation(CacheConfigField.class);
            String key = (String)field.get(null);
            if (cacheConfigField == null) {
                long cacheTime = cacheConfig != null ? cacheConfig.UNIT().toSeconds(cacheConfig.value()) : 600L;
                CacheInfo cacheInfo = new CacheInfo(key, cacheTime);
                map.put(key, cacheInfo);
                continue;
            }
            CacheInfo cacheInfo = new CacheInfo(key, cacheConfigField.UNIT().toSeconds(cacheConfigField.value()));
            map.put(key, cacheInfo);
        }
        return map;
    }
}

