/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.validator;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HtmlUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.common.validator.ErrorCondition;
import cn.jiangzeyin.common.validator.ValidatorConfig;
import cn.jiangzeyin.common.validator.ValidatorItem;
import cn.jiangzeyin.common.validator.ValidatorRule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;

@InterceptorPattens(sort=-100)
public class ParameterInterceptor
extends BaseInterceptor {
    public static int INT_MAX_LENGTH = 7;
    private static volatile Interceptor interceptor = new DefaultInterceptor();
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();

    public static void setInterceptor(Interceptor interceptor) {
        ParameterInterceptor.interceptor = interceptor;
    }

    private String getValue(ValidatorConfig validatorConfig, HttpServletRequest request, String name, MethodParameter item) {
        String configName = null;
        if (validatorConfig != null) {
            configName = validatorConfig.name();
        }
        String value = StrUtil.isNotEmpty(configName) ? request.getParameter(configName) : request.getParameter(name);
        RequestParam requestParam = (RequestParam)item.getParameterAnnotation(RequestParam.class);
        if (requestParam != null && StrUtil.isNotEmpty((CharSequence)requestParam.name())) {
            value = request.getParameter(requestParam.name());
        }
        if (value == null && interceptor != null) {
            value = interceptor.getParameter(request, name);
        }
        if (validatorConfig != null && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(validatorConfig.defaultVal())) {
            if (value == null && !validatorConfig.strEmpty()) {
                value = validatorConfig.defaultVal();
            }
            if (StrUtil.isEmpty((CharSequence)value) && validatorConfig.strEmpty()) {
                value = validatorConfig.defaultVal();
            }
        }
        if (value == null && null != requestParam && !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue())) {
            value = requestParam.defaultValue();
        }
        return value;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        super.preHandle(request, response, handler);
        if (interceptor == null) {
            return true;
        }
        HandlerMethod handlerMethod = this.getHandlerMethod();
        if (handlerMethod == null) {
            return true;
        }
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        if (methodParameters == null) {
            return true;
        }
        block0: for (MethodParameter item : methodParameters) {
            ValidatorItem[] validatorItems;
            ValidatorConfig validatorConfig = (ValidatorConfig)item.getParameterAnnotation(ValidatorConfig.class);
            if (validatorConfig == null) {
                ValidatorItem validatorItem = (ValidatorItem)item.getParameterAnnotation(ValidatorItem.class);
                if (validatorItem == null) continue;
                validatorItems = new ValidatorItem[]{validatorItem};
            } else {
                validatorItems = validatorConfig.value();
            }
            String name = item.getParameterName();
            if (name == null) {
                item.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
                name = item.getParameterName();
                if (name == null) continue;
            }
            String value = this.getValue(validatorConfig, request, name, item);
            int errorCount = 0;
            int len = validatorItems.length;
            for (int i = 0; i < len; ++i) {
                ValidatorItem validatorItem = validatorItems[i];
                if (validatorItem.unescape()) {
                    value = HtmlUtil.unescape((String)value);
                }
                if (validatorConfig != null && validatorItem.value() == ValidatorRule.CUSTOMIZE) {
                    if (this.customize(handlerMethod, item, validatorConfig, validatorItem, name, value, request, response)) continue block0;
                    return false;
                }
                boolean error = this.validator(validatorItem, value);
                if (validatorConfig == null) {
                    interceptor.error(request, response, name, value, validatorItem);
                    return false;
                }
                if (validatorConfig.errorCondition() == ErrorCondition.AND && !error) {
                    interceptor.error(request, response, name, value, validatorItem);
                    return false;
                }
                if (validatorConfig.errorCondition() != ErrorCondition.OR) continue;
                if (error) continue block0;
                if (i < len - 1 || i != len - 1 || ++errorCount != len) continue;
                interceptor.error(request, response, name, value, validatorItem);
                return false;
            }
        }
        return true;
    }

    private boolean customize(HandlerMethod handlerMethod, MethodParameter methodParameter, ValidatorConfig validatorConfig, ValidatorItem validatorItem, String name, String value, HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        Method method;
        try {
            method = ReflectUtil.getMethod((Class)handlerMethod.getBeanType(), (String)validatorConfig.customizeMethod(), (Class[])new Class[]{MethodParameter.class, String.class});
        }
        catch (SecurityException s) {
            DefaultSystemLog.ERROR().error(s.getMessage(), (Throwable)s);
            interceptor.error(request, response, name, value, validatorItem);
            return false;
        }
        if (method == null) {
            DefaultSystemLog.ERROR().error(handlerMethod.getBeanType() + "\u672a\u914d\u7f6e\u9a8c\u8bc1\u65b9\u6cd5\uff1a" + validatorConfig.customizeMethod());
            interceptor.error(request, response, name, value, validatorItem);
            return false;
        }
        Object obj = method.invoke(handlerMethod.getBean(), methodParameter, value);
        if (!Convert.toBool((Object)obj, (Boolean)false).booleanValue()) {
            interceptor.error(request, response, name, value, validatorItem);
            return false;
        }
        return true;
    }

    private int[] spiltRange(String range) {
        if (StrUtil.isEmpty((CharSequence)range)) {
            return null;
        }
        if (range.contains(":")) {
            String[] ranges = StrUtil.split((CharSequence)range, (CharSequence)":");
            if (ranges != null && ranges.length == 2) {
                int start = Convert.toInt((Object)ranges[0]);
                int end = Convert.toInt((Object)ranges[1]);
                return new int[]{start, end};
            }
        } else {
            int len = Convert.toInt((Object)range);
            return new int[]{len};
        }
        return null;
    }

    private Double[] spiltRangeDouble(String range) {
        if (StrUtil.isEmpty((CharSequence)range)) {
            return null;
        }
        Double[] doubles = new Double[3];
        if (range.contains("[") && range.endsWith("]")) {
            int start = range.indexOf("[");
            int end = range.indexOf("]");
            int len = Convert.toInt((Object)range.substring(start + 1, end));
            doubles[2] = len;
            range = range.substring(0, start);
        }
        if (range.contains(":")) {
            String[] ranges = StrUtil.split((CharSequence)range, (CharSequence)":");
            if (ranges != null && ranges.length == 2) {
                doubles[0] = Convert.toDouble((Object)ranges[0]);
                doubles[1] = Convert.toDouble((Object)ranges[1]);
            }
        } else {
            doubles[0] = Convert.toDouble((Object)range);
        }
        return doubles;
    }

    private boolean validator(ValidatorItem validatorItem, String value) {
        ValidatorRule validatorRule = validatorItem.value();
        switch (validatorRule) {
            case EMPTY: {
                if (!Validator.isNotEmpty((Object)value)) break;
                return false;
            }
            case NOT_EMPTY: 
            case NOT_BLANK: {
                if (validatorRule == ValidatorRule.NOT_EMPTY ? Validator.isEmpty((Object)value) : StrUtil.isBlank((CharSequence)value)) {
                    return false;
                }
                if (value == null) {
                    return false;
                }
                int valLen = value.length();
                int[] ranges = this.spiltRange(validatorItem.range());
                if (ranges == null || !(ranges.length == 1 ? ranges[0] != valLen : valLen < ranges[0] || valLen > ranges[1])) break;
                return false;
            }
            case GENERAL: {
                int[] ranges = this.spiltRange(validatorItem.range());
                if (!(ranges == null ? !Validator.isGeneral((CharSequence)value) : (ranges.length == 1 ? !Validator.isGeneral((CharSequence)value, (int)ranges[0]) : !Validator.isGeneral((CharSequence)value, (int)ranges[0], (int)ranges[1])))) break;
                return false;
            }
            case DECIMAL: 
            case NUMBERS: {
                if (this.validatorNumber(validatorItem, value)) break;
                return false;
            }
            case POSITIVE_INTEGER: 
            case NON_ZERO_INTEGERS: {
                String reg;
                String string = reg = validatorRule == ValidatorRule.POSITIVE_INTEGER ? "^\\+?[0-9]*$" : "^\\+?[1-9][0-9]*$";
                if (!Validator.isMactchRegex((String)reg, (CharSequence)value)) {
                    return false;
                }
                if (value.length() > INT_MAX_LENGTH) {
                    return false;
                }
                if (this.validatorNumber(validatorItem, value)) break;
                return false;
            }
        }
        return this.validator2(validatorItem, value);
    }

    private boolean validatorNumber(ValidatorItem validatorItem, String value) {
        Double[] douRange = this.spiltRangeDouble(validatorItem.range());
        if (douRange != null && douRange[2] != null) {
            int len = douRange[2].intValue();
            if (!Validator.isMactchRegex((String)("\\d+\\.\\d{" + len + "}$"), (CharSequence)value)) {
                return false;
            }
        } else if (!Validator.isNumber((String)value)) {
            return false;
        }
        if (douRange != null) {
            if (douRange[1] == null && douRange[0] != null) {
                Double doubleVal = Convert.toDouble((Object)value);
                return douRange[0].equals(doubleVal);
            }
            if (douRange[1] != null && douRange[0] != null && douRange[0] <= douRange[1]) {
                Double doubleVal = Convert.toDouble((Object)value);
                return doubleVal <= douRange[1] && doubleVal >= douRange[0];
            }
        }
        return true;
    }

    private boolean validator2(ValidatorItem validatorItem, String value) {
        ValidatorRule validatorRule = validatorItem.value();
        switch (validatorRule) {
            case EMAIL: {
                if (Validator.isEmail((CharSequence)value)) break;
                return false;
            }
            case MOBILE: {
                if (Validator.isMobile((CharSequence)value)) break;
                return false;
            }
            case URL: {
                if (Validator.isUrl((CharSequence)value)) break;
                return false;
            }
            case WORD: {
                if (Validator.isWord((CharSequence)value)) break;
                return false;
            }
            case CHINESE: {
                if (Validator.isChinese((CharSequence)value)) break;
                return false;
            }
        }
        return true;
    }

    public static class DefaultInterceptor
    implements Interceptor {
        @Override
        public void error(HttpServletRequest request, HttpServletResponse response, String parameterName, String value, ValidatorItem validatorItem) {
            JsonMessage jsonMessage = new JsonMessage(validatorItem.code(), validatorItem.msg());
            DefaultSystemLog.LogCallback logCallback = DefaultSystemLog.getLogCallback();
            if (logCallback == null) {
                DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST).info("{} {} {} {} {}", new Object[]{request.getRequestURI(), parameterName, value, validatorItem.value(), jsonMessage});
            } else {
                logCallback.log(DefaultSystemLog.LogType.REQUEST, new Object[]{request.getRequestURI(), parameterName, value, validatorItem.value(), jsonMessage});
            }
            ServletUtil.write((HttpServletResponse)response, (String)jsonMessage.toString(), (String)"application/json;charset=UTF-8");
        }

        @Override
        public String getParameter(HttpServletRequest request, String parameterName) {
            return null;
        }
    }

    public static interface Interceptor {
        public void error(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4, ValidatorItem var5);

        public String getParameter(HttpServletRequest var1, String var2);
    }
}

