/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.UnicodeUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HttpUtil;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.controller.base.RequestUtil;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public abstract class AbstractBaseControl
extends BaseCallbackController {
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    @Override
    public void resetInfo() {
        super.resetInfo();
    }

    protected String getIp() {
        return ServletUtil.getClientIP((HttpServletRequest)this.getRequest(), (String[])new String[0]);
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    protected String getCookieValue(String name) {
        Cookie cookie = ServletUtil.getCookie((HttpServletRequest)this.getRequest(), (String)name);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    protected String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected String getParameter(String name, String def) {
        String value = this.getRequest().getParameter(name);
        return value == null ? def : value;
    }

    protected int getParameterInt(String name, int def) {
        return Convert.toInt((Object)this.getParameter(name), (Integer)def);
    }

    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    protected long getParameterLong(String name, long def) {
        String value = this.getParameter(name);
        return Convert.toLong((Object)value, (Long)def);
    }

    protected long getParameterLong(String name) {
        return this.getParameterLong(name, 0L);
    }

    protected Map<String, String> getRefererParameter() {
        String referer = this.getHeader("Referer");
        return HttpUtil.decodeParamMap((String)referer, (String)"UTF-8");
    }

    protected <T> T getObject(Class<T> tClass) {
        return (T)ServletUtil.toBean((ServletRequest)this.getRequest(), tClass, (boolean)true);
    }

    protected Map<String, String> getHeaders() {
        return RequestUtil.getHeaderMapValues(this.getRequest());
    }

    protected Map<String, String[]> getParametersMap() {
        return this.getRequest().getParameterMap();
    }

    public static void clearResources() {
        THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.remove();
    }

    protected MultipartHttpServletRequest getMultiRequest() {
        HttpServletRequest request = this.getRequest();
        if (request instanceof MultipartHttpServletRequest) {
            return (MultipartHttpServletRequest)request;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
            if (multipartHttpServletRequest != null) {
                return multipartHttpServletRequest;
            }
            multipartHttpServletRequest = new StandardMultipartHttpServletRequest(request);
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(multipartHttpServletRequest);
            return multipartHttpServletRequest;
        }
        throw new IllegalArgumentException("not MultipartHttpServletRequest");
    }

    protected MultipartFile getFile(String name) {
        return this.getMultiRequest().getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        return this.getMultiRequest().getFiles(name);
    }

    protected String upload(String name) throws IOException {
        return this.upload(name, 0L);
    }

    protected String upload(String name, long size) throws IOException {
        return this.upload(size, name)[0];
    }

    protected String[] uploads(String name) throws IOException {
        return this.uploads(name, 0L);
    }

    protected String[] uploads(String name, long size) throws IOException {
        List<MultipartFile> multipartFiles = this.getFiles(name);
        String[] paths = new String[multipartFiles.size()];
        int len = multipartFiles.size();
        for (int i = 0; i < len; ++i) {
            paths[i] = this.save(multipartFiles.get(i), size);
        }
        return paths;
    }

    protected String[] upload(String ... name) throws IOException {
        return this.upload(0L, name);
    }

    protected String[] upload(long size, String ... name) throws IOException {
        Objects.requireNonNull(name);
        String[] path = new String[name.length];
        int len = path.length;
        for (int i = 0; i < len; ++i) {
            String item = name[i];
            MultipartFile multiFile = this.getFile(item);
            if (multiFile == null) continue;
            path[i] = this.save(multiFile, size);
        }
        return path;
    }

    private String save(MultipartFile multiFile, long size) throws IOException {
        String fileName = multiFile.getOriginalFilename();
        if (StrUtil.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
        }
        long fileSize = multiFile.getSize();
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (size > 0L && fileSize > size) {
            throw new IOException("too big:" + fileSize + ">" + size);
        }
        String localPath = MultipartFileConfig.getFileTempPath();
        fileName = UnicodeUtil.toUnicode((String)fileName);
        String filePath = FileUtil.normalize((String)String.format("%s/%s_%s", localPath, IdUtil.objectId(), fileName));
        FileUtil.writeFromStream((InputStream)multiFile.getInputStream(), (String)filePath);
        return filePath;
    }
}

