/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.multipart;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.UnicodeUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class MultipartFileBuilder {
    private MultipartHttpServletRequest multipartHttpServletRequest;
    private long maxSize = 0L;
    private Set<String> fieldNames = new HashSet<String>();
    private boolean multiple;
    private String[] fileExt;
    private String contentTypePrefix;
    private String[] inputStreamType;
    private String savePath;

    public MultipartFileBuilder setMaxSize(long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public MultipartFileBuilder addFieldName(String fieldName) {
        this.fieldNames.add(fieldName);
        return this;
    }

    public MultipartFileBuilder setMultiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public MultipartFileBuilder setFileExt(String ... fileExt) {
        this.fileExt = fileExt;
        return this;
    }

    public MultipartFileBuilder setInputStreamType(String ... inputStreamType) {
        this.inputStreamType = inputStreamType;
        return this;
    }

    public MultipartFileBuilder setContentTypePrefix(String contentTypePrefix) {
        this.contentTypePrefix = contentTypePrefix;
        return this;
    }

    public MultipartFileBuilder setSavePath(String savePath) {
        this.savePath = savePath;
        return this;
    }

    public String save() throws IOException {
        if (this.fieldNames.size() != 1) {
            throw new IllegalArgumentException("fieldNames size:" + this.fieldNames.size() + "  use save");
        }
        if (this.multiple) {
            throw new IllegalArgumentException("multiple use saves");
        }
        String[] paths = this.saves();
        return paths[0];
    }

    public String[] saves() throws IOException {
        if (this.fieldNames.isEmpty()) {
            throw new IllegalArgumentException("fieldNames:empty");
        }
        String[] paths = new String[this.fieldNames.size()];
        int index = 0;
        for (String fieldName : this.fieldNames) {
            if (this.multiple) {
                List multipartFiles = this.multipartHttpServletRequest.getFiles(fieldName);
                for (MultipartFile multipartFile : multipartFiles) {
                    paths[index++] = this.save(multipartFile);
                }
                continue;
            }
            MultipartFile multipartFile = this.multipartHttpServletRequest.getFile(fieldName);
            paths[index++] = this.save(multipartFile);
        }
        return paths;
    }

    private String save(MultipartFile multiFile) throws IOException {
        String fileName = multiFile.getOriginalFilename();
        if (StrUtil.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("fileName:\u4e0d\u80fd\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
        }
        long fileSize = multiFile.getSize();
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("fileSize:\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (this.fileExt != null) {
            String checkName = fileName.toLowerCase();
            for (String ext : this.fileExt) {
                if (checkName.endsWith("." + ext.toLowerCase())) continue;
                throw new IllegalArgumentException("fileExt:\u7c7b\u578b\u9519\u8bef:" + checkName + "  " + ext);
            }
        }
        if (this.maxSize > 0L && fileSize > this.maxSize) {
            throw new IOException("maxSize:too big:" + fileSize + ">" + this.maxSize);
        }
        if (this.inputStreamType != null) {
            InputStream inputStream = multiFile.getInputStream();
            String fileType = FileTypeUtil.getType((InputStream)inputStream);
            for (String type : this.inputStreamType) {
                if (type.equalsIgnoreCase(fileType)) continue;
                throw new IllegalArgumentException("inputStreamType:\u7c7b\u578b\u9519\u8bef:" + fileType + "  " + type);
            }
        }
        String localPath = this.savePath != null ? this.savePath : MultipartFileConfig.getFileTempPath();
        fileName = UnicodeUtil.toUnicode((String)fileName);
        String filePath = FileUtil.normalize((String)String.format("%s/%s_%s", localPath, IdUtil.objectId(), fileName));
        FileUtil.writeFromStream((InputStream)multiFile.getInputStream(), (String)filePath);
        if (this.contentTypePrefix != null) {
            Path source = Paths.get(filePath, new String[0]);
            String contentType = Files.probeContentType(source);
            if (contentType == null) {
                throw new IllegalArgumentException("contentTypePrefix:\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5931\u8d25");
            }
            if (!contentType.startsWith(this.contentTypePrefix)) {
                throw new IllegalArgumentException("contentTypePrefix:\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e:" + contentType);
            }
        }
        return filePath;
    }

    public MultipartFileBuilder(MultipartHttpServletRequest multipartHttpServletRequest) {
        Objects.requireNonNull(multipartHttpServletRequest);
        this.multipartHttpServletRequest = multipartHttpServletRequest;
    }
}

