/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.hutool.core.convert.Convert;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.HttpUtil;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.controller.multipart.MultipartFileBuilder;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public abstract class AbstractController
extends BaseCallbackController {
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    @Override
    public void resetInfo() {
    }

    protected String getIp() {
        return ServletUtil.getClientIP((HttpServletRequest)this.getRequest(), (String[])new String[0]);
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    protected String getCookieValue(String name) {
        Cookie cookie = ServletUtil.getCookie((HttpServletRequest)this.getRequest(), (String)name);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    protected String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected String getParameter(String name, String def) {
        String value = this.getRequest().getParameter(name);
        return value == null ? def : value;
    }

    protected int getParameterInt(String name, int def) {
        return Convert.toInt((Object)this.getParameter(name), (Integer)def);
    }

    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    protected long getParameterLong(String name, long def) {
        String value = this.getParameter(name);
        return Convert.toLong((Object)value, (Long)def);
    }

    protected long getParameterLong(String name) {
        return this.getParameterLong(name, 0L);
    }

    protected Map<String, String> getRefererParameter() {
        String referer = this.getHeader("Referer");
        return HttpUtil.decodeParamMap((String)referer, (String)"UTF-8");
    }

    protected <T> T getObject(Class<T> tClass) {
        return (T)ServletUtil.toBean((ServletRequest)this.getRequest(), tClass, (boolean)true);
    }

    protected Map<String, String> getHeaders() {
        return AbstractController.getHeaderMapValues(this.getRequest());
    }

    protected Map<String, String[]> getParametersMap() {
        return this.getRequest().getParameterMap();
    }

    public static void clearResources() {
        THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.remove();
    }

    protected MultipartHttpServletRequest getMultiRequest() {
        HttpServletRequest request = this.getRequest();
        if (request instanceof MultipartHttpServletRequest) {
            return (MultipartHttpServletRequest)request;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
            if (multipartHttpServletRequest != null) {
                return multipartHttpServletRequest;
            }
            multipartHttpServletRequest = new StandardMultipartHttpServletRequest(request);
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(multipartHttpServletRequest);
            return multipartHttpServletRequest;
        }
        throw new IllegalArgumentException("not MultipartHttpServletRequest");
    }

    protected MultipartFileBuilder createMultipart() {
        return new MultipartFileBuilder(this.getMultiRequest());
    }
}

