/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.ApplicationBuilder;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.DefaultHandlerMethodArgumentResolver;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
public class InterceptorControl
implements WebMvcConfigurer {
    @Value(value="${interceptor.initPackageName:}")
    private String loadPath;
    private static final List<Class> LOAD_OK = new ArrayList<Class>();
    private InterceptorRegistry registry;

    public void addInterceptors(InterceptorRegistry registry) {
        this.registry = registry;
        Set<Class<?>> def = this.loadApplicationInterceptor();
        if (StrUtil.isNotEmpty((CharSequence)this.loadPath)) {
            String[] paths = StrUtil.split((CharSequence)this.loadPath, (CharSequence)",");
            Collection newClassSet = CollUtil.union(def, new ArrayList());
            for (String item : paths) {
                Set classSet = ClassUtil.scanPackageByAnnotation((String)item, InterceptorPattens.class);
                newClassSet = CollUtil.union((Collection)newClassSet, (Collection)classSet);
            }
            this.loadClass(newClassSet);
        } else if (def != null) {
            this.loadClass(def);
        }
    }

    private Set<Class<?>> loadApplicationInterceptor() {
        Set<Class<? extends BaseInterceptor>> interceptorClass = ApplicationBuilder.getActiveApplication().getInterceptorClass();
        if (interceptorClass == null) {
            return null;
        }
        Class[] cls = interceptorClass.toArray(new Class[0]);
        return new HashSet(Arrays.asList(cls));
    }

    private void loadClass(Collection<Class<?>> set) {
        if (null == set) {
            return;
        }
        List<Map.Entry<Class, Integer>> newList = InterceptorControl.splitClass(set);
        if (newList != null) {
            for (Map.Entry<Class, Integer> entry : newList) {
                this.loadInterceptor(entry.getKey(), this.registry);
            }
        }
    }

    private static List<Map.Entry<Class, Integer>> splitClass(Collection<Class<?>> list) {
        HashMap sortMap = new HashMap(10);
        for (Class<?> item : list) {
            boolean isAbstract = Modifier.isAbstract(item.getModifiers());
            if (isAbstract) continue;
            if (!HandlerInterceptor.class.isAssignableFrom(item)) {
                DefaultSystemLog.getLog().error("\u52a0\u8f7d\u62e6\u622a\u5668\u5f02\u5e38: {} \u6ca1\u6709\u5b9e\u73b0 {}", item, HandlerInterceptor.class);
                continue;
            }
            InterceptorPattens interceptorPattens = item.getAnnotation(InterceptorPattens.class);
            sortMap.put(item, interceptorPattens.sort());
        }
        ArrayList newList = null;
        if (sortMap.size() >= 1) {
            newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getValue));
        }
        return newList;
    }

    private void loadInterceptor(Class<?> itemCls, InterceptorRegistry registry) {
        InterceptorPattens interceptorPattens = itemCls.getAnnotation(InterceptorPattens.class);
        Object handlerInterceptor = Singleton.get(itemCls, (Object[])new Object[0]);
        Object[] patterns = interceptorPattens.value();
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)handlerInterceptor);
        registration.addPathPatterns((String[])patterns);
        Object[] exclude = interceptorPattens.exclude();
        if (exclude.length > 0) {
            registration.excludePathPatterns((String[])exclude);
        }
        LOAD_OK.add(itemCls);
        DefaultSystemLog.getLog().debug("\u52a0\u8f7d\u62e6\u622a\u5668\uff1a{} {} {} {}", new Object[]{itemCls, Arrays.toString(patterns), Arrays.toString(exclude), interceptorPattens.sort()});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String resourceHandler = SpringUtil.getEnvironment().getProperty("interceptor.resourceHandler");
        if (StrUtil.isNotBlank((CharSequence)resourceHandler)) {
            String[] handler = (String[])ArrayUtil.toArray((Collection)StrUtil.splitTrim((CharSequence)resourceHandler, (CharSequence)","), String.class);
            ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(handler);
            String resourceLocation = SpringUtil.getEnvironment().getProperty("interceptor.resourceLocation");
            if (StrUtil.isNotBlank((CharSequence)resourceLocation)) {
                String[] location = (String[])ArrayUtil.toArray((Collection)StrUtil.splitTrim((CharSequence)resourceLocation, (CharSequence)","), String.class);
                resourceHandlerRegistration.addResourceLocations(location);
            }
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        Set<HttpMessageConverter<?>> httpMessageConverters = ApplicationBuilder.getActiveApplication().getHttpMessageConverters();
        if (httpMessageConverters != null) {
            converters.addAll(httpMessageConverters);
        }
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        if (StrUtil.isNotEmpty((CharSequence)this.loadPath)) {
            String[] paths = StrUtil.split((CharSequence)this.loadPath, (CharSequence)",");
            Collection newClassSet = null;
            for (String item : paths) {
                Set classSet = ClassUtil.scanPackageBySuper((String)item, HandlerMethodArgumentResolver.class);
                newClassSet = CollUtil.union((Collection)newClassSet, (Collection)classSet);
            }
            if (newClassSet != null) {
                for (Class clazz : newClassSet) {
                    this.addArgumentResolvers(argumentResolvers, clazz);
                }
            }
        }
        boolean ext = false;
        Set<Class<? extends HandlerMethodArgumentResolver>> methodArgumentResolvers = ApplicationBuilder.getActiveApplication().getHandlerMethodArgumentResolvers();
        if (methodArgumentResolvers != null) {
            for (Class clazz : methodArgumentResolvers) {
                this.addArgumentResolvers(argumentResolvers, clazz);
                if (ext || !ClassUtil.isAssignable(DefaultHandlerMethodArgumentResolver.class, (Class)clazz)) continue;
                ext = true;
            }
        }
        if (!ext) {
            this.addArgumentResolvers(argumentResolvers, DefaultHandlerMethodArgumentResolver.class);
        }
    }

    private void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers, Class<?> aClass) {
        if (Modifier.isAbstract(aClass.getModifiers())) {
            return;
        }
        Object methodArgumentResolver = Singleton.get(aClass, (Object[])new Object[0]);
        argumentResolvers.add((HandlerMethodArgumentResolver)methodArgumentResolver);
        DefaultSystemLog.getLog().debug("\u53c2\u6570\u89e3\u6790\u5668\uff1a" + aClass);
    }
}

