/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import java.io.Serializable;
import java.math.BigInteger;

public class JsonMessage<T>
implements Serializable {
    public static final String CODE = "code";
    public static final String MSG = "msg";
    public static final String DATA = "data";
    private int code;
    private String msg;
    private T data;

    public JsonMessage() {
    }

    public JsonMessage(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public JsonMessage(int code, String msg) {
        this(code, msg, null);
    }

    public T getData() {
        return this.data;
    }

    public <E> E getData(Class<E> tClass) {
        if (this.data == null) {
            return null;
        }
        if (tClass.isAssignableFrom(this.data.getClass())) {
            return (E)this.data;
        }
        return (E)JSONObject.parseObject((String)this.data.toString(), tClass);
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this);
    }

    public JSONObject toJson() {
        return (JSONObject)JSONObject.toJSON((Object)this);
    }

    public String dataToString() {
        T object = this.getData();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String toFormatJson() {
        return JSONObject.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public static JSONObject toJson(int code, String msg) {
        return JsonMessage.toJson(code, msg, null);
    }

    public static JSONObject toJson(int code, String msg, Object data) {
        JsonMessage<Object> jsonMessage = new JsonMessage<Object>(code, msg, data);
        return jsonMessage.toJson();
    }

    public static String getString(int code, String msg) {
        return JsonMessage.getString(code, msg, null);
    }

    public static String getString(int code, String msg, Object data) {
        return JsonMessage.toJson(code, msg, data).toString();
    }

    public static <T> JsonMessage<T> toJsonMessage(String json, Class<T> tClass) {
        JsonMessage jsonMessage = (JsonMessage)JSONObject.parseObject((String)json, JsonMessage.class);
        T data = jsonMessage.getData(tClass);
        jsonMessage.setData(data);
        return jsonMessage;
    }

    static {
        SerializeConfig serializeConfig = SerializeConfig.globalInstance;
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(BigInteger.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
    }
}

