/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseCallbackController;
import cn.jiangzeyin.controller.base.AbstractController;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    private static final ThreadLocal<BaseCallbackController> BASE_CALLBACK_CONTROLLER_THREAD_LOCAL = new ThreadLocal();

    protected void clearResources() {
        BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.remove();
    }

    public static HttpSession getSession() {
        return BaseCallbackController.getRequestAttributes().getRequest().getSession();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod = this.getHandlerMethod(handler);
        if (handlerMethod == null) {
            return true;
        }
        Object object = handlerMethod.getBean();
        Class<?> controlClass = object.getClass();
        if (BaseCallbackController.class.isAssignableFrom(controlClass)) {
            BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.set((BaseCallbackController)object);
        }
        return this.preHandle(request, response, handlerMethod);
    }

    protected HandlerMethod getHandlerMethod(Object handler) {
        if (handler instanceof HandlerMethod) {
            return (HandlerMethod)handler;
        }
        return null;
    }

    protected boolean preHandle(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws Exception {
        return true;
    }

    protected void reload() {
        BaseCallbackController baseCallbackController = BASE_CALLBACK_CONTROLLER_THREAD_LOCAL.get();
        if (baseCallbackController != null) {
            baseCallbackController.resetInfo();
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (response.getStatus() >= HttpStatus.BAD_REQUEST.value()) {
            DefaultSystemLog.LOG(DefaultSystemLog.LogType.REQUEST_ERROR).error("\u8bf7\u6c42\u9519\u8bef:" + request.getRequestURI() + "  " + response.getStatus());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            DefaultSystemLog.ERROR().error("controller \u5f02\u5e38:" + request.getRequestURL(), (Throwable)ex);
        }
        AbstractController.clearResources();
        this.clearResources();
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        String proto = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)"X-Forwarded-Proto");
        if (proto == null) {
            response.sendRedirect(url);
        } else {
            String host = request.getHeader("Host");
            if (StrUtil.isEmpty((CharSequence)host)) {
                throw new RuntimeException("\u8bf7\u914d\u7f6ehost header");
            }
            String toUrl = StrUtil.format((CharSequence)"{}://{}{}", (Object[])new Object[]{proto, host, url});
            response.sendRedirect(toUrl);
        }
    }

    public static String getHeaderProxyPath(HttpServletRequest request, String headerName) {
        String proxyPath = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)headerName);
        if (StrUtil.isEmpty((CharSequence)proxyPath)) {
            return request.getContextPath();
        }
        if ((proxyPath = FileUtil.normalize((String)(proxyPath + "/" + request.getContextPath()))).endsWith("/")) {
            proxyPath = proxyPath.substring(0, proxyPath.length() - 1);
        }
        return proxyPath;
    }
}

