/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.jiangzeyin.common.request.XssFilter;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.http.HttpMethod;

public class ParameterXssWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;
    private final ServletInputStream inputStream;
    private final byte[] body;
    private static Boolean copy;

    ParameterXssWrapper(HttpServletRequest request) throws IOException {
        super(request);
        Charset charset = HttpMethod.GET.name().equals(request.getMethod()) ? CharsetUtil.CHARSET_UTF_8 : ParameterXssWrapper.getCharset(request);
        this.parameters = XssFilter.doXss(request.getParameterMap(), charset);
        if (this.readCopyConfig()) {
            this.inputStream = request.getInputStream();
            this.body = IoUtil.readBytes((InputStream)this.inputStream);
        } else {
            this.inputStream = null;
            this.body = null;
        }
    }

    private boolean readCopyConfig() {
        if (copy != null) {
            return copy;
        }
        try {
            copy = (Boolean)SpringUtil.getEnvironment().getProperty("request.copyInputStream", Boolean.class, (Object)false);
        }
        catch (ConversionFailedException ignored) {
            copy = false;
        }
        return copy;
    }

    static Charset getCharset(HttpServletRequest request) {
        String contentType = request.getContentType();
        String charsetName = ReUtil.get((Pattern)HttpUtil.CHARSET_PATTERN, (CharSequence)contentType, (int)1);
        Charset charset = null;
        if (StrUtil.isNotBlank((CharSequence)charsetName)) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameters.keySet()).elements();
    }

    public String getParameter(String name) {
        Object[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return ArrayUtil.join((Object[])values, (CharSequence)",");
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public BufferedReader getReader() throws IOException {
        if (copy.booleanValue()) {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
        return super.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!copy.booleanValue()) {
            return super.getInputStream();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int available() throws IOException {
                return byteArrayInputStream.available();
            }

            public boolean isFinished() {
                return ParameterXssWrapper.this.inputStream.isFinished();
            }

            public boolean isReady() {
                return ParameterXssWrapper.this.inputStream.isReady();
            }

            public void setReadListener(ReadListener listener) {
                ParameterXssWrapper.this.inputStream.setReadListener(listener);
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }

            public int read(byte[] b, int off, int len) {
                return byteArrayInputStream.read(b, off, len);
            }
        };
    }
}

