/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseCallbackController {
    public void resetInfo() {
    }

    public static ServletRequestAttributes getRequestAttributes() {
        ServletRequestAttributes servletRequestAttributes = BaseCallbackController.tryGetRequestAttributes();
        Objects.requireNonNull(servletRequestAttributes);
        return servletRequestAttributes;
    }

    public static ServletRequestAttributes tryGetRequestAttributes() {
        RequestAttributes attributes = null;
        try {
            attributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (attributes == null) {
            return null;
        }
        if (attributes instanceof ServletRequestAttributes) {
            return (ServletRequestAttributes)attributes;
        }
        return null;
    }

    public static String getClientIP() {
        ServletRequestAttributes servletRequest = BaseCallbackController.tryGetRequestAttributes();
        if (servletRequest == null) {
            return null;
        }
        HttpServletRequest request = servletRequest.getRequest();
        if (request == null) {
            return null;
        }
        return ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
    }

    public static Map<String, String> getHeaderMapValues(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        HashMap<String, String> headerMapValues = new HashMap<String, String>(20);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                headerMapValues.put(name, request.getHeader(name));
            }
        }
        return headerMapValues;
    }

    public HttpServletRequest getRequest() {
        HttpServletRequest request = BaseCallbackController.getRequestAttributes().getRequest();
        Objects.requireNonNull(request, "request null");
        return request;
    }

    public HttpServletResponse getResponse() {
        HttpServletResponse response = BaseCallbackController.getRequestAttributes().getResponse();
        Objects.requireNonNull(response, "response null");
        return response;
    }

    public HttpSession getSession() {
        HttpSession session = BaseCallbackController.getRequestAttributes().getRequest().getSession();
        if (session == null) {
            session = BaseInterceptor.getSession();
        }
        Objects.requireNonNull(session, "session null");
        return session;
    }

    public ServletContext getApplication() {
        return this.getRequest().getServletContext();
    }

    public Object getAttribute(String name) {
        return BaseCallbackController.getRequestAttributes().getAttribute(name, 0);
    }

    public void setAttribute(String name, Object object) {
        BaseCallbackController.getRequestAttributes().setAttribute(name, object, 0);
    }

    public String getSessionAttribute(String name) {
        return Objects.toString(this.getSessionAttributeObj(name), "");
    }

    public Object getSessionAttributeObj(String name) {
        return BaseCallbackController.getRequestAttributes().getAttribute(name, 1);
    }

    public void removeSessionAttribute(String name) {
        BaseCallbackController.getRequestAttributes().removeAttribute(name, 1);
    }

    public void setSessionAttribute(String name, Object object) {
        BaseCallbackController.getRequestAttributes().setAttribute(name, object, 1);
    }
}

