/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.cache.RedisCacheConfig;
import cn.jiangzeyin.redis.RedisCacheManagerFactory;
import java.util.Objects;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisObjectCache {
    public static Object get(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        if (defaultDatabase < 0) {
            throw new RuntimeException("please config");
        }
        return RedisObjectCache.get(key, defaultDatabase);
    }

    public static Object get(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisCacheManager redisCacheManager = RedisCacheManagerFactory.getRedisCacheManager(database);
        String group = RedisCacheConfig.getKeyGroup(key, database);
        Cache cache = redisCacheManager.getCache(group);
        Cache.ValueWrapper valueWrapper = cache.get((Object)key);
        Object object = null;
        if (valueWrapper != null) {
            object = valueWrapper.get();
        }
        if (object != null) {
            return object;
        }
        RedisCacheConfig.DataSource dataSource = RedisCacheConfig.getDataSource();
        if (dataSource == null) {
            return null;
        }
        object = dataSource.get(key, database);
        if (object != null) {
            cache.put((Object)key, object);
        }
        return object;
    }

    public static void set(String key, Object object) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        if (defaultDatabase < 0) {
            throw new RuntimeException("please config");
        }
        RedisObjectCache.set(key, object, defaultDatabase);
    }

    public static void set(String key, Object object, int database) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(object, "object");
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisCacheManager redisCacheManager = RedisCacheManagerFactory.getRedisCacheManager(database);
        String group = RedisCacheConfig.getKeyGroup(key, database);
        Cache cache = redisCacheManager.getCache(group);
        cache.put((Object)key, object);
    }

    public static void delete(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        if (defaultDatabase < 0) {
            throw new RuntimeException("please config");
        }
        RedisObjectCache.delete(key, defaultDatabase);
    }

    public static void delete(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        redisTemplate.delete((Object)key);
    }

    public static boolean hasKey(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        if (defaultDatabase < 0) {
            throw new RuntimeException("please config");
        }
        return RedisObjectCache.hasKey(key, defaultDatabase);
    }

    public static boolean hasKey(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        return redisTemplate.hasKey((Object)key);
    }
}

