/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.cache.RedisCacheConfig;
import cn.jiangzeyin.redis.RedisCacheManagerFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.cache.Cache;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.SerializationException;

public class RedisObjectCache {
    public static Object get(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        if (defaultDatabase < 0) {
            throw new RuntimeException("please config");
        }
        return RedisObjectCache.get(key, defaultDatabase);
    }

    public static Object get(String key, int database) {
        Cache cache = RedisObjectCache.getCache(key, database);
        Object object = null;
        try {
            Cache.ValueWrapper valueWrapper = cache.get((Object)key);
            if (valueWrapper != null) {
                object = valueWrapper.get();
            }
        }
        catch (SerializationException ignored) {
            RedisObjectCache.delete(key, database);
        }
        if (object != null) {
            return object;
        }
        return RedisObjectCache.selectDataSource(cache, key, database);
    }

    private static Object selectDataSource(Cache cache, String key, int database) {
        RedisCacheConfig.DataSource dataSource = RedisCacheConfig.getDataSource();
        if (dataSource == null) {
            return null;
        }
        Object object = dataSource.get(key, database);
        if (object != null) {
            cache.put((Object)key, object);
        }
        return object;
    }

    public static <T> T get(String key, int database, Class<T> cls) {
        Cache cache = RedisObjectCache.getCache(key, database);
        Object t = cache.get((Object)key, cls);
        if (t != null) {
            return (T)t;
        }
        return (T)RedisObjectCache.selectDataSource(cache, key, database);
    }

    public static Object getAfterDelete(String key, int database) {
        Object object = RedisObjectCache.get(key, database);
        if (object != null) {
            RedisObjectCache.delete(key, database);
        }
        return object;
    }

    public static void set(String key, Object object) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        RedisObjectCache.set(key, object, defaultDatabase);
    }

    private static Cache getCache(String key, int database) {
        Objects.requireNonNull(key, "key");
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisCacheManager redisCacheManager = RedisCacheManagerFactory.getRedisCacheManager(database);
        String group = RedisCacheConfig.getKeyGroup(key, database);
        return redisCacheManager.getCache(group);
    }

    public static void set(String key, Object object, int database) {
        if (object == null) {
            RedisObjectCache.delete(key, database);
        } else {
            Cache cache = RedisObjectCache.getCache(key, database);
            cache.put((Object)key, object);
        }
    }

    public static void set(String key, Object object, int database, long time, TimeUnit timeUnit) {
        RedisObjectCache.set(key, object, database);
        RedisObjectCache.expire(key, time, timeUnit);
    }

    public static void delete(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        RedisObjectCache.delete(key, defaultDatabase);
    }

    public static void delete(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate<String, Object> redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        redisTemplate.delete((Object)key);
    }

    public static void expire(String key, long time, TimeUnit timeUnit) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        RedisObjectCache.expire(key, defaultDatabase, time, timeUnit);
    }

    public static void expire(String key, long time) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        RedisObjectCache.expire(key, defaultDatabase, time, TimeUnit.SECONDS);
    }

    public static void expire(String key, int database, long time) {
        RedisObjectCache.expire(key, database, time, TimeUnit.SECONDS);
    }

    public static void expire(String key, int database, long time, TimeUnit timeUnit) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate<String, Object> redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        redisTemplate.expire((Object)key, time, timeUnit);
    }

    public static Long getExpire(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        return RedisObjectCache.getExpire(key, defaultDatabase);
    }

    public static Long getExpire(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate<String, Object> redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        return redisTemplate.getExpire((Object)key);
    }

    public static boolean hasKey(String key) {
        int defaultDatabase = RedisCacheConfig.getDefaultDatabase();
        return RedisObjectCache.hasKey(key, defaultDatabase);
    }

    public static boolean hasKey(String key, int database) {
        Objects.requireNonNull(key);
        if (database < 0) {
            throw new RuntimeException("database error");
        }
        RedisTemplate<String, Object> redisTemplate = RedisCacheManagerFactory.getRedisTemplate(database);
        return redisTemplate.hasKey((Object)key);
    }
}

