/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin;

import java.security.SecureRandom;

public final class RandomUtil {
    private static final SecureRandom random = new SecureRandom();
    private static byte[] seeds = random.generateSeed(20);
    private static final String base = "ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678";

    private static void seeds() {
        random.nextBytes(seeds);
        random.setSeed(seeds);
    }

    private RandomUtil() {
    }

    public static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        RandomUtil.seeds();
        return sb.toString();
    }

    public static int getRandomCode(int length) {
        if (length <= 0) {
            return 0;
        }
        if (length >= 10) {
            throw new IllegalArgumentException("result data out");
        }
        int min = length > 1 ? (int)Math.pow(10.0, length - 1) : 0;
        int max = (int)(Math.pow(10.0, length) - 1.0);
        return RandomUtil.getRandom(min, max);
    }

    public static int getRandom(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        int val = random.nextInt(max) % (max - min + 1) + min;
        RandomUtil.seeds();
        return val;
    }

    public static <T> T getRandomArray(T[] objects) {
        if (objects == null || objects.length < 1) {
            throw new IllegalArgumentException("objects is null");
        }
        int index = random.nextInt(objects.length);
        RandomUtil.seeds();
        return objects[index];
    }

    public static int getWeightRandom(int[] weights) {
        int weightSum = 0;
        for (int item : weights) {
            weightSum += item;
        }
        int n = random.nextInt(weightSum);
        int m = 0;
        int result = 0;
        int len = weights.length;
        for (int i = 0; i < len; ++i) {
            int weight = weights[i];
            if (m <= n && n < m + weight) {
                result = i;
                break;
            }
            m += weight;
        }
        RandomUtil.seeds();
        return result;
    }
}

