package cn.jiangzeyin;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;

/**
 * Created by jiangzeyin on 2017/12/12.
 */
public class ArraysUtil {
    /**
     * 使用treeSet 方式数组去重
     *
     * @param objects    objects
     * @param comparator 自定义排序接口
     * @param <T>        泛型
     * @return 结果数组 自动排序
     */
    public static <T> T[] deDupeArrayByTreeSet(T[] objects, Comparator<T> comparator) {
        TreeSet<T> tTreeSet = new TreeSet<>(comparator);
        tTreeSet.addAll(Arrays.asList(objects));
        return tTreeSet.toArray(objects);
    }

    /**
     * 使用treeSet 方式数组去重
     *
     * @param objects objects
     * @param <T>     泛型
     * @return 结果数组 自动排序
     */
    public static <T> T[] deDupeArrayByTreeSet(T[] objects) {
        TreeSet<T> tTreeSet = new TreeSet<>(Arrays.asList(objects));
        return tTreeSet.toArray(objects);
    }

    /**
     * 使用HashSet 方式数组去重
     *
     * @param objects objects
     * @param <T>     泛型
     * @return 结果数组
     */
    public static <T> T[] deDupeArrayByHashSet(T[] objects) {
        HashSet<T> tTreeSet = new HashSet<>(Arrays.asList(objects));
        return tTreeSet.toArray(objects);
    }
}
