/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin;

import java.util.Random;

public class RandomUtil {
    private static final Random random = new Random();
    private static final String base = "ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678";

    private RandomUtil() {
    }

    public static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static int getRandomCode(int length) {
        int min = 1;
        int max = 9;
        int seep = 1;
        for (int i = 0; i < length - 1; ++i) {
            min *= 10;
            seep *= 10;
            ++seep;
        }
        if (seep != 1) {
            max *= seep;
        }
        return RandomUtil.getRandom(min, max);
    }

    public static int getRandom(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static <T> T getRandomArray(T[] objects) {
        if (objects == null || objects.length < 1) {
            throw new IllegalArgumentException("objects is null");
        }
        int index = random.nextInt(objects.length);
        return objects[index];
    }
}

