/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin;

import cn.jiangzeyin.SystemClock;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtil {
    private DateUtil() {
    }

    public static String formatTimeStamp(String pattern, int timeMillis) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        GregorianCalendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis((long)timeMillis * 1000L);
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(nowDate.getTime());
    }

    public static String formatTime(String pattern, long timeMillis) {
        if (pattern == null || pattern.length() == 0) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(timeMillis);
    }

    public static Date parseTime(String time, String pattern) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(time);
    }

    public static long getCurrentTimeMillis() {
        return SystemClock.now();
    }

    public static int getCurrentShortTimeMillis() {
        return (int)(DateUtil.getCurrentTimeMillis() / 1000L);
    }

    public static String getCurrentFormatTime(String pattern) {
        return DateUtil.formatTime(pattern, DateUtil.getCurrentTimeMillis());
    }

    public static Date formatTimeStamp(int date) {
        return DateUtil.formatTime((long)date * 1000L);
    }

    public static Date formatTime(Long date) {
        GregorianCalendar nowDate = new GregorianCalendar();
        nowDate.setTimeInMillis(date);
        return nowDate.getTime();
    }
}

