/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    private static final String CONFIG_LOCATION_DELIMITERS = ",; \t\n";

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isChinese(String strName) {
        char[] ch;
        for (char c : ch = strName.toCharArray()) {
            if (!StringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceChinese(String source, String replacement) {
        if (StringUtil.isEmpty(source)) {
            return "";
        }
        replacement = StringUtil.convertNULL(replacement);
        String reg = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(reg);
        Matcher mat = pat.matcher(source);
        return mat.replaceAll(replacement);
    }

    public static boolean isEmpty(String data) {
        return data == null || data.length() < 1;
    }

    public static boolean isEmpty(String data, int len) {
        boolean flag = StringUtil.isEmpty(data);
        return flag || data.length() != len;
    }

    public static boolean isEmpty(String data, int minLength, int maxLength) {
        if (data == null) {
            return true;
        }
        if (data.isEmpty()) {
            return true;
        }
        if (minLength <= 0 || maxLength <= 0) {
            throw new IllegalArgumentException(" minLength or maxLength <=0");
        }
        if (minLength > maxLength) {
            throw new IllegalArgumentException(" minLength > maxLength");
        }
        return data.length() > maxLength || data.length() < minLength;
    }

    public static String trimAll(String data) {
        if (StringUtil.isEmpty(data)) {
            return "";
        }
        return data.replaceAll("\\s*", "");
    }

    public static String filterHTML(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.trim();
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("'", "&#39;");
        return input;
    }

    public static String compileHtml(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.replaceAll("&amp;", "&");
        input = input.replaceAll("&lt;", "<");
        input = input.replaceAll("&gt;", ">");
        input = input.replaceAll("&nbsp;", " ");
        input = input.replaceAll("&#39;", "'");
        input = input.replaceAll("&quot;", "\"");
        return input.replaceAll("<br>", "\n");
    }

    public static String[] stringToArray(String str) {
        return StringUtil.stringToArray(str, CONFIG_LOCATION_DELIMITERS);
    }

    public static String[] stringToArray(String str, String separator) {
        if (str == null || separator == null) {
            return null;
        }
        int i = 0;
        StringTokenizer st = new StringTokenizer(str, separator);
        String[] array = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    public static ArrayList<String> stringToArrayList(String str, String separator) {
        ArrayList<String> arr = new ArrayList<String>();
        if (str == null || separator == null) {
            return arr;
        }
        StringTokenizer st = new StringTokenizer(str, separator);
        while (st.hasMoreTokens()) {
            arr.add(st.nextToken());
        }
        return arr;
    }

    public static int[] stringToIntArray(String str, String separator) {
        if (str == null || separator == null) {
            return null;
        }
        int i = 0;
        StringTokenizer st = new StringTokenizer(str, separator);
        int[] array = new int[st.countTokens()];
        while (st.hasMoreTokens()) {
            array[i++] = StringUtil.parseInt(st.nextToken());
        }
        return array;
    }

    public static int parseInt(String num) {
        return StringUtil.parseInt(num, 0);
    }

    public static int parseInt(Object num) {
        if (num == null) {
            return 0;
        }
        return StringUtil.parseInt(num.toString(), 0);
    }

    public static int parseInt(Object obj, int default_) {
        return StringUtil.parseInt(StringUtil.convertNULL(obj), default_);
    }

    public static int parseInt(String num, int default_) {
        if (num == null || num.length() == 0) {
            return default_;
        }
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {
            return default_;
        }
    }

    public static long parseLong(String num) {
        if (num == null) {
            return 0L;
        }
        try {
            return Long.parseLong(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static float parseFloat(String num) {
        if (num == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public static double parseDouble(String num) {
        if (num == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static String convertNULL(String input) {
        if (input == null) {
            return "";
        }
        return input.trim().intern();
    }

    public static String convertNULL(Object input) {
        if (input == null) {
            return "";
        }
        return StringUtil.convertNULL(input.toString());
    }

    public static String fromException(Throwable e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String clearPath(String input) {
        input = input.replace('\\', '/');
        return StringUtil.clearPath_(input);
    }

    private static String clearPath_(String input) {
        int i;
        int from = 0;
        int j = input.indexOf("://");
        if (j != -1) {
            from = j + 3;
        }
        if ((i = input.indexOf("//", from)) == -1) {
            return input;
        }
        String input_ = input.substring(0, i) + "/" + input.substring(i + 2);
        return StringUtil.clearPath_(input_);
    }

    public static String captureName(String inString) {
        if (StringUtil.isEmpty(inString)) {
            return "";
        }
        if (inString.length() > 1) {
            return inString.substring(0, 1).toUpperCase() + inString.substring(1);
        }
        return inString.toUpperCase();
    }

    public static String simplifyClassName(String className) {
        String[] packages = StringUtil.stringToArray(className, ".");
        if (packages == null || packages.length < 1) {
            return className;
        }
        int len = packages.length;
        if (len == 1) {
            return packages[0];
        }
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < len - 1; ++i) {
            String item = packages[i];
            name.append(item.substring(0, 1)).append(".");
        }
        name.append(packages[len - 1]);
        return name.toString();
    }
}

