/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin;

import cn.jiangzeyin.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Md5Util {
    private static MessageDigest messageDigest;

    public static String getString(String str) throws NoSuchAlgorithmException {
        if (StringUtil.isEmpty(str)) {
            throw new IllegalArgumentException("src is null");
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        byte[] b = str.getBytes();
        messageDigest.reset();
        messageDigest.update(b);
        byte[] hash = messageDigest.digest();
        StringBuilder hs = new StringBuilder();
        String s = "";
        for (byte aHash : hash) {
            s = Integer.toHexString(aHash & 0xFF);
            if (s.length() == 1) {
                hs.append("0").append(s);
                continue;
            }
            hs.append(s);
        }
        return hs.toString().toUpperCase();
    }

    public static String getFile(File file) throws IOException, NoSuchAlgorithmException {
        int len;
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        byte[] buffer = new byte[1024];
        MessageDigest digest = MessageDigest.getInstance("MD5");
        FileInputStream in = new FileInputStream(file);
        while ((len = in.read(buffer, 0, 1024)) != -1) {
            digest.update(buffer, 0, len);
        }
        in.close();
        StringBuilder sb = new StringBuilder();
        for (byte t : digest.digest()) {
            String s = Integer.toHexString(t & 0xFF);
            if (s.length() == 1) {
                s = "0" + s;
            }
            sb.append(s);
        }
        String md5 = sb.toString().toUpperCase();
        if (md5.length() != 32) {
            throw new RuntimeException(file.getPath() + " \u83b7\u53d6md5(" + md5 + ") \u957f\u5ea6\u4e0d\u662f32");
        }
        return md5;
    }

    public static byte[] getBytes(String strSrc, String charsetName) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return md5.digest(strSrc.getBytes(charsetName));
    }
}

