package cn.jijl.util.pay.ali.service;


public interface AliPayService extends AliService {

    /**
     * 支付宝APP支付
     *
     * @param orderId   支付单号
     * @param payAmount 支付金额
     * @return 返回支付签名
     */
    String aliAppPay(String orderId, double payAmount);

    /**
     * 支付宝网页支付
     *
     * @param orderId   支付单号
     * @param payAmount 支付金额
     * @return 返回form表单
     */
    String aliWebPay(String orderId, double payAmount);

    /**
     * 支付宝手机网站支付
     *
     * @param orderId   支付单号
     * @param payAmount 支付金额
     * @return 返回支付签名
     */
    String aliWapPay(String orderId, double payAmount);

    /**
     * 支付宝小程序支付
     *
     * @param orderId   支付单号
     * @param payAmount 支付金额
     * @param buyerId   支付宝用户标识
     * @return 返回支付宝交易号
     */
    String aliSpPay(String orderId, double payAmount, String buyerId);

    /**
     * 支付宝线下扫码支付
     *
     * @param orderId   支付订单
     * @param payAmount 支付金额
     * @return 用于生成二维码码串
     */
    String aliQrPay(String orderId, double payAmount);

    /**
     * 支付宝统一支付
     *
     * @param orderId   支付单号
     * @param payAmount 支付金额
     * @param payType   支付渠道
     * @return 返回支付签名或form表单
     */
    String aliPay(String orderId, double payAmount, String buyerId, String payType);

    /**
     * 支付宝退款
     *
     * @param orderId   退款单号
     * @param payAmount 退款金额
     * @return true:退款发起成功
     * @throws Exception
     */
    boolean aliPayReturn(String orderId, double payAmount) throws Exception;

    /**
     * 支付宝退款订单查询
     *
     * @param orderId 退款单号
     * @return true:退款成功
     */
    boolean aliPayReturnQuery(String orderId) throws Exception;

    /**
     * 支付宝转账
     *
     * @param alipayAccount 支付宝转账账号
     * @param payAmount     转账金额
     * @return true:转账发起成功
     * @throws Exception
     */
    boolean aliPayTransfer(String alipayAccount, double payAmount) throws Exception;

    /**
     * 支付订单查询
     *
     * @param orderId 支付单号
     * @return 返回订单当前状态
     * @throws Exception
     */
    String aliPayQuery(String orderId) throws Exception;

    /**
     * 转账订单查询
     *
     * @param orderId 支付单号
     * @return true:转账成功
     * @throws Exception
     */
    boolean aliPayTransQeury(String orderId) throws Exception;
}
