package cn.jijl.util.pay.ali.service.impl;

import cn.jijl.util.pay.ali.config.AliConfig;
import cn.jijl.util.pay.ali.service.AliPayService;
import cn.jijl.util.pay.utils.IdentityUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.domain.*;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.request.*;
import com.alipay.api.response.*;



public class AliPayServiceImpl extends AliServiceImpl implements AliPayService {

    @Override
    public String aliAppPay(String orderId, double payAmount) {
        String aliPayData = "";
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(aliPayConfig.getBody());
        model.setSubject(aliPayConfig.getSubject());
        model.setOutTradeNo(orderId);
        model.setTimeoutExpress(aliPayConfig.getTimeoutexpress());
        model.setTotalAmount(String.valueOf(payAmount));
        model.setProductCode(AliConfig.Product.PRODUCTCODE_APP);
        request.setBizModel(model);
        request.setNotifyUrl(aliPayConfig.getNotifyUrl());
        try {
            AlipayTradeAppPayResponse response = alipayClient.sdkExecute(request);
            aliPayData = response.getBody();
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return aliPayData;
    }

    @Override
    public String aliWebPay(String orderId, double payAmount) {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(aliPayConfig.getBody());
        model.setOutTradeNo(orderId);
        model.setProductCode(AliConfig.Product.PRODUCTCODE_WEB);
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(aliPayConfig.getSubject());
        request.setBizModel(model);
        request.setNotifyUrl(aliPayConfig.getNotifyUrl());
        request.setReturnUrl(aliPayConfig.getReturnUrl());
        String form = "";
        try {
            //调用SDK生成表单
            form = alipayClient.pageExecute(request).getBody();
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return form;
    }

    @Override
    public String aliWapPay(String orderId, double payAmount) {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(orderId);
        model.setSubject(aliPayConfig.getSubject());
        model.setBody(aliPayConfig.getBody());
        model.setTimeoutExpress(aliPayConfig.getTimeoutexpress());
        model.setTotalAmount(String.valueOf(payAmount));
        model.setProductCode(AliConfig.Product.PRODUCTCODE_WAP);
        model.setQuitUrl(aliPayConfig.getQuitUrl());
        request.setBizModel(model);
        request.setNotifyUrl(aliPayConfig.getNotifyUrl());
        request.setReturnUrl(aliPayConfig.getReturnUrl());
        String form = "";
        try {
            form = alipayClient.pageExecute(request).getBody();
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return form;
    }

    @Override
    public String aliSpPay(String orderId, double payAmount, String buyerId) {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
        AlipayTradeCreateModel model = new AlipayTradeCreateModel();
        model.setOutTradeNo(orderId);
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(aliPayConfig.getSubject());
        model.setBody(aliPayConfig.getBody());
        model.setBuyerId(buyerId);
        request.setBizModel(model);
        request.setNotifyUrl(aliPayConfig.getNotifyUrl());
        String tradeNo = "";
        try {
            tradeNo = alipayClient.execute(request).getTradeNo();
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return tradeNo;
    }

    @Override
    public String aliQrPay(String orderId, double payAmount) {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        AlipayTradePrecreateModel model = new AlipayTradePrecreateModel();
        model.setOutTradeNo(orderId);
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(aliPayConfig.getSubject());
        model.setBody(aliPayConfig.getBody());
        request.setBizModel(model);
        request.setNotifyUrl(aliPayConfig.getNotifyUrl());
        String qrcode = "";
        try {
            qrcode = alipayClient.execute(request).getQrCode();
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return qrcode;
    }

    @Override
    public String aliPay(String orderId, double payAmount, String buyerId, String payType) {
        String aliData = null;
        if (AliConfig.payType.ALI_APP.equals(payType)) {
            aliData = aliAppPay(orderId, payAmount);
        } else if (AliConfig.payType.ALI_WEB.equals(payType)) {
            aliData = aliWebPay(orderId, payAmount);
        } else if (AliConfig.payType.ALI_WAP.equals(payType)) {
            aliData = aliWapPay(orderId, payAmount);
        } else if (AliConfig.payType.ALI_SP.equals(payType)) {
            aliData = aliSpPay(orderId, payAmount, buyerId);
        } else if (AliConfig.payType.ALI_QR.equals(payType)) {
            aliData = aliQrPay(orderId, payAmount);
        }
        return aliData;
    }

    @Override
    public boolean aliPayReturn(String orderId, double payAmount) throws Exception {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeRefundResponse response = null;
        try {
            AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
            AlipayTradeRefundModel model = new AlipayTradeRefundModel();
            model.setOutTradeNo(orderId);
            model.setRefundAmount(String.valueOf(payAmount));
            model.setOutRequestNo(IdentityUtil.uuid());
            request.setBizModel(model);
            response = alipayClient.execute(request);
            if (response.isSuccess()) {
                return true;
            }
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayReturnQuery(String orderId) throws Exception {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeFastpayRefundQueryResponse response = null;
        AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        model.setOutRequestNo(orderId);
        model.setOutTradeNo(orderId);
        request.setBizModel(model);
        try {
            response = alipayClient.execute(request);
            if (response.isSuccess()) {
                return true;
            }
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayTransfer(String alipayAccount, double payAmount) throws Exception {
        AlipayClient alipayClient = getAliPayClient();
        AlipayFundTransToaccountTransferResponse response = null;
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        AlipayFundTransToaccountTransferModel model = new AlipayFundTransToaccountTransferModel();
        model.setAmount(String.valueOf(payAmount));
        model.setOutBizNo(IdentityUtil.uuid());
        model.setPayeeAccount(alipayAccount);
        model.setPayeeType(AliConfig.PayeeType.ALIPAY_LOGONID);
        request.setBizModel(model);
        try {
            response = alipayClient.execute(request);
            if (response.isSuccess() && !StringUtils.isEmpty(response.getPayDate())) {
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }


    @Override
    public String aliPayQuery(String orderId) throws Exception {
        AlipayClient alipayClient = getAliPayClient();
        AlipayTradeQueryResponse response = null;
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderId);
        request.setBizModel(model);
        try {
            response = alipayClient.execute(request);
            if (response.isSuccess()) {
                return response.getTradeStatus();
            }
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayTransQeury(String orderId) throws Exception {
        AlipayClient alipayClient = getAliPayClient();
        AlipayFundTransOrderQueryResponse response = null;
        try {
            AlipayFundTransOrderQueryRequest request = new AlipayFundTransOrderQueryRequest();
            AlipayFundTransOrderQueryModel model = new AlipayFundTransOrderQueryModel();
            model.setOutBizNo(orderId);
            request.setBizModel(model);
            response = alipayClient.execute(request);
            if (response.isSuccess() && ("SUCCESS".equalsIgnoreCase(response.getStatus()))) {
                return true;
            }
        } catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

}
