package cn.jijl.util.pay.wx.service.impl;

import cn.jijl.util.pay.utils.HttpClientUtil;
import cn.jijl.util.pay.utils.IdentityUtil;
import cn.jijl.util.pay.wx.entity.WxOAuth2Info;
import cn.jijl.util.pay.wx.entity.WxRequest;
import cn.jijl.util.pay.wx.entity.WxScanSign;
import cn.jijl.util.pay.wx.entity.WxUserInfo;
import cn.jijl.util.pay.wx.service.WxAuthService;
import com.alibaba.fastjson.JSON;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;


public class WxAuthServiceImpl extends WxServiceImpl implements WxAuthService {

    @Override
    public String wxPpOAuth2CodeAuthorizationUrl(String redirectUrl, String scope, String state) {
        String str = null;
        try {
            checkOAuth2CodeAuthorizationUrl(redirectUrl, scope, state);
            str = String.format(WxRequest.PP_CODE_AUTHORIZATION_URL, wxConfig.getPpAppId(), URLEncoder.encode(redirectUrl, "utf-8"), scope, state);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    @Override
    public String wxOpOAuth2CodeAuthorizationUrl(String redirectUrl, String state) {
        String str = null;
        try {
            checkOAuth2CodeAuthorizationUrl(redirectUrl, WxRequest.oAuth2Scope.SNSAPI_LOGIN, state);
            str = String.format(WxRequest.OP_CODE_AUTHORIZATION_URL, wxConfig.getOpAppId(), URLEncoder.encode(redirectUrl, "utf-8"), WxRequest.oAuth2Scope.SNSAPI_LOGIN, state);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    @Override
    public WxOAuth2Info wxOpOAuth2AccessToken(String code) throws Exception {
        String url = String.format(WxRequest.UNIFIED_ACCESSTOKEN_URL, wxConfig.getOpAppId(), wxConfig.getOpSecrect(), code);
        return getWxOAuth2Info(url);
    }

    @Override
    public WxOAuth2Info wxPpOAuth2AccessToken(String code) throws Exception {
        String url = String.format(WxRequest.UNIFIED_ACCESSTOKEN_URL, wxConfig.getPpAppId(), wxConfig.getPpSecrect(), code);
        return getWxOAuth2Info(url);
    }

    @Override
    public WxOAuth2Info wxSpOAuth2AccessToken(String code) throws Exception {
        String url = null;
        if (code == null || "".equals(code)) {
            url = String.format(WxRequest.SP_GET_ACCESSTOKEN_URL, wxConfig.getSpAppId(), wxConfig.getSpSecrect());
        } else {
            url = String.format(WxRequest.SP_ACCESSTOKEN_URL, wxConfig.getSpAppId(), wxConfig.getSpSecrect(), code);
        }
        return getWxOAuth2Info(url);
    }

    @Override
    public WxUserInfo wxOAuth2getUserInfo(String accessToken, String openId) throws Exception {
        String url = String.format(WxRequest.UNIFIED_OAUTH2_USERINFO_URL, accessToken, openId);
        return getWxUserInfo(url);
    }

    @Override
    public WxOAuth2Info wxPpOAuth2ScanAccessToken() throws Exception {
        String url = String.format(WxRequest.PP_SCAN_ACCESSTOKEN_URL, wxConfig.getPpAppId(), wxConfig.getPpSecrect());
        return getWxOAuth2Info(url);
    }

    @Override
    public WxScanSign wxPpOAuth2ScanSign(String url, String accessToken) throws Exception {
        String requestUrl = String.format(WxRequest.PP_SCAN_JSAPITICKET_URL, accessToken);
        String json = HttpClientUtil.doGet(requestUrl);
        Map<String, String> sdkMap = JSON.parseObject(json, Map.class);
        String ticket = sdkMap.get("ticket");
        return scanSign(url, ticket);
    }

    private void checkOAuth2CodeAuthorizationUrl(String redirectUrl, String scope, String state) throws Exception {
        if (redirectUrl == null || "".equals(redirectUrl)) {
            throw new NullPointerException("redirectUrl is not null");
        }
        if (state == null || "".equals(state)) {
            state = "state";
        }
        System.out.println(scope);
        if (!WxRequest.oAuth2Scope.SNSAPI_BASE.equals(scope) && !WxRequest.oAuth2Scope.SNSAPI_USERINFO.equals(scope) && !WxRequest.oAuth2Scope.SNSAPI_LOGIN.equals(scope)) {
            throw new Exception("scope is null or error");
        }
    }

    private WxOAuth2Info getWxOAuth2Info(String url) throws Exception {
        String json = HttpClientUtil.doGet(url);
        if (json.toLowerCase().contains(WxRequest.error.err_code)) {
            throw new Exception(json);
        }
        return JSON.parseObject(json, WxOAuth2Info.class);
    }

    private WxUserInfo getWxUserInfo(String url) throws Exception {
        String json = HttpClientUtil.doGet(url);
        if (json.toLowerCase().contains(WxRequest.error.err_code)) {
            throw new Exception(json);
        }
        return JSON.parseObject(json, WxUserInfo.class);
    }

    private WxScanSign scanSign(String url, String ticket) {
        String nonce_str = IdentityUtil.uuid();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000);
        StringBuffer sb = new StringBuffer();
        sb.append("jsapi_ticket=" + ticket);
        sb.append("&noncestr=" + nonce_str);
        sb.append("&timestamp=" + timestamp);
        sb.append("&url=" + url);
        String signature = IdentityUtil.shaSign(sb.toString());
        WxScanSign wxScanSign = new WxScanSign();
        wxScanSign.setAppId(wxConfig.getPpAppId());
        wxScanSign.setNonceStr(nonce_str);
        wxScanSign.setTimestamp(timestamp);
        wxScanSign.setSignature(signature);
        return wxScanSign;
    }

}
