package cn.jijl.util.pay.wx.service.impl;

import cn.jijl.util.pay.utils.ClientCustomSSL;
import cn.jijl.util.pay.utils.HttpClientUtil;
import cn.jijl.util.pay.utils.IdentityUtil;
import cn.jijl.util.pay.utils.XMLUtil;
import cn.jijl.util.pay.wx.entity.WxRequest;
import cn.jijl.util.pay.wx.service.WxPayService;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;


public class WxPayServiceImpl extends WxServiceImpl implements WxPayService {


    @Override
    public Map wxAppPay(String orderId, double payAmount) {
        String prepayId = wxPayInitialization(orderId, payAmount, null, WxRequest.WX_APP_PAY);
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokePaymentAPP.APPID, wxConfig.getOpAppId());
        map.put(WxRequest.evokePaymentAPP.PARTNERID, wxConfig.getOpMchId());
        map.put(WxRequest.evokePaymentAPP.PREPAYID, prepayId);
        map.put(WxRequest.evokePaymentAPP.PACKAGE, "Sign=WXPay");
        map.put(WxRequest.evokePaymentAPP.NONCESTR, IdentityUtil.uuid());
        map.put(WxRequest.evokePaymentAPP.TIMESTAMP, IdentityUtil.getTimeStamp());
        map.put(WxRequest.evokePaymentAPP.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
        return map;
    }

    @Override
    public Map wxPpPay(String orderId, double payAmount, String openId) {
        String prepayId = wxPayInitialization(orderId, payAmount, openId, WxRequest.WX_PP_PAY);
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokePaymentJSAPI.APPID, wxConfig.getPpAppId());
        map.put(WxRequest.evokePaymentJSAPI.TIMESTAMP, IdentityUtil.getTimeStamp());
        map.put(WxRequest.evokePaymentJSAPI.NONCESTR, IdentityUtil.uuid());
        map.put(WxRequest.evokePaymentJSAPI.PACKAGE, "prepay_id=" + prepayId);
        map.put(WxRequest.evokePaymentJSAPI.SIGNTYPE, "MD5");
        map.put(WxRequest.evokePaymentJSAPI.PAYSIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
        return map;
    }


    @Override
    public Map wxWebPay(String orderId, double payAmount) {
        String codeUrl = wxPayInitialization(orderId, payAmount, null, WxRequest.WX_WEB_PAY);
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokePaymentNATIVE.CODE_URL, codeUrl);
        return map;
    }

    @Override
    public Map wxSpPay(String orderId, double payAmount, String openId) {
        String prepayId = wxPayInitialization(orderId, payAmount, openId, WxRequest.WX_SP_PAY);
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokePaymentJSAPI.APPID, wxConfig.getSpAppId());
        map.put(WxRequest.evokePaymentJSAPI.TIMESTAMP, IdentityUtil.getTimeStamp());
        map.put(WxRequest.evokePaymentJSAPI.NONCESTR, IdentityUtil.uuid());
        map.put(WxRequest.evokePaymentJSAPI.PACKAGE, "prepay_id=" + prepayId);
        map.put(WxRequest.evokePaymentJSAPI.SIGNTYPE, "MD5");
        map.put(WxRequest.evokePaymentJSAPI.PAYSIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
        return map;
    }

    @Override
    public Map wxPay(String orderId, double payAmount, String openId, String payType) {
        Map<String, String> map = null;
        if (WxRequest.WX_APP_PAY.equals(payType)) {
            map = wxAppPay(orderId, payAmount);
        } else if (WxRequest.WX_WEB_PAY.equals(payType)) {
            map = wxWebPay(orderId, payAmount);
        } else if (WxRequest.WX_PP_PAY.equals(payType)) {
            map = wxPpPay(orderId, payAmount, openId);
        } else if (WxRequest.WX_SP_PAY.equals(payType)) {
            map = wxSpPay(orderId, payAmount, openId);
        }
        return map;
    }


    @Override
    public boolean wxReturn(String orderId, double allMoney, double money, String payType) throws RuntimeException {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokeRefund.NONCE_STR, IdentityUtil.uuid());
        map.put(WxRequest.evokeRefund.OUT_TRADE_NO, orderId);
        map.put(WxRequest.evokeRefund.OUT_REFUND_NO, IdentityUtil.uuid());
        map.put(WxRequest.evokeRefund.TOTAL_FEE, IdentityUtil.getMoeny(allMoney));
        map.put(WxRequest.evokeRefund.REFUND_FEE, IdentityUtil.getMoeny(money));
        if (WxRequest.WX_PP_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getPpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getPpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
            certPath = wxConfig.getPpCertPath();
        } else if (WxRequest.WX_APP_PAY.equals(payType) || WxRequest.WX_WEB_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getOpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getOpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
            certPath = wxConfig.getOpCertPath();
        } else if (WxRequest.WX_SP_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getSpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getSpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
            certPath = wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund(WxRequest.REFUND_URL, XMLUtil.mapToXml(map), certPath, map.get(WxRequest.evokeRefund.MCH_ID));
            map = XMLUtil.xmlToMap(result);
        } catch (Exception e) {
            throw new RuntimeException("签名错误:" + e.getMessage());
        }
        String returnCode = map.get(WxRequest.evokeRefund.RETURN_CODE);
        String resultCode = map.get(WxRequest.evokeRefund.RESULT_CODE);
        if (WxRequest.Status.SUCCESS.equals(returnCode) && WxRequest.Status.SUCCESS.equals(resultCode)) {
            return true;
        } else if (WxRequest.Status.FAIL.equals(returnCode)) {
            throw new RuntimeException(map.get(WxRequest.evokeRefund.RETURN_MSG));
        }
        throw new RuntimeException(map.get(WxRequest.error.ERR_CODE_DES));
    }

    @Override
    public String wxQuery(String orderId, String payType) {
        Map<String, String> map = wxQueryInitialization(orderId, payType);
        try {
            String result = HttpClientUtil.httpsRequest(WxRequest.CHECK_ORDER_URL, HttpClientUtil.POST, XMLUtil.mapToXml(map));
            map = XMLUtil.xmlToMap(result);
            String returnCode = map.get(WxRequest.evokeRefund.RETURN_CODE);
            String resultCode = map.get(WxRequest.evokeRefund.RESULT_CODE);
            if (WxRequest.Status.SUCCESS.equals(returnCode) && WxRequest.Status.SUCCESS.equals(resultCode)) {
                return map.get(WxRequest.evokeRefund.TRADE_STATE);
            } else if (WxRequest.Status.FAIL.equals(returnCode)) {
                throw new RuntimeException(map.get(WxRequest.evokeRefund.RETURN_MSG));
            }
        } catch (Exception e) {
            throw new RuntimeException("签名错误:" + e.getMessage());
        }
        throw new RuntimeException(map.get(WxRequest.error.ERR_CODE_DES));
    }

    @Override
    public String wxRefundQuery(String orderId, String payType) {
        Map<String, String> map = wxQueryInitialization(orderId, payType);
        try {
            String result = HttpClientUtil.httpsRequest(WxRequest.REFUND_QUERY_URL, HttpClientUtil.POST, XMLUtil.mapToXml(map));
            map = XMLUtil.xmlToMap(result);
            String code = map.get(WxRequest.evokeRefund.RETURN_CODE);
            if (WxRequest.Status.SUCCESS.equals(code)) {
                List<String> stringList = XMLUtil.getLikeByMap(map, WxRequest.evokeRefund.REFUND_STATUS_$N);
                if (stringList != null && stringList.size() > 0) {
                    return stringList.get(stringList.size() - 1);
                }
            } else if (WxRequest.Status.FAIL.equals(code)) {
                throw new RuntimeException(map.get(WxRequest.evokeRefund.RETURN_MSG));
            }

        } catch (Exception e) {
            throw new RuntimeException("签名错误:" + e.getMessage());
        }
        throw new RuntimeException(map.get(WxRequest.error.ERR_CODE_DES));
    }

    @Override
    public boolean wxTransfers(String orderId, double payAmount, String openId, String desc, String payType) {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokeTransfers.NONCE_STR, IdentityUtil.uuid());
        map.put(WxRequest.evokeTransfers.PARTNER_TRADE_NO, orderId);
        map.put(WxRequest.evokeTransfers.OPENID, openId);
        map.put(WxRequest.evokeTransfers.CHECK_NAME, "NO_CHECK");
        map.put(WxRequest.evokeTransfers.AMOUNT, IdentityUtil.getMoeny(payAmount));
        map.put(WxRequest.evokeTransfers.DESC, desc);
        map.put(WxRequest.evokeTransfers.SPBILL_CREATE_IP, IdentityUtil.getLocalhostIp());
        if (WxRequest.WX_PP_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransfers.MCH_APPID, wxConfig.getPpAppId());
            map.put(WxRequest.evokeTransfers.MCHID, wxConfig.getPpMchId());
            map.put(WxRequest.evokeTransfers.SIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
            certPath = wxConfig.getPpCertPath();
        } else if (WxRequest.WX_APP_PAY.equals(payType) || WxRequest.WX_WEB_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransfers.MCH_APPID, wxConfig.getOpAppId());
            map.put(WxRequest.evokeTransfers.MCHID, wxConfig.getOpMchId());
            map.put(WxRequest.evokeTransfers.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
            certPath = wxConfig.getOpCertPath();
        } else if (WxRequest.WX_SP_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransfers.MCH_APPID, wxConfig.getSpAppId());
            map.put(WxRequest.evokeTransfers.MCHID, wxConfig.getSpMchId());
            map.put(WxRequest.evokeTransfers.SIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
            certPath = wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund(WxRequest.TRANSFERS_WALLET_URL, XMLUtil.mapToXml(map), certPath, map.get(WxRequest.evokeTransfers.MCHID));
            map = XMLUtil.xmlToMap(result);
            String returnCode = map.get(WxRequest.evokeTransfers.RETURN_CODE);
            String resultCode = map.get(WxRequest.evokeTransfers.RESULT_CODE);
            if (WxRequest.Status.SUCCESS.equals(returnCode) && WxRequest.Status.SUCCESS.equals(resultCode)) {
                return true;
            } else if (WxRequest.Status.FAIL.equals(returnCode)) {
                throw new RuntimeException(map.get(WxRequest.evokeRefund.RETURN_MSG));
            }
        } catch (Exception e) {
            throw new RuntimeException("签名错误:" + e.getMessage());
        }
        throw new RuntimeException(map.get(WxRequest.error.ERR_CODE_DES));
    }

    @Override
    public String wxGetTransferInfo(String orderId, String payType) {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokeTransferInfo.NONCE_STR, IdentityUtil.uuid());
        map.put(WxRequest.evokeTransferInfo.PARTNER_TRADE_NO, orderId);
        if (WxRequest.WX_PP_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransferInfo.APPID, wxConfig.getPpAppId());
            map.put(WxRequest.evokeTransferInfo.MCH_ID, wxConfig.getPpMchId());
            map.put(WxRequest.evokeTransferInfo.SIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
            certPath = wxConfig.getPpCertPath();
        } else if (WxRequest.WX_APP_PAY.equals(payType) || WxRequest.WX_WEB_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransferInfo.APPID, wxConfig.getOpAppId());
            map.put(WxRequest.evokeTransferInfo.MCH_ID, wxConfig.getOpMchId());
            map.put(WxRequest.evokeTransferInfo.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
            certPath = wxConfig.getOpCertPath();
        } else if (WxRequest.WX_SP_PAY.equals(payType)) {
            map.put(WxRequest.evokeTransferInfo.APPID, wxConfig.getSpAppId());
            map.put(WxRequest.evokeTransferInfo.MCH_ID, wxConfig.getSpMchId());
            map.put(WxRequest.evokeTransferInfo.SIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
            certPath = wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund(WxRequest.GETTRANSFERINFO_URL, XMLUtil.mapToXml(map), certPath, map.get(WxRequest.evokeTransferInfo.MCH_ID));
            map = XMLUtil.xmlToMap(result);
            String code = map.get(WxRequest.evokeTransferInfo.RETURN_CODE);
            if (WxRequest.Status.SUCCESS.equals(code)) {
                return map.get(WxRequest.evokeTransferInfo.STATUS);
            } else if (WxRequest.Status.FAIL.equals(code)) {
                throw new RuntimeException(map.get(WxRequest.evokeRefund.RETURN_MSG));
            }
        } catch (Exception e) {
            throw new RuntimeException("签名错误:" + e.getMessage());
        }
        throw new RuntimeException(map.get(WxRequest.error.ERR_CODE_DES));
    }

    private Map<String, String> wxQueryInitialization(String orderId, String payType) {
        Map<String, String> map = new TreeMap<String, String>();
        map.put(WxRequest.evokeRefund.NONCE_STR, IdentityUtil.uuid());
        map.put(WxRequest.evokeRefund.OUT_TRADE_NO, orderId);
        if (WxRequest.WX_PP_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getPpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getPpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
        } else if (WxRequest.WX_APP_PAY.equals(payType) || WxRequest.WX_WEB_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getOpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getOpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
        } else if (WxRequest.WX_SP_PAY.equals(payType)) {
            map.put(WxRequest.evokeRefund.APPID, wxConfig.getSpAppId());
            map.put(WxRequest.evokeRefund.MCH_ID, wxConfig.getSpMchId());
            map.put(WxRequest.evokeRefund.SIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
        }
        return map;
    }

    private String wxPayInitialization(String orderId, double payAmount, String openId, String payType) {
        Map<String, String> map = new TreeMap<String, String>();
        try {
            map.put(WxRequest.unifiedOrder.BODY, wxConfig.getBody());
            map.put(WxRequest.unifiedOrder.NONCE_STR, IdentityUtil.uuid());
            map.put(WxRequest.unifiedOrder.NOTIFY_URL, wxConfig.getNotifyUrl());
            map.put(WxRequest.unifiedOrder.OUT_TRADE_NO, orderId);
            map.put(WxRequest.unifiedOrder.SPBILL_CREATE_IP, IdentityUtil.getLocalhostIp());
            map.put(WxRequest.unifiedOrder.TOTAL_FEE, IdentityUtil.getMoeny(payAmount));
            if (WxRequest.WX_PP_PAY.equals(payType)) {
                map.put(WxRequest.unifiedOrder.APPID, wxConfig.getPpAppId());
                map.put(WxRequest.unifiedOrder.MCH_ID, wxConfig.getPpMchId());
                map.put(WxRequest.unifiedOrder.OPENID, openId);
                map.put(WxRequest.unifiedOrder.TRADE_TYPE, WxRequest.tradeType.JSAPI);
                map.put(WxRequest.unifiedOrder.SIGN, IdentityUtil.createSign(map, wxConfig.getPpMchKey()));
            } else if (WxRequest.WX_APP_PAY.equals(payType)) {
                map.put(WxRequest.unifiedOrder.APPID, wxConfig.getOpAppId());
                map.put(WxRequest.unifiedOrder.MCH_ID, wxConfig.getOpMchId());
                map.put(WxRequest.unifiedOrder.TRADE_TYPE, WxRequest.tradeType.APP);
                map.put(WxRequest.unifiedOrder.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
            } else if (WxRequest.WX_WEB_PAY.equals(payType)) {
                map.put(WxRequest.unifiedOrder.APPID, wxConfig.getOpAppId());
                map.put(WxRequest.unifiedOrder.MCH_ID, wxConfig.getOpMchId());
                map.put(WxRequest.unifiedOrder.TRADE_TYPE, WxRequest.tradeType.NATIVE);
                map.put(WxRequest.unifiedOrder.SIGN, IdentityUtil.createSign(map, wxConfig.getOpMchKey()));
            } else if (WxRequest.WX_SP_PAY.equals(payType)) {
                map.put(WxRequest.unifiedOrder.APPID, wxConfig.getSpAppId());
                map.put(WxRequest.unifiedOrder.MCH_ID, wxConfig.getSpMchId());
                map.put(WxRequest.unifiedOrder.OPENID, openId);
                map.put(WxRequest.unifiedOrder.TRADE_TYPE, WxRequest.tradeType.JSAPI);
                map.put(WxRequest.unifiedOrder.SIGN, IdentityUtil.createSign(map, wxConfig.getSpMchKey()));
            }
        } catch (Exception e) {
            throw new RuntimeException("未初始化参数");
        }
        try {
            String xml = XMLUtil.mapToXml(map);
            String result = HttpClientUtil.httpsRequest(WxRequest.UNIFIED_ORDER_URL, HttpClientUtil.POST, xml);
            if (WxRequest.WX_WEB_PAY.equals(payType)) {
                return XMLUtil.xmlToMap(result).get(WxRequest.evokePaymentNATIVE.CODE_URL);
            }
            return XMLUtil.xmlToMap(result).get(WxRequest.unifiedOrder.PREPAY_ID);
        } catch (Exception e) {
            throw new RuntimeException("参数解析失败:" + e.getMessage());
        }
    }

}
