/*
 * Decompiled with CFR 0.152.
 */
package cn.jijl.util.pay.ali.service.impl;

import cn.jijl.util.pay.ali.service.AliAuthService;
import cn.jijl.util.pay.ali.service.impl.AliServiceImpl;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AliAuthServiceImpl
extends AliServiceImpl
implements AliAuthService {
    @Override
    public String publicAppAuthorize(String redirectUrl, String scope, String state) {
        String url = null;
        try {
            url = String.format("https://openauth.alipay.com/oauth2/publicAppAuthorize.htm?app_id=%s&scope=%s&redirect_uri=%s&state=%s", this.aliPayConfig.getAppId(), scope, URLEncoder.encode(redirectUrl, "utf-8"), state);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    @Override
    public AlipaySystemOauthTokenResponse systemOauthToken(String authCode, String refreshToken) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        if (authCode != null && !"".equals(authCode.trim())) {
            request.setCode(authCode);
            request.setGrantType("authorization_code");
        } else if (refreshToken != null && !"".equals(refreshToken.trim())) {
            request.setRefreshToken(refreshToken);
            request.setGrantType("refresh_token");
        }
        try {
            AlipaySystemOauthTokenResponse response = (AlipaySystemOauthTokenResponse)alipayClient.execute((AlipayRequest)request);
            return response;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AlipayUserInfoShareResponse getUserInfoShare(String accessToken) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        try {
            AlipayUserInfoShareResponse response = (AlipayUserInfoShareResponse)alipayClient.execute((AlipayRequest)request, accessToken);
            if (response.isSuccess()) {
                return response;
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return null;
    }
}

