/*
 * Decompiled with CFR 0.152.
 */
package cn.jijl.util.pay.ali.service.impl;

import cn.jijl.util.pay.ali.service.AliPayService;
import cn.jijl.util.pay.ali.service.impl.AliServiceImpl;
import cn.jijl.util.pay.utils.IdentityUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayFundTransOrderQueryModel;
import com.alipay.api.domain.AlipayFundTransToaccountTransferModel;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.domain.AlipayTradeCreateModel;
import com.alipay.api.domain.AlipayTradeFastpayRefundQueryModel;
import com.alipay.api.domain.AlipayTradePrecreateModel;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.request.AlipayFundTransOrderQueryRequest;
import com.alipay.api.request.AlipayFundTransToaccountTransferRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.request.AlipayTradeCreateRequest;
import com.alipay.api.request.AlipayTradeFastpayRefundQueryRequest;
import com.alipay.api.request.AlipayTradePagePayRequest;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayFundTransOrderQueryResponse;
import com.alipay.api.response.AlipayFundTransToaccountTransferResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.alipay.api.response.AlipayTradeCreateResponse;
import com.alipay.api.response.AlipayTradeFastpayRefundQueryResponse;
import com.alipay.api.response.AlipayTradePagePayResponse;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.alipay.api.response.AlipayTradeWapPayResponse;

public class AliPayServiceImpl
extends AliServiceImpl
implements AliPayService {
    @Override
    public String aliAppPay(String orderId, double payAmount) {
        String aliPayData = "";
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(this.aliPayConfig.getBody());
        model.setSubject(this.aliPayConfig.getSubject());
        model.setOutTradeNo(orderId);
        model.setTimeoutExpress(this.aliPayConfig.getTimeoutexpress());
        model.setTotalAmount(String.valueOf(payAmount));
        model.setProductCode("QUICK_MSECURITY_PAY");
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        try {
            AlipayTradeAppPayResponse response = (AlipayTradeAppPayResponse)alipayClient.sdkExecute((AlipayRequest)request);
            aliPayData = response.getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return aliPayData;
    }

    @Override
    public String aliWebPay(String orderId, double payAmount) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradePagePayRequest request = new AlipayTradePagePayRequest();
        AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
        model.setBody(this.aliPayConfig.getBody());
        model.setOutTradeNo(orderId);
        model.setProductCode("FAST_INSTANT_TRADE_PAY");
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(this.aliPayConfig.getSubject());
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        request.setReturnUrl(this.aliPayConfig.getReturnUrl());
        String form = "";
        try {
            form = ((AlipayTradePagePayResponse)alipayClient.pageExecute((AlipayRequest)request)).getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return form;
    }

    @Override
    public String aliWapPay(String orderId, double payAmount) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeWapPayRequest request = new AlipayTradeWapPayRequest();
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(orderId);
        model.setSubject(this.aliPayConfig.getSubject());
        model.setBody(this.aliPayConfig.getBody());
        model.setTimeoutExpress(this.aliPayConfig.getTimeoutexpress());
        model.setTotalAmount(String.valueOf(payAmount));
        model.setProductCode("QUICK_WAP_WAY");
        model.setQuitUrl(this.aliPayConfig.getQuitUrl());
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        request.setReturnUrl(this.aliPayConfig.getReturnUrl());
        String form = "";
        try {
            form = ((AlipayTradeWapPayResponse)alipayClient.pageExecute((AlipayRequest)request)).getBody();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return form;
    }

    @Override
    public String aliSpPay(String orderId, double payAmount, String buyerId) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeCreateRequest request = new AlipayTradeCreateRequest();
        AlipayTradeCreateModel model = new AlipayTradeCreateModel();
        model.setOutTradeNo(orderId);
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(this.aliPayConfig.getSubject());
        model.setBody(this.aliPayConfig.getBody());
        model.setBuyerId(buyerId);
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        String tradeNo = "";
        try {
            tradeNo = ((AlipayTradeCreateResponse)alipayClient.execute((AlipayRequest)request)).getTradeNo();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return tradeNo;
    }

    @Override
    public String aliQrPay(String orderId, double payAmount) {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
        AlipayTradePrecreateModel model = new AlipayTradePrecreateModel();
        model.setOutTradeNo(orderId);
        model.setTotalAmount(String.valueOf(payAmount));
        model.setSubject(this.aliPayConfig.getSubject());
        model.setBody(this.aliPayConfig.getBody());
        request.setBizModel((AlipayObject)model);
        request.setNotifyUrl(this.aliPayConfig.getNotifyUrl());
        String qrcode = "";
        try {
            qrcode = ((AlipayTradePrecreateResponse)alipayClient.execute((AlipayRequest)request)).getQrCode();
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return qrcode;
    }

    @Override
    public String aliPay(String orderId, double payAmount, String buyerId, String payType2) {
        String aliData = null;
        if ("ALI_APP".equals(payType2)) {
            aliData = this.aliAppPay(orderId, payAmount);
        } else if ("ALI_WEB".equals(payType2)) {
            aliData = this.aliWebPay(orderId, payAmount);
        } else if ("ALI_WAP".equals(payType2)) {
            aliData = this.aliWapPay(orderId, payAmount);
        } else if ("ALI_SP".equals(payType2)) {
            aliData = this.aliSpPay(orderId, payAmount, buyerId);
        } else if ("ALI_QR".equals(payType2)) {
            aliData = this.aliQrPay(orderId, payAmount);
        }
        return aliData;
    }

    @Override
    public boolean aliPayReturn(String orderId, double payAmount) throws Exception {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeRefundResponse response = null;
        try {
            AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
            AlipayTradeRefundModel model = new AlipayTradeRefundModel();
            model.setOutTradeNo(orderId);
            model.setRefundAmount(String.valueOf(payAmount));
            model.setOutRequestNo(IdentityUtil.uuid());
            request.setBizModel((AlipayObject)model);
            response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                return true;
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayReturnQuery(String orderId) throws Exception {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeFastpayRefundQueryResponse response = null;
        AlipayTradeFastpayRefundQueryRequest request = new AlipayTradeFastpayRefundQueryRequest();
        AlipayTradeFastpayRefundQueryModel model = new AlipayTradeFastpayRefundQueryModel();
        model.setOutRequestNo(orderId);
        model.setOutTradeNo(orderId);
        request.setBizModel((AlipayObject)model);
        try {
            response = (AlipayTradeFastpayRefundQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                return true;
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayTransfer(String alipayAccount, double payAmount) throws Exception {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayFundTransToaccountTransferResponse response = null;
        AlipayFundTransToaccountTransferRequest request = new AlipayFundTransToaccountTransferRequest();
        AlipayFundTransToaccountTransferModel model = new AlipayFundTransToaccountTransferModel();
        model.setAmount(String.valueOf(payAmount));
        model.setOutBizNo(IdentityUtil.uuid());
        model.setPayeeAccount(alipayAccount);
        model.setPayeeType("ALIPAY_LOGONID");
        request.setBizModel((AlipayObject)model);
        try {
            response = (AlipayFundTransToaccountTransferResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess() && !StringUtils.isEmpty((String)response.getPayDate())) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public String aliPayQuery(String orderId) throws Exception {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayTradeQueryResponse response = null;
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(orderId);
        request.setBizModel((AlipayObject)model);
        try {
            response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess()) {
                return response.getTradeStatus();
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }

    @Override
    public boolean aliPayTransQeury(String orderId) throws Exception {
        AlipayClient alipayClient = this.getAliPayClient();
        AlipayFundTransOrderQueryResponse response = null;
        try {
            AlipayFundTransOrderQueryRequest request = new AlipayFundTransOrderQueryRequest();
            AlipayFundTransOrderQueryModel model = new AlipayFundTransOrderQueryModel();
            model.setOutBizNo(orderId);
            request.setBizModel((AlipayObject)model);
            response = (AlipayFundTransOrderQueryResponse)alipayClient.execute((AlipayRequest)request);
            if (response.isSuccess() && "SUCCESS".equalsIgnoreCase(response.getStatus())) {
                return true;
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        throw new Exception(response.getSubMsg());
    }
}

