/*
 * Decompiled with CFR 0.152.
 */
package cn.jijl.util.pay.utils;

import cn.jijl.util.pay.utils.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Formatter;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;

public class IdentityUtil {
    private static final String SYMBOLS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new SecureRandom();
    public static final String SIGN_TYPE = "MD5";
    public static final String SIGN = "sign";

    public static boolean inspectionSign(String xmlStr, String key) throws Exception {
        Map<String, String> data = XMLUtil.xmlToMap(xmlStr);
        if (!data.containsKey(SIGN)) {
            return false;
        }
        String sign = data.get(SIGN);
        return IdentityUtil.generateSignature(data, key, SIGN_TYPE).equals(sign);
    }

    public static boolean inspectionSign(Map<String, String> data, String key) throws Exception {
        if (!data.containsKey(SIGN)) {
            return false;
        }
        String sign = data.get(SIGN);
        return IdentityUtil.generateSignature(data, key, SIGN_TYPE).equals(sign);
    }

    public static String generateSignature(Map<String, String> data, String key, String signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals(SIGN) || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if (SIGN_TYPE.equals(signType)) {
            return DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        }
        throw new Exception(String.format("Invalid sign_type: %s", signType));
    }

    public static String uuid() {
        String uuid = String.valueOf(UUID.randomUUID()).replace("-", "");
        uuid = uuid.substring(7);
        return uuid;
    }

    public static String getLocalhostIp() {
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().toString();
            ip = ip.substring(ip.indexOf("/") + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String createSign(Map<String, String> parameters, String secrect) {
        StringBuffer sb = new StringBuffer();
        Set<Map.Entry<String, String>> es = parameters.entrySet();
        for (Map.Entry<String, String> entry : es) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null == v || "".equals(v) || SIGN.equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + secrect);
        String sign = DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        return sign;
    }

    public static String shaSign(String str) {
        MessageDigest crypt = null;
        String signature = null;
        try {
            crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(str.getBytes("UTF-8"));
            signature = IdentityUtil.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    public static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public static String generateNonceStr() {
        char[] nonceChars = new char[32];
        for (int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }
        return new String(nonceChars);
    }

    public static String getMoeny(double price) {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(price));
        BigDecimal moeny = bigDecimal.multiply(new BigDecimal("100"));
        return moeny.setScale(0, 1).toString();
    }

    public static String getTimeStamp() {
        return String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L);
    }
}

