/*
 * Decompiled with CFR 0.152.
 */
package cn.jijl.util.pay.wx.service.impl;

import cn.jijl.util.pay.utils.HttpClientUtil;
import cn.jijl.util.pay.utils.IdentityUtil;
import cn.jijl.util.pay.wx.entity.WxOAuth2Info;
import cn.jijl.util.pay.wx.entity.WxScanSign;
import cn.jijl.util.pay.wx.entity.WxUserInfo;
import cn.jijl.util.pay.wx.service.WxAuthService;
import cn.jijl.util.pay.wx.service.impl.WxServiceImpl;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class WxAuthServiceImpl
extends WxServiceImpl
implements WxAuthService {
    @Override
    public String wxPpOAuth2CodeAuthorizationUrl(String redirectUrl, String scope, String state) {
        String str = null;
        try {
            this.checkOAuth2CodeAuthorizationUrl(redirectUrl, scope, state);
            str = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect", this.wxConfig.getPpAppId(), URLEncoder.encode(redirectUrl, "utf-8"), scope, state);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    @Override
    public String wxOpOAuth2CodeAuthorizationUrl(String redirectUrl, String state) {
        String str = null;
        try {
            this.checkOAuth2CodeAuthorizationUrl(redirectUrl, "snsapi_login", state);
            str = String.format("https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect", this.wxConfig.getOpAppId(), URLEncoder.encode(redirectUrl, "utf-8"), "snsapi_login", state);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    @Override
    public WxOAuth2Info wxOpOAuth2AccessToken(String code) throws Exception {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", this.wxConfig.getOpAppId(), this.wxConfig.getOpSecrect(), code);
        return this.getWxOAuth2Info(url);
    }

    @Override
    public WxOAuth2Info wxPpOAuth2AccessToken(String code) throws Exception {
        String url = String.format("https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code", this.wxConfig.getPpAppId(), this.wxConfig.getPpSecrect(), code);
        return this.getWxOAuth2Info(url);
    }

    @Override
    public WxOAuth2Info wxSpOAuth2AccessToken(String code) throws Exception {
        String url = null;
        url = code == null || "".equals(code) ? String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.wxConfig.getSpAppId(), this.wxConfig.getSpSecrect()) : String.format("https://api.weixin.qq.com/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code", this.wxConfig.getSpAppId(), this.wxConfig.getSpSecrect(), code);
        return this.getWxOAuth2Info(url);
    }

    @Override
    public WxUserInfo wxOAuth2getUserInfo(String accessToken, String openId) throws Exception {
        String url = String.format("https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN", accessToken, openId);
        return this.getWxUserInfo(url);
    }

    @Override
    public WxOAuth2Info wxPpOAuth2ScanAccessToken() throws Exception {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s", this.wxConfig.getPpAppId(), this.wxConfig.getPpSecrect());
        return this.getWxOAuth2Info(url);
    }

    @Override
    public WxScanSign wxPpOAuth2ScanSign(String url, String accessToken) throws Exception {
        String requestUrl = String.format("https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi", accessToken);
        String json = HttpClientUtil.doGet(requestUrl);
        Map sdkMap = (Map)JSON.parseObject((String)json, Map.class);
        String ticket = (String)sdkMap.get("ticket");
        return this.scanSign(url, ticket);
    }

    private void checkOAuth2CodeAuthorizationUrl(String redirectUrl, String scope, String state) throws Exception {
        if (redirectUrl == null || "".equals(redirectUrl)) {
            throw new NullPointerException("redirectUrl is not null");
        }
        if (state == null || "".equals(state)) {
            state = "state";
        }
        System.out.println(scope);
        if (!("snsapi_base".equals(scope) || "snsapi_userinfo".equals(scope) || "snsapi_login".equals(scope))) {
            throw new Exception("scope is null or error");
        }
    }

    private WxOAuth2Info getWxOAuth2Info(String url) throws Exception {
        String json = HttpClientUtil.doGet(url);
        if (json.toLowerCase().contains("errcode")) {
            throw new Exception(json);
        }
        return (WxOAuth2Info)JSON.parseObject((String)json, WxOAuth2Info.class);
    }

    private WxUserInfo getWxUserInfo(String url) throws Exception {
        String json = HttpClientUtil.doGet(url);
        if (json.toLowerCase().contains("errcode")) {
            throw new Exception(json);
        }
        return (WxUserInfo)JSON.parseObject((String)json, WxUserInfo.class);
    }

    private WxScanSign scanSign(String url, String ticket) {
        String nonce_str = IdentityUtil.uuid();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append("jsapi_ticket=" + ticket);
        sb.append("&noncestr=" + nonce_str);
        sb.append("&timestamp=" + timestamp);
        sb.append("&url=" + url);
        String signature = IdentityUtil.shaSign(sb.toString());
        WxScanSign wxScanSign = new WxScanSign();
        wxScanSign.setAppId(this.wxConfig.getPpAppId());
        wxScanSign.setNonceStr(nonce_str);
        wxScanSign.setTimestamp(timestamp);
        wxScanSign.setSignature(signature);
        return wxScanSign;
    }
}

