/*
 * Decompiled with CFR 0.152.
 */
package cn.jijl.util.pay.wx.service.impl;

import cn.jijl.util.pay.utils.ClientCustomSSL;
import cn.jijl.util.pay.utils.HttpClientUtil;
import cn.jijl.util.pay.utils.IdentityUtil;
import cn.jijl.util.pay.utils.XMLUtil;
import cn.jijl.util.pay.wx.entity.WxRequest;
import cn.jijl.util.pay.wx.service.WxPayService;
import cn.jijl.util.pay.wx.service.impl.WxServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WxPayServiceImpl
extends WxServiceImpl
implements WxPayService {
    @Override
    public Map wxAppPay(String orderId, double payAmount) {
        String prepayId = this.wxPayInitialization(orderId, payAmount, null, "WX_APP");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("appid", this.wxConfig.getOpAppId());
        map.put("partnerid", this.wxConfig.getOpMchId());
        map.put("prepayid", prepayId);
        map.put("package", "Sign=WXPay");
        map.put("noncestr", IdentityUtil.uuid());
        map.put("timestamp", IdentityUtil.getTimeStamp());
        map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
        return map;
    }

    @Override
    public Map wxPpPay(String orderId, double payAmount, String openId) {
        String prepayId = this.wxPayInitialization(orderId, payAmount, openId, "WX_PP");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("appId", this.wxConfig.getPpAppId());
        map.put("timeStamp", IdentityUtil.getTimeStamp());
        map.put("nonceStr", IdentityUtil.uuid());
        map.put("package", "prepay_id=" + prepayId);
        map.put("signType", "MD5");
        map.put("paySign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
        return map;
    }

    @Override
    public Map wxWebPay(String orderId, double payAmount) {
        String codeUrl = this.wxPayInitialization(orderId, payAmount, null, "WX_WEB");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("code_url", codeUrl);
        return map;
    }

    @Override
    public Map wxSpPay(String orderId, double payAmount, String openId) {
        String prepayId = this.wxPayInitialization(orderId, payAmount, openId, "WX_SP");
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("appId", this.wxConfig.getSpAppId());
        map.put("timeStamp", IdentityUtil.getTimeStamp());
        map.put("nonceStr", IdentityUtil.uuid());
        map.put("package", "prepay_id=" + prepayId);
        map.put("signType", "MD5");
        map.put("paySign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
        return map;
    }

    @Override
    public Map wxPay(String orderId, double payAmount, String openId, String payType2) {
        Map map = null;
        if ("WX_APP".equals(payType2)) {
            map = this.wxAppPay(orderId, payAmount);
        } else if ("WX_WEB".equals(payType2)) {
            map = this.wxWebPay(orderId, payAmount);
        } else if ("WX_PP".equals(payType2)) {
            map = this.wxPpPay(orderId, payAmount, openId);
        } else if ("WX_SP".equals(payType2)) {
            map = this.wxSpPay(orderId, payAmount, openId);
        }
        return map;
    }

    @Override
    public boolean wxReturn(String orderId, double allMoney, double money, String payType2) throws RuntimeException {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put("nonce_str", IdentityUtil.uuid());
        map.put("out_trade_no", orderId);
        map.put("out_refund_no", IdentityUtil.uuid());
        map.put("total_fee", IdentityUtil.getMoeny(allMoney));
        map.put("refund_fee", IdentityUtil.getMoeny(money));
        if ("WX_PP".equals(payType2)) {
            map.put("appid", this.wxConfig.getPpAppId());
            map.put("mch_id", this.wxConfig.getPpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
            certPath = this.wxConfig.getPpCertPath();
        } else if ("WX_APP".equals(payType2) || "WX_WEB".equals(payType2)) {
            map.put("appid", this.wxConfig.getOpAppId());
            map.put("mch_id", this.wxConfig.getOpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
            certPath = this.wxConfig.getOpCertPath();
        } else if ("WX_SP".equals(payType2)) {
            map.put("appid", this.wxConfig.getSpAppId());
            map.put("mch_id", this.wxConfig.getSpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
            certPath = this.wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund("https://api.mch.weixin.qq.com/secapi/pay/refund", XMLUtil.mapToXml(map), certPath, (String)map.get("mch_id"));
            map = XMLUtil.xmlToMap(result);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        String returnCode = map.get("return_code");
        String resultCode = map.get("result_code");
        if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
            return true;
        }
        if ("FAIL".equals(returnCode)) {
            throw new RuntimeException(map.get("return_msg"));
        }
        throw new RuntimeException(map.get("err_code_des"));
    }

    @Override
    public String wxQuery(String orderId, String payType2) {
        Map<String, String> map = this.wxQueryInitialization(orderId, payType2);
        try {
            String result = HttpClientUtil.httpsRequest("https://api.mch.weixin.qq.com/pay/orderquery", "POST", XMLUtil.mapToXml(map));
            map = XMLUtil.xmlToMap(result);
            String returnCode = map.get("return_code");
            String resultCode = map.get("result_code");
            if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
                return map.get("trade_state");
            }
            if ("FAIL".equals(returnCode)) {
                throw new RuntimeException(map.get("return_msg"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        throw new RuntimeException(map.get("err_code_des"));
    }

    @Override
    public String wxRefundQuery(String orderId, String payType2) {
        Map<String, String> map = this.wxQueryInitialization(orderId, payType2);
        try {
            String result = HttpClientUtil.httpsRequest("https://api.mch.weixin.qq.com/pay/refundquery", "POST", XMLUtil.mapToXml(map));
            map = XMLUtil.xmlToMap(result);
            String code = map.get("return_code");
            if ("SUCCESS".equals(code)) {
                List<String> stringList = XMLUtil.getLikeByMap(map, "refund_status_");
                if (stringList != null && stringList.size() > 0) {
                    return stringList.get(stringList.size() - 1);
                }
            } else if ("FAIL".equals(code)) {
                throw new RuntimeException(map.get("return_msg"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        throw new RuntimeException(map.get("err_code_des"));
    }

    @Override
    public boolean wxTransfers(String orderId, double payAmount, String openId, String desc, String payType2) {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put("nonce_str", IdentityUtil.uuid());
        map.put("partner_trade_no", orderId);
        map.put("openid", openId);
        map.put("check_name", "NO_CHECK");
        map.put("amount", IdentityUtil.getMoeny(payAmount));
        map.put("desc", desc);
        map.put("spbill_create_ip", IdentityUtil.getLocalhostIp());
        if ("WX_PP".equals(payType2)) {
            map.put("mch_appid", this.wxConfig.getPpAppId());
            map.put("mchid", this.wxConfig.getPpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
            certPath = this.wxConfig.getPpCertPath();
        } else if ("WX_APP".equals(payType2) || "WX_WEB".equals(payType2)) {
            map.put("mch_appid", this.wxConfig.getOpAppId());
            map.put("mchid", this.wxConfig.getOpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
            certPath = this.wxConfig.getOpCertPath();
        } else if ("WX_SP".equals(payType2)) {
            map.put("mch_appid", this.wxConfig.getSpAppId());
            map.put("mchid", this.wxConfig.getSpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
            certPath = this.wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", XMLUtil.mapToXml(map), certPath, (String)map.get("mchid"));
            map = XMLUtil.xmlToMap(result);
            String returnCode = map.get("return_code");
            String resultCode = map.get("result_code");
            if ("SUCCESS".equals(returnCode) && "SUCCESS".equals(resultCode)) {
                return true;
            }
            if ("FAIL".equals(returnCode)) {
                throw new RuntimeException(map.get("return_msg"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        throw new RuntimeException(map.get("err_code_des"));
    }

    @Override
    public String wxGetTransferInfo(String orderId, String payType2) {
        String certPath = null;
        Map<String, String> map = new TreeMap<String, String>();
        map.put("nonce_str", IdentityUtil.uuid());
        map.put("partner_trade_no", orderId);
        if ("WX_PP".equals(payType2)) {
            map.put("appid", this.wxConfig.getPpAppId());
            map.put("mch_id", this.wxConfig.getPpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
            certPath = this.wxConfig.getPpCertPath();
        } else if ("WX_APP".equals(payType2) || "WX_WEB".equals(payType2)) {
            map.put("appid", this.wxConfig.getOpAppId());
            map.put("mch_id", this.wxConfig.getOpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
            certPath = this.wxConfig.getOpCertPath();
        } else if ("WX_SP".equals(payType2)) {
            map.put("appid", this.wxConfig.getSpAppId());
            map.put("mch_id", this.wxConfig.getSpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
            certPath = this.wxConfig.getSpCertPath();
        }
        try {
            String result = ClientCustomSSL.doRefund("https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo", XMLUtil.mapToXml(map), certPath, (String)map.get("mch_id"));
            map = XMLUtil.xmlToMap(result);
            String code = map.get("return_code");
            if ("SUCCESS".equals(code)) {
                return map.get("status");
            }
            if ("FAIL".equals(code)) {
                throw new RuntimeException(map.get("return_msg"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef:" + e.getMessage());
        }
        throw new RuntimeException(map.get("err_code_des"));
    }

    private Map<String, String> wxQueryInitialization(String orderId, String payType2) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("nonce_str", IdentityUtil.uuid());
        map.put("out_trade_no", orderId);
        if ("WX_PP".equals(payType2)) {
            map.put("appid", this.wxConfig.getPpAppId());
            map.put("mch_id", this.wxConfig.getPpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
        } else if ("WX_APP".equals(payType2) || "WX_WEB".equals(payType2)) {
            map.put("appid", this.wxConfig.getOpAppId());
            map.put("mch_id", this.wxConfig.getOpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
        } else if ("WX_SP".equals(payType2)) {
            map.put("appid", this.wxConfig.getSpAppId());
            map.put("mch_id", this.wxConfig.getSpMchId());
            map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
        }
        return map;
    }

    private String wxPayInitialization(String orderId, double payAmount, String openId, String payType2) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            map.put("body", this.wxConfig.getBody());
            map.put("nonce_str", IdentityUtil.uuid());
            map.put("notify_url", this.wxConfig.getNotifyUrl());
            map.put("out_trade_no", orderId);
            map.put("spbill_create_ip", IdentityUtil.getLocalhostIp());
            map.put("total_fee", IdentityUtil.getMoeny(payAmount));
            if ("WX_PP".equals(payType2)) {
                map.put("appid", this.wxConfig.getPpAppId());
                map.put("mch_id", this.wxConfig.getPpMchId());
                map.put("openid", openId);
                map.put("trade_type", WxRequest.tradeType.JSAPI);
                map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getPpMchKey()));
            } else if ("WX_APP".equals(payType2)) {
                map.put("appid", this.wxConfig.getOpAppId());
                map.put("mch_id", this.wxConfig.getOpMchId());
                map.put("trade_type", WxRequest.tradeType.APP);
                map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
            } else if ("WX_WEB".equals(payType2)) {
                map.put("appid", this.wxConfig.getOpAppId());
                map.put("mch_id", this.wxConfig.getOpMchId());
                map.put("trade_type", WxRequest.tradeType.NATIVE);
                map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getOpMchKey()));
            } else if ("WX_SP".equals(payType2)) {
                map.put("appid", this.wxConfig.getSpAppId());
                map.put("mch_id", this.wxConfig.getSpMchId());
                map.put("openid", openId);
                map.put("trade_type", WxRequest.tradeType.JSAPI);
                map.put("sign", IdentityUtil.createSign(map, this.wxConfig.getSpMchKey()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u672a\u521d\u59cb\u5316\u53c2\u6570");
        }
        try {
            String xml = XMLUtil.mapToXml(map);
            String result = HttpClientUtil.httpsRequest("https://api.mch.weixin.qq.com/pay/unifiedorder", "POST", xml);
            if ("WX_WEB".equals(payType2)) {
                return XMLUtil.xmlToMap(result).get("code_url");
            }
            return XMLUtil.xmlToMap(result).get("prepay_id");
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
    }
}

