/*
 * Decompiled with CFR 0.152.
 */
package cn.keepbx.jpom.model;

import cn.hutool.core.util.StrUtil;
import cn.keepbx.jpom.BaseJsonMessage;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplToString;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.math.BigInteger;

public class JsonMessage<T>
extends BaseJsonMessage<T> {
    public JsonMessage(int code, String msg, T data) {
        super(code, msg, data);
    }

    public JsonMessage(int code, String msg) {
        this(code, msg, null);
    }

    public <E> E getData(Class<E> tClass) {
        return (E)JSON.to(tClass, (Object)this.data);
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString((Object)this, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public JSONObject toJson() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public static JSONObject toJson(int code, String msg) {
        return JsonMessage.toJson(code, msg, null);
    }

    public static JSONObject toJson(int code, String msg, Object data) {
        JsonMessage<Object> jsonMessage = new JsonMessage<Object>(code, msg, data);
        return jsonMessage.toJson();
    }

    public static String getString(int code, String msg) {
        return JsonMessage.getString(code, msg, null);
    }

    public static <T> JsonMessage<T> success(String msg) {
        return JsonMessage.success(msg, null);
    }

    public static <T> JsonMessage<T> success(String template, Object ... args) {
        return JsonMessage.success(StrUtil.format((CharSequence)template, (Object[])args), null);
    }

    public static <T> JsonMessage<T> success(String msg, T data) {
        return new JsonMessage<T>(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public static String getString(int code, String msg, Object data) {
        return JsonMessage.toJson(code, msg, data).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonMessage)) {
            return false;
        }
        JsonMessage other = (JsonMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonMessage;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public JsonMessage() {
    }

    static {
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.register(Long.class, (ObjectWriter)ObjectWriterImplToString.INSTANCE);
        writerProvider.register(Long.TYPE, (ObjectWriter)ObjectWriterImplToString.INSTANCE);
        writerProvider.register(BigInteger.class, (ObjectWriter)ObjectWriterImplToString.INSTANCE);
        writerProvider.register(Long.TYPE, (ObjectWriter)ObjectWriterImplToString.INSTANCE);
        JSONFactory.setUseJacksonAnnotation((boolean)false);
        JSON.config((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumsUsingName});
    }
}

