package cn.keepbx.jpom;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 通用的json 数据格式
 *
 * @author bwcx_jzy
 * @since 2017/2/6.
 * @since 1.0
 */
@Data
@NoArgsConstructor
public class BaseJsonMessage<T> implements IJsonMessage<T>, Serializable {

    public static final String CODE = "code";
    public static final String MSG = "msg";
    public static final String DATA = "data";
    /**
     * 默认数据成功 状态码
     */
    public static int DEFAULT_SUCCESS_CODE = 200;
    /**
     * 默认数据成功 状态码
     */
    public static int DEFAULT_FAIL_CODE = 405;

    protected int code;
    protected String msg;
    protected T data;

    public BaseJsonMessage(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public BaseJsonMessage(int code, String msg) {
        this(code, msg, null);
    }

    public final boolean success() {
        return this.code == DEFAULT_SUCCESS_CODE;
    }

    public static <T> IJsonMessage<T> success(String msg) {
        return success(msg, (T) null);
    }

    public static <T> IJsonMessage<T> success(String msg, T data) {
        return new BaseJsonMessage<>(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public static <T> IJsonMessage<T> fail(String msg) {
        return fail(msg, (T) null);
    }

    public static <T> IJsonMessage<T> fail(String msg, T data) {
        return new BaseJsonMessage<>(DEFAULT_FAIL_CODE, msg, data);
    }
}
