/*
 * Decompiled with CFR 0.152.
 */
package cn.keepbx.jpom;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.SystemClock;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.system.SystemUtil;
import cn.keepbx.jpom.Type;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteVersion {
    private static final Logger log = LoggerFactory.getLogger(RemoteVersion.class);
    private static final String DEFAULT_URL = "https://jpom.top/docs/release-versions.json";
    private static final String BETA_URL = "https://jpom.top/docs/beta-versions.json";
    private static String remoteVersionUrl;
    private static final int CHECK_INTERVAL = 24;
    private String tagName;
    private String agentUrl;
    private String serverUrl;
    private String changelogUrl;
    private String changelog;
    private Long lastTime;
    private Boolean upgrade;
    private Boolean beta;

    public static void setRemoteVersionUrl(String remoteVersionUrl) {
        RemoteVersion.remoteVersionUrl = remoteVersionUrl;
    }

    private static String loadDefaultUrl() {
        boolean beta = RemoteVersion.betaRelease();
        return beta ? BETA_URL : DEFAULT_URL;
    }

    public static boolean betaRelease() {
        String betaRelease = SystemPropsUtil.get((String)"JOIN_JPOM_BETA_RELEASE", (String)"");
        return Convert.toBool((Object)betaRelease, (Boolean)false);
    }

    public static void changeBetaRelease(String beta) {
        SystemPropsUtil.set((String)"JOIN_JPOM_BETA_RELEASE", (String)beta);
    }

    public static RemoteVersion loadRemoteInfo() {
        String body = "";
        try {
            String remoteVersionUrl = StrUtil.emptyToDefault((CharSequence)RemoteVersion.remoteVersionUrl, (String)RemoteVersion.loadDefaultUrl());
            remoteVersionUrl = Validator.isUrl((CharSequence)remoteVersionUrl) ? remoteVersionUrl : RemoteVersion.loadDefaultUrl();
            RemoteVersion remoteVersion = RemoteVersion.loadTransitUrl(remoteVersionUrl);
            if (remoteVersion == null || StrUtil.isEmpty((CharSequence)remoteVersion.getTagName())) {
                return null;
            }
            RemoteVersion.cacheLoadTime(remoteVersion);
            return remoteVersion;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u8fdc\u7a0b\u7248\u672c\u4fe1\u606f\u5931\u8d25:{} {}", (Object)e.getMessage(), (Object)body);
            return null;
        }
    }

    private static RemoteVersion loadTransitUrl(String remoteVersionUrl) {
        String body = "";
        try {
            log.debug("use remote version url: {}", (Object)remoteVersionUrl);
            HttpRequest request = HttpUtil.createGet((String)remoteVersionUrl, (boolean)true);
            request.timeout(10000);
            try (HttpResponse execute = request.execute();){
                body = execute.body();
            }
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            RemoteVersion remoteVersion = (RemoteVersion)jsonObject.to(RemoteVersion.class, new JSONReader.Feature[0]);
            if (StrUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{remoteVersion.getTagName(), remoteVersion.getAgentUrl(), remoteVersion.getServerUrl(), remoteVersion.getServerUrl()})) {
                return remoteVersion;
            }
            String jumpUrl = jsonObject.getString("url");
            if (StrUtil.isEmpty((CharSequence)jumpUrl)) {
                return null;
            }
            return RemoteVersion.loadTransitUrl(jumpUrl);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u8fdc\u7a0b\u7248\u672c\u4fe1\u606f\u5931\u8d25:{} {}", (Object)e.getMessage(), (Object)body);
            return null;
        }
    }

    private static void cacheLoadTime(RemoteVersion remoteVersion) {
        String changelogUrl;
        remoteVersion = (RemoteVersion)ObjectUtil.defaultIfNull((Object)remoteVersion, (Object)new RemoteVersion());
        remoteVersion.setLastTime(SystemClock.now());
        boolean isDebug = BooleanUtil.toBoolean((String)SystemUtil.get((String)"JPOM_IS_DEBUG", (String)""));
        String jpomType = SystemUtil.get((String)"JPOM_TYPE", (String)"");
        Type type = (Type)EnumUtil.fromStringQuietly(Type.class, (String)jpomType);
        Assert.notNull((Object)((Object)type), (String)"\u6ca1\u6709\u914d\u7f6e\u6b63\u786e\u7684\u73af\u5883\u53d8\u91cf", (Object[])new Object[0]);
        if (!isDebug) {
            String version = SystemUtil.get((String)"JPOM_VERSION", (String)"");
            String tagName = remoteVersion.getTagName();
            remoteVersion.setUpgrade(StrUtil.compareVersion((CharSequence)version, (CharSequence)(tagName = StrUtil.removePrefixIgnoreCase((CharSequence)tagName, (CharSequence)"v"))) < 0);
        } else {
            remoteVersion.setUpgrade(false);
        }
        String remoteUrl = type.getRemoteUrl(remoteVersion);
        if (StrUtil.isEmpty((CharSequence)remoteUrl)) {
            remoteVersion.setUpgrade(false);
        }
        if (StrUtil.isNotEmpty((CharSequence)(changelogUrl = remoteVersion.getChangelogUrl()))) {
            try (HttpResponse execute = HttpUtil.createGet((String)changelogUrl, (boolean)true).execute();){
                String body = execute.body();
                remoteVersion.setChangelog(body);
            }
        }
        File file = RemoteVersion.getFile();
        FileUtil.writeUtf8String((String)remoteVersion.toString(), (File)file);
    }

    public static RemoteVersion cacheInfo() {
        File file = RemoteVersion.getFile();
        if (!FileUtil.isFile((File)file)) {
            return null;
        }
        RemoteVersion remoteVersion = null;
        String fileStr = "";
        try {
            fileStr = FileUtil.readUtf8String((File)file);
            if (StrUtil.isEmpty((CharSequence)fileStr)) {
                return null;
            }
            remoteVersion = (RemoteVersion)JSONObject.parseObject((String)fileStr).to(RemoteVersion.class, new JSONReader.Feature[0]);
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u8fdc\u7a0b\u7248\u672c\u4fe1\u606f\u5931\u8d25:{} {}", (Object)e.getMessage(), (Object)fileStr);
        }
        Long lastTime = remoteVersion == null ? 0L : remoteVersion.getLastTime();
        lastTime = (Long)ObjectUtil.defaultIfNull((Object)lastTime, (Object)0L);
        long interval = SystemClock.now() - lastTime;
        return interval >= TimeUnit.HOURS.toMillis(24L) ? null : remoteVersion;
    }

    private static File getFile() {
        String cacheFile = SystemUtil.get((String)"JPOM_REMOTE_VERSION_CACHE_FILE", (String)"");
        Assert.state((boolean)StrUtil.isNotEmpty((CharSequence)cacheFile), (String)"\u6ca1\u6709\u914d\u7f6e\u6b63\u786e\u7684\u73af\u5883\u53d8\u91cf", (Object[])new Object[0]);
        return FileUtil.file((String)cacheFile);
    }

    public String toString() {
        return JSONObject.toJSONString((Object)this, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getAgentUrl() {
        return this.agentUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public Long getLastTime() {
        return this.lastTime;
    }

    public Boolean getUpgrade() {
        return this.upgrade;
    }

    public Boolean getBeta() {
        return this.beta;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setAgentUrl(String agentUrl) {
        this.agentUrl = agentUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setChangelogUrl(String changelogUrl) {
        this.changelogUrl = changelogUrl;
    }

    public void setChangelog(String changelog) {
        this.changelog = changelog;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }

    public void setUpgrade(Boolean upgrade) {
        this.upgrade = upgrade;
    }

    public void setBeta(Boolean beta) {
        this.beta = beta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteVersion)) {
            return false;
        }
        RemoteVersion other = (RemoteVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$lastTime = this.getLastTime();
        Long other$lastTime = other.getLastTime();
        if (this$lastTime == null ? other$lastTime != null : !((Object)this$lastTime).equals(other$lastTime)) {
            return false;
        }
        Boolean this$upgrade = this.getUpgrade();
        Boolean other$upgrade = other.getUpgrade();
        if (this$upgrade == null ? other$upgrade != null : !((Object)this$upgrade).equals(other$upgrade)) {
            return false;
        }
        Boolean this$beta = this.getBeta();
        Boolean other$beta = other.getBeta();
        if (this$beta == null ? other$beta != null : !((Object)this$beta).equals(other$beta)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        String this$agentUrl = this.getAgentUrl();
        String other$agentUrl = other.getAgentUrl();
        if (this$agentUrl == null ? other$agentUrl != null : !this$agentUrl.equals(other$agentUrl)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$changelogUrl = this.getChangelogUrl();
        String other$changelogUrl = other.getChangelogUrl();
        if (this$changelogUrl == null ? other$changelogUrl != null : !this$changelogUrl.equals(other$changelogUrl)) {
            return false;
        }
        String this$changelog = this.getChangelog();
        String other$changelog = other.getChangelog();
        return !(this$changelog == null ? other$changelog != null : !this$changelog.equals(other$changelog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $lastTime = this.getLastTime();
        result = result * 59 + ($lastTime == null ? 43 : ((Object)$lastTime).hashCode());
        Boolean $upgrade = this.getUpgrade();
        result = result * 59 + ($upgrade == null ? 43 : ((Object)$upgrade).hashCode());
        Boolean $beta = this.getBeta();
        result = result * 59 + ($beta == null ? 43 : ((Object)$beta).hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        String $agentUrl = this.getAgentUrl();
        result = result * 59 + ($agentUrl == null ? 43 : $agentUrl.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $changelogUrl = this.getChangelogUrl();
        result = result * 59 + ($changelogUrl == null ? 43 : $changelogUrl.hashCode());
        String $changelog = this.getChangelog();
        result = result * 59 + ($changelog == null ? 43 : $changelog.hashCode());
        return result;
    }
}

