/*
 * Decompiled with CFR 0.152.
 */
package cn.keepbx.jpom;

import cn.hutool.core.util.StrUtil;
import cn.keepbx.jpom.IJsonMessage;
import java.io.Serializable;

public class BaseJsonMessage<T>
implements IJsonMessage<T>,
Serializable {
    public static final String CODE = "code";
    public static final String MSG = "msg";
    public static final String DATA = "data";
    public static int DEFAULT_SUCCESS_CODE = 200;
    public static int DEFAULT_FAIL_CODE = 405;
    protected int code;
    protected String msg;
    protected T data;

    public BaseJsonMessage(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public BaseJsonMessage(int code, String msg) {
        this(code, msg, null);
    }

    @Override
    public final boolean success() {
        return this.code == DEFAULT_SUCCESS_CODE;
    }

    @Override
    public boolean fail() {
        return this.code != DEFAULT_SUCCESS_CODE;
    }

    public static <T> IJsonMessage<T> success(String msg) {
        return BaseJsonMessage.success(msg, null);
    }

    public static <T> IJsonMessage<T> success(String msg, T data) {
        return new BaseJsonMessage<T>(DEFAULT_SUCCESS_CODE, msg, data);
    }

    public static <T> IJsonMessage<T> fail(String msg) {
        return BaseJsonMessage.fail(msg, null);
    }

    public static <T> IJsonMessage<T> fail(String msg, T data) {
        return new BaseJsonMessage<T>(DEFAULT_FAIL_CODE, msg, data);
    }

    public static <T> IJsonMessage<T> success(String template, Object ... args) {
        return BaseJsonMessage.success(StrUtil.format((CharSequence)template, (Object[])args), null);
    }

    public static <T> IJsonMessage<T> fail(String template, Object ... args) {
        return BaseJsonMessage.fail(StrUtil.format((CharSequence)template, (Object[])args), null);
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseJsonMessage)) {
            return false;
        }
        BaseJsonMessage other = (BaseJsonMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseJsonMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseJsonMessage(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public BaseJsonMessage() {
    }
}

