/*
 * Decompiled with CFR 0.152.
 */
package cn.keepbx.jpom;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.keepbx.jpom.RemoteVersion;
import java.util.function.Function;

public enum Type {
    Agent("org.dromara.jpom.JpomAgentApplication", remoteVersion -> {
        RemoteVersion.RemoteVersionAuth auth;
        String jpomRemoteVersionAuth = SystemUtil.get((String)"JPOM_REMOTE_VERSION_AUTH", (String)"");
        if (StrUtil.isNotEmpty((CharSequence)jpomRemoteVersionAuth) && (auth = remoteVersion.getAuth()) != null && StrUtil.isNotEmpty((CharSequence)auth.getAgentUrl())) {
            String agentUrl = auth.getAgentUrl();
            return StrUtil.replace((CharSequence)agentUrl, (CharSequence)"{token}", (CharSequence)jpomRemoteVersionAuth);
        }
        return remoteVersion.getAgentUrl();
    }, "JPOM_AGENT_APPLICATION"),
    Server("org.dromara.jpom.JpomServerApplication", remoteVersion -> {
        RemoteVersion.RemoteVersionAuth auth;
        String jpomRemoteVersionAuth = SystemUtil.get((String)"JPOM_REMOTE_VERSION_AUTH", (String)"");
        if (StrUtil.isNotEmpty((CharSequence)jpomRemoteVersionAuth) && (auth = remoteVersion.getAuth()) != null && StrUtil.isNotEmpty((CharSequence)auth.getServerUrl())) {
            String serverUrl = auth.getServerUrl();
            return StrUtil.replace((CharSequence)serverUrl, (CharSequence)"{token}", (CharSequence)jpomRemoteVersionAuth);
        }
        return remoteVersion.getServerUrl();
    }, "JPOM_SERVER_APPLICATION");

    private final Function<RemoteVersion, String> remoteUrl;
    private final String applicationClass;
    private final String tag;

    private Type(String applicationClass, Function<RemoteVersion, String> remoteUrl, String tag) {
        this.applicationClass = applicationClass;
        this.remoteUrl = remoteUrl;
        this.tag = tag;
    }

    public String getRemoteUrl(RemoteVersion remoteVersion) {
        return this.remoteUrl.apply(remoteVersion);
    }

    public Function<RemoteVersion, String> getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public String getTag() {
        return this.tag;
    }
}

