package cn.keepbx.jpom;

import java.io.Serializable;

/**
 * json message 通用接口
 *
 * @author bwcx_jzy
 * @since 2023/8/19
 */
public interface IJsonMessage<T> extends Serializable {
    /**
     * 状态码
     *
     * @return 一般成功的状态码为 200
     */
    int getCode();

    /**
     * 返回消息
     *
     * @return ok
     */
    String getMsg();

    /**
     * 返回的数据
     *
     * @return T
     */
    T getData();

    /**
     * 设置状态码
     *
     * @param code code
     */
    void setCode(int code);

    /**
     * 设备消息
     *
     * @param msg 状态消息
     */
    void setMsg(String msg);

    /**
     * 更新数据
     *
     * @param data data
     */
    void setData(T data);

    /**
     * 是否成功
     *
     * @return true 成功
     */
    boolean success();

    /**
     * 是否异常
     *
     * @return true 异常
     */
    boolean fail();
}
