package cn.keepbx.jpom;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import lombok.Getter;

import java.util.function.Function;

/**
 * Jpom 程序类型
 *
 * @author jiangzeyin
 * @since 2019/4/17
 */
@Getter
public enum Type {
    /**
     * 插件端
     */
    Agent("org.dromara.jpom.JpomAgentApplication", remoteVersion -> {
        String jpomRemoteVersionAuth = SystemUtil.get("JPOM_REMOTE_VERSION_AUTH", "");
        if (StrUtil.isNotEmpty(jpomRemoteVersionAuth)) {
            RemoteVersion.RemoteVersionAuth auth = remoteVersion.getAuth();
            if (auth != null && StrUtil.isNotEmpty(auth.getAgentUrl())) {
                String agentUrl = auth.getAgentUrl();
                return StrUtil.replace(agentUrl, "{token}", jpomRemoteVersionAuth);
            }
        }
        return remoteVersion.getAgentUrl();
    }, "JPOM_AGENT_APPLICATION"),
    /**
     * 中心服务端
     */
    Server("org.dromara.jpom.JpomServerApplication", remoteVersion -> {
        String jpomRemoteVersionAuth = SystemUtil.get("JPOM_REMOTE_VERSION_AUTH", "");
        if (StrUtil.isNotEmpty(jpomRemoteVersionAuth)) {
            RemoteVersion.RemoteVersionAuth auth = remoteVersion.getAuth();
            if (auth != null && StrUtil.isNotEmpty(auth.getServerUrl())) {
                String serverUrl = auth.getServerUrl();
                return StrUtil.replace(serverUrl, "{token}", jpomRemoteVersionAuth);
            }
        }
        return remoteVersion.getServerUrl();
    }, "JPOM_SERVER_APPLICATION"),
    ;

    private final Function<RemoteVersion, String> remoteUrl;
    private final String applicationClass;
    private final String tag;

    Type(String applicationClass, Function<RemoteVersion, String> remoteUrl, String tag) {
        this.applicationClass = applicationClass;
        this.remoteUrl = remoteUrl;
        this.tag = tag;
    }

    public String getRemoteUrl(RemoteVersion remoteVersion) {
        return remoteUrl.apply(remoteVersion);
    }
}
