/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.ksp.kotlinpoet.block;

import cn.ktorfitx.common.ksp.util.expends.StringExpendsKt;
import cn.ktorfitx.multiplatform.ksp.constants.TypeNames;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.ClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.HttpClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.MockClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.model.AttributeModel;
import cn.ktorfitx.multiplatform.ksp.model.BodyModel;
import cn.ktorfitx.multiplatform.ksp.model.ClassModel;
import cn.ktorfitx.multiplatform.ksp.model.CookieModel;
import cn.ktorfitx.multiplatform.ksp.model.FieldModels;
import cn.ktorfitx.multiplatform.ksp.model.FunModel;
import cn.ktorfitx.multiplatform.ksp.model.HeaderModel;
import cn.ktorfitx.multiplatform.ksp.model.HeadersModel;
import cn.ktorfitx.multiplatform.ksp.model.HttpRequestModel;
import cn.ktorfitx.multiplatform.ksp.model.MockModel;
import cn.ktorfitx.multiplatform.ksp.model.PartModels;
import cn.ktorfitx.multiplatform.ksp.model.PathModel;
import cn.ktorfitx.multiplatform.ksp.model.QueryModel;
import cn.ktorfitx.multiplatform.ksp.model.RequestBodyModel;
import cn.ktorfitx.multiplatform.ksp.model.ReturnKind;
import cn.ktorfitx.multiplatform.ksp.model.TimeoutModel;
import com.squareup.kotlinpoet.CodeBlock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\f\u001a\u00020\r*\u00020\u000eJ%\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\u0002\b\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder;", "", "classModel", "Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;", "funModel", "Lcn/ktorfitx/multiplatform/ksp/model/FunModel;", "httpRequestModel", "Lcn/ktorfitx/multiplatform/ksp/model/HttpRequestModel;", "tokenVarName", "", "<init>", "(Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;Lcn/ktorfitx/multiplatform/ksp/model/FunModel;Lcn/ktorfitx/multiplatform/ksp/model/HttpRequestModel;Ljava/lang/String;)V", "buildCodeBlock", "", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "buildTryCatchIfNeed", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getClientCodeBlock", "Lcn/ktorfitx/multiplatform/ksp/kotlinpoet/block/ClientCodeBlock;", "parseToFullUrl", "url", "multiplatform-ksp"})
@SourceDebugExtension(value={"SMAP\nHttpCodeBlockBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCodeBlockBuilder.kt\ncn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1803#2,3:98\n1#3:101\n*S KotlinDebug\n*F\n+ 1 HttpCodeBlockBuilder.kt\ncn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder\n*L\n92#1:98,3\n*E\n"})
public final class HttpCodeBlockBuilder {
    @NotNull
    private final ClassModel classModel;
    @NotNull
    private final FunModel funModel;
    @NotNull
    private final HttpRequestModel httpRequestModel;
    @Nullable
    private final String tokenVarName;

    public HttpCodeBlockBuilder(@NotNull ClassModel classModel, @NotNull FunModel funModel, @NotNull HttpRequestModel httpRequestModel, @Nullable String tokenVarName) {
        Intrinsics.checkNotNullParameter((Object)classModel, (String)"classModel");
        Intrinsics.checkNotNullParameter((Object)funModel, (String)"funModel");
        Intrinsics.checkNotNullParameter((Object)httpRequestModel, (String)"httpRequestModel");
        this.classModel = classModel;
        this.funModel = funModel;
        this.httpRequestModel = httpRequestModel;
        this.tokenVarName = tokenVarName;
    }

    public final void buildCodeBlock(@NotNull CodeBlock.Builder $this$buildCodeBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"<this>");
        this.buildTryCatchIfNeed($this$buildCodeBlock, (Function1<? super CodeBlock.Builder, Unit>)((Function1)arg_0 -> HttpCodeBlockBuilder.buildCodeBlock$lambda$4(this, arg_0)));
    }

    private final void buildTryCatchIfNeed(CodeBlock.Builder $this$buildTryCatchIfNeed, Function1<? super CodeBlock.Builder, Unit> builder) {
        if (this.funModel.getReturnModel().getReturnKind() == ReturnKind.Result) {
            $this$buildTryCatchIfNeed.beginControlFlow("return try", new Object[0]);
            builder.invoke((Object)$this$buildTryCatchIfNeed);
            Object[] objectArray = new Object[]{TypeNames.INSTANCE.getCancellationException()};
            $this$buildTryCatchIfNeed.nextControlFlow("catch (e: %T)", objectArray);
            $this$buildTryCatchIfNeed.addStatement("throw e", new Object[0]);
            $this$buildTryCatchIfNeed.nextControlFlow("catch (e: Exception)", new Object[0]);
            $this$buildTryCatchIfNeed.addStatement("Result.failure(e)", new Object[0]);
            $this$buildTryCatchIfNeed.endControlFlow();
        } else {
            builder.invoke((Object)$this$buildTryCatchIfNeed);
        }
    }

    private final ClientCodeBlock getClientCodeBlock() {
        MockModel mockModel = this.funModel.getMockModel();
        return mockModel != null ? (ClientCodeBlock)new MockClientCodeBlock(mockModel, this.funModel.getReturnModel()) : (ClientCodeBlock)new HttpClientCodeBlock(this.funModel.getReturnModel());
    }

    /*
     * WARNING - void declaration
     */
    private final String parseToFullUrl(String url) {
        void $this$fold$iv;
        Object object;
        List<PathModel> pathModels = this.funModel.getPathModels();
        if (StringExpendsKt.isHttpOrHttps((String)url)) {
            object = url;
        } else {
            String apiUrl = this.classModel.getApiUrl();
            if (apiUrl == null || StringExpendsKt.isHttpOrHttps((String)url)) {
                return url;
            }
            object = apiUrl + "/" + url;
        }
        String initialUrl = object;
        Iterable iterable = pathModels;
        String initial$iv = initialUrl;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            PathModel pathModel = (PathModel)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)("{" + it.getName() + "}"), (String)("${" + it.getVarName() + "}"), (boolean)false, (int)4, null);
        }
        String fullUrl = accumulator$iv;
        return fullUrl;
    }

    private static final Unit buildCodeBlock$lambda$4$lambda$3$lambda$2(HttpCodeBlockBuilder this$0, String $url, ClientCodeBlock $this_with, CodeBlock.Builder $this$buildClientCodeBlock) {
        List<PathModel> pathModels;
        List<AttributeModel> attributeModels;
        List<CookieModel> cookieModels;
        List<QueryModel> queryModels;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$this$buildClientCodeBlock, (String)"$this$buildClientCodeBlock");
        String fullUrl = this$0.parseToFullUrl($url);
        $this_with.buildUrlString($this$buildClientCodeBlock, fullUrl);
        TimeoutModel timeoutModel = this$0.funModel.getTimeoutModel();
        if (timeoutModel != null) {
            it = timeoutModel;
            boolean bl = false;
            $this_with.buildTimeoutCodeBlock($this$buildClientCodeBlock, (TimeoutModel)it);
        }
        String string = this$0.tokenVarName;
        if (string != null) {
            it = string;
            boolean bl = false;
            $this_with.buildBearerAuth($this$buildClientCodeBlock, (String)it);
        }
        HeadersModel headersModel = this$0.funModel.getHeadersModel();
        List<HeaderModel> headerModels = this$0.funModel.getHeaderModels();
        if (headersModel != null || !((Collection)headerModels).isEmpty()) {
            $this_with.buildHeadersCodeBlock($this$buildClientCodeBlock, headersModel, headerModels);
        }
        if (!((Collection)(queryModels = this$0.funModel.getQueryModels())).isEmpty()) {
            $this_with.buildQueries($this$buildClientCodeBlock, queryModels);
        }
        if (!((Collection)(cookieModels = this$0.funModel.getCookieModels())).isEmpty()) {
            $this_with.buildCookies($this$buildClientCodeBlock, cookieModels);
        }
        if (!((Collection)(attributeModels = this$0.funModel.getAttributeModels())).isEmpty()) {
            $this_with.buildAttributes($this$buildClientCodeBlock, attributeModels);
        }
        if ($this_with instanceof MockClientCodeBlock && !((Collection)(pathModels = this$0.funModel.getPathModels())).isEmpty()) {
            ((MockClientCodeBlock)$this_with).buildPaths($this$buildClientCodeBlock, pathModels);
        }
        RequestBodyModel requestBodyModel = this$0.funModel.getRequestBodyModel();
        RequestBodyModel requestBodyModel2 = this$0.funModel.getRequestBodyModel();
        if (requestBodyModel2 instanceof BodyModel) {
            $this_with.buildBody($this$buildClientCodeBlock, (BodyModel)requestBodyModel);
        } else if (requestBodyModel2 instanceof FieldModels) {
            $this_with.buildFields($this$buildClientCodeBlock, ((FieldModels)requestBodyModel).getFieldModels());
        } else if (requestBodyModel2 instanceof PartModels) {
            $this_with.buildParts($this$buildClientCodeBlock, ((PartModels)requestBodyModel).getPartModels());
        } else if (requestBodyModel2 != null) {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildCodeBlock$lambda$4(HttpCodeBlockBuilder this$0, CodeBlock.Builder $this$buildTryCatchIfNeed) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTryCatchIfNeed, (String)"$this$buildTryCatchIfNeed");
        ClientCodeBlock $this$buildCodeBlock_u24lambda_u244_u24lambda_u243 = this$0.getClientCodeBlock();
        boolean bl = false;
        String url = this$0.httpRequestModel.getUrl();
        String string = this$0.httpRequestModel.getClassName().getSimpleName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String funName = string;
        $this$buildCodeBlock_u24lambda_u244_u24lambda_u243.buildClientCodeBlock($this$buildTryCatchIfNeed, funName, (Function1<? super CodeBlock.Builder, Unit>)((Function1)arg_0 -> HttpCodeBlockBuilder.buildCodeBlock$lambda$4$lambda$3$lambda$2(this$0, url, $this$buildCodeBlock_u24lambda_u244_u24lambda_u243, arg_0)));
        return Unit.INSTANCE;
    }
}

