/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.ksp.kotlinpoet.block;

import cn.ktorfitx.common.ksp.util.expends.StringExpendsKt;
import cn.ktorfitx.multiplatform.ksp.constants.TypeNames;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.ClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.HttpClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.kotlinpoet.block.MockClientCodeBlock;
import cn.ktorfitx.multiplatform.ksp.model.AttributeModel;
import cn.ktorfitx.multiplatform.ksp.model.AttributesModel;
import cn.ktorfitx.multiplatform.ksp.model.BodyModel;
import cn.ktorfitx.multiplatform.ksp.model.ClassModel;
import cn.ktorfitx.multiplatform.ksp.model.CookieModel;
import cn.ktorfitx.multiplatform.ksp.model.DynamicUrl;
import cn.ktorfitx.multiplatform.ksp.model.FieldRequestBodyModel;
import cn.ktorfitx.multiplatform.ksp.model.FunModel;
import cn.ktorfitx.multiplatform.ksp.model.HeaderModel;
import cn.ktorfitx.multiplatform.ksp.model.HeadersModel;
import cn.ktorfitx.multiplatform.ksp.model.HttpRequestModel;
import cn.ktorfitx.multiplatform.ksp.model.MockModel;
import cn.ktorfitx.multiplatform.ksp.model.PartRequestBodyModel;
import cn.ktorfitx.multiplatform.ksp.model.PathModel;
import cn.ktorfitx.multiplatform.ksp.model.QueriesModel;
import cn.ktorfitx.multiplatform.ksp.model.QueryModel;
import cn.ktorfitx.multiplatform.ksp.model.RequestBodyModel;
import cn.ktorfitx.multiplatform.ksp.model.ReturnKind;
import cn.ktorfitx.multiplatform.ksp.model.StaticUrl;
import cn.ktorfitx.multiplatform.ksp.model.TimeoutModel;
import cn.ktorfitx.multiplatform.ksp.model.Url;
import com.squareup.kotlinpoet.CodeBlock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\f\u001a\u00020\r*\u00020\u000eJ%\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\u0002\b\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder;", "", "classModel", "Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;", "funModel", "Lcn/ktorfitx/multiplatform/ksp/model/FunModel;", "httpRequestModel", "Lcn/ktorfitx/multiplatform/ksp/model/HttpRequestModel;", "tokenVarName", "", "<init>", "(Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;Lcn/ktorfitx/multiplatform/ksp/model/FunModel;Lcn/ktorfitx/multiplatform/ksp/model/HttpRequestModel;Ljava/lang/String;)V", "buildCodeBlock", "", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "buildTryCatchIfNeed", "builder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getClientCodeBlock", "Lcn/ktorfitx/multiplatform/ksp/kotlinpoet/block/ClientCodeBlock;", "parseStaticUrl", "Lkotlin/Pair;", "", "url", "multiplatform-ksp"})
@SourceDebugExtension(value={"SMAP\nHttpCodeBlockBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpCodeBlockBuilder.kt\ncn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1803#2,3:98\n1#3:101\n*S KotlinDebug\n*F\n+ 1 HttpCodeBlockBuilder.kt\ncn/ktorfitx/multiplatform/ksp/kotlinpoet/block/HttpCodeBlockBuilder\n*L\n91#1:98,3\n*E\n"})
public final class HttpCodeBlockBuilder {
    @NotNull
    private final ClassModel classModel;
    @NotNull
    private final FunModel funModel;
    @NotNull
    private final HttpRequestModel httpRequestModel;
    @Nullable
    private final String tokenVarName;

    public HttpCodeBlockBuilder(@NotNull ClassModel classModel, @NotNull FunModel funModel, @NotNull HttpRequestModel httpRequestModel, @Nullable String tokenVarName) {
        Intrinsics.checkNotNullParameter((Object)classModel, (String)"classModel");
        Intrinsics.checkNotNullParameter((Object)funModel, (String)"funModel");
        Intrinsics.checkNotNullParameter((Object)httpRequestModel, (String)"httpRequestModel");
        this.classModel = classModel;
        this.funModel = funModel;
        this.httpRequestModel = httpRequestModel;
        this.tokenVarName = tokenVarName;
    }

    public final void buildCodeBlock(@NotNull CodeBlock.Builder $this$buildCodeBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"<this>");
        this.buildTryCatchIfNeed($this$buildCodeBlock, (Function1<? super CodeBlock.Builder, Unit>)((Function1)arg_0 -> HttpCodeBlockBuilder.buildCodeBlock$lambda$4(this, arg_0)));
    }

    private final void buildTryCatchIfNeed(CodeBlock.Builder $this$buildTryCatchIfNeed, Function1<? super CodeBlock.Builder, Unit> builder) {
        if (this.funModel.getReturnModel().getReturnKind() == ReturnKind.Result) {
            $this$buildTryCatchIfNeed.beginControlFlow("return try", new Object[0]);
            builder.invoke((Object)$this$buildTryCatchIfNeed);
            Object[] objectArray = new Object[]{TypeNames.INSTANCE.getCancellationException()};
            $this$buildTryCatchIfNeed.nextControlFlow("catch (e: %T)", objectArray);
            $this$buildTryCatchIfNeed.addStatement("throw e", new Object[0]);
            $this$buildTryCatchIfNeed.nextControlFlow("catch (e: Exception)", new Object[0]);
            $this$buildTryCatchIfNeed.addStatement("Result.failure(e)", new Object[0]);
            $this$buildTryCatchIfNeed.endControlFlow();
        } else {
            builder.invoke((Object)$this$buildTryCatchIfNeed);
        }
    }

    private final ClientCodeBlock getClientCodeBlock() {
        MockModel mockModel = this.funModel.getMockModel();
        return mockModel != null ? (ClientCodeBlock)new MockClientCodeBlock(mockModel, this.funModel.getReturnModel()) : (ClientCodeBlock)new HttpClientCodeBlock(this.funModel.getReturnModel());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, Boolean> parseStaticUrl(String url) {
        void $this$fold$iv;
        Iterable iterable = this.funModel.getPathModels();
        String initial$iv = url;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            PathModel pathModel = (PathModel)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default((String)acc, (String)("{" + it.getName() + "}"), (String)("${" + it.getVarName() + "}"), (boolean)false, (int)4, null);
        }
        String parseUrl = accumulator$iv;
        boolean jointApiUrl = this.classModel.getApiUrl() != null && !StringExpendsKt.isHttpOrHttps((String)url);
        return TuplesKt.to((Object)parseUrl, (Object)jointApiUrl);
    }

    private static final Unit buildCodeBlock$lambda$4$lambda$3$lambda$2(HttpCodeBlockBuilder this$0, ClientCodeBlock $this_with, CodeBlock.Builder $this$buildClientCodeBlock) {
        List<PathModel> pathModels;
        List<CookieModel> cookieModels;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$this$buildClientCodeBlock, (String)"$this$buildClientCodeBlock");
        Url url = this$0.httpRequestModel.getUrl();
        if (url instanceof DynamicUrl) {
            $this_with.buildDynamicUrl($this$buildClientCodeBlock, (DynamicUrl)url, this$0.classModel.getApiUrl() != null, this$0.funModel.getPathModels());
        } else if (url instanceof StaticUrl) {
            Pair<String, Boolean> pair = this$0.parseStaticUrl(((StaticUrl)url).getUrl());
            String parseUrl = (String)pair.component1();
            boolean jointApiUrl = (Boolean)pair.component2();
            $this_with.buildStaticUrl($this$buildClientCodeBlock, parseUrl, jointApiUrl);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        TimeoutModel timeoutModel = this$0.funModel.getTimeoutModel();
        if (timeoutModel != null) {
            it = timeoutModel;
            boolean bl = false;
            $this_with.buildTimeoutCodeBlock($this$buildClientCodeBlock, (TimeoutModel)it);
        }
        String string = this$0.tokenVarName;
        if (string != null) {
            it = string;
            boolean bl = false;
            $this_with.buildBearerAuth($this$buildClientCodeBlock, (String)it);
        }
        HeadersModel headersModel = this$0.funModel.getHeadersModel();
        List<HeaderModel> headerModels = this$0.funModel.getHeaderModels();
        if (headersModel != null || !((Collection)headerModels).isEmpty()) {
            $this_with.buildHeadersCodeBlock($this$buildClientCodeBlock, headersModel, headerModels);
        }
        List<QueryModel> queryModels = this$0.funModel.getQueryModels();
        List<QueriesModel> queriesModel = this$0.funModel.getQueriesModels();
        if (!((Collection)queryModels).isEmpty() || !((Collection)queriesModel).isEmpty()) {
            $this_with.buildQueries($this$buildClientCodeBlock, queryModels, queriesModel);
        }
        if (!((Collection)(cookieModels = this$0.funModel.getCookieModels())).isEmpty()) {
            $this_with.buildCookies($this$buildClientCodeBlock, cookieModels);
        }
        List<AttributeModel> attributeModels = this$0.funModel.getAttributeModels();
        List<AttributesModel> attributesModels = this$0.funModel.getAttributesModels();
        if (!((Collection)attributeModels).isEmpty() || !((Collection)attributesModels).isEmpty()) {
            $this_with.buildAttributes($this$buildClientCodeBlock, attributeModels, attributesModels);
        }
        if ($this_with instanceof MockClientCodeBlock && !((Collection)(pathModels = this$0.funModel.getPathModels())).isEmpty()) {
            ((MockClientCodeBlock)$this_with).buildPaths($this$buildClientCodeBlock, pathModels);
        }
        RequestBodyModel requestBodyModel = this$0.funModel.getRequestBodyModel();
        RequestBodyModel requestBodyModel2 = this$0.funModel.getRequestBodyModel();
        if (requestBodyModel2 instanceof BodyModel) {
            $this_with.buildBody($this$buildClientCodeBlock, (BodyModel)requestBodyModel);
        } else if (requestBodyModel2 instanceof FieldRequestBodyModel) {
            $this_with.buildFields($this$buildClientCodeBlock, ((FieldRequestBodyModel)requestBodyModel).getFieldModels(), ((FieldRequestBodyModel)requestBodyModel).getFieldsModels());
        } else if (requestBodyModel2 instanceof PartRequestBodyModel) {
            $this_with.buildParts($this$buildClientCodeBlock, ((PartRequestBodyModel)requestBodyModel).getPartModels(), ((PartRequestBodyModel)requestBodyModel).getPartsModels());
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildCodeBlock$lambda$4(HttpCodeBlockBuilder this$0, CodeBlock.Builder $this$buildTryCatchIfNeed) {
        Intrinsics.checkNotNullParameter((Object)$this$buildTryCatchIfNeed, (String)"$this$buildTryCatchIfNeed");
        ClientCodeBlock $this$buildCodeBlock_u24lambda_u244_u24lambda_u243 = this$0.getClientCodeBlock();
        boolean bl = false;
        $this$buildCodeBlock_u24lambda_u244_u24lambda_u243.buildClientCodeBlock($this$buildTryCatchIfNeed, this$0.httpRequestModel, this$0.funModel.isPrepareType(), (Function1<? super CodeBlock.Builder, Unit>)((Function1)arg_0 -> HttpCodeBlockBuilder.buildCodeBlock$lambda$4$lambda$3$lambda$2(this$0, $this$buildCodeBlock_u24lambda_u244_u24lambda_u243, arg_0)));
        return Unit.INSTANCE;
    }
}

