/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.ksp.visitor;

import cn.ktorfitx.common.ksp.util.check.ChecksKt;
import cn.ktorfitx.common.ksp.util.expends.KSPSymbolExpendsKt;
import cn.ktorfitx.common.ksp.util.expends.KotlinPoetExpendsKt;
import cn.ktorfitx.common.ksp.util.expends.StringExpendsKt;
import cn.ktorfitx.common.ksp.util.message.MessageKt;
import cn.ktorfitx.common.ksp.util.resolver.SerializableTypeResolverKt;
import cn.ktorfitx.multiplatform.ksp.constants.TypeNames;
import cn.ktorfitx.multiplatform.ksp.message.MultiplatformMessagesKt;
import cn.ktorfitx.multiplatform.ksp.model.ApiScopeModel;
import cn.ktorfitx.multiplatform.ksp.model.ClassModel;
import cn.ktorfitx.multiplatform.ksp.model.CustomHttpMethodModel;
import cn.ktorfitx.multiplatform.ksp.model.DynamicUrl;
import cn.ktorfitx.multiplatform.ksp.model.FunModel;
import cn.ktorfitx.multiplatform.ksp.model.HttpRequestModel;
import cn.ktorfitx.multiplatform.ksp.model.MockModel;
import cn.ktorfitx.multiplatform.ksp.model.ReturnKind;
import cn.ktorfitx.multiplatform.ksp.model.ReturnModel;
import cn.ktorfitx.multiplatform.ksp.model.RouteModel;
import cn.ktorfitx.multiplatform.ksp.model.StaticUrl;
import cn.ktorfitx.multiplatform.ksp.model.Url;
import cn.ktorfitx.multiplatform.ksp.model.WebSocketModel;
import cn.ktorfitx.multiplatform.ksp.visitor.resolver.ParameterResolverKt;
import cn.ktorfitx.multiplatform.ksp.visitor.resolver.RequestBodyResolverKt;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.Modifier;
import com.google.devtools.ksp.symbol.Visibility;
import com.google.devtools.ksp.visitor.KSEmptyVisitor;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\f\u0010\u000e\u001a\u00020\u0004*\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\fH\u0002J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0002*\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\fH\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0002*\u00020\fH\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J$\u0010\u001b\u001a\u00020\u001c*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u001e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcn/ktorfitx/multiplatform/ksp/visitor/ApiVisitor;", "Lcom/google/devtools/ksp/visitor/KSEmptyVisitor;", "", "Lcn/ktorfitx/multiplatform/ksp/model/CustomHttpMethodModel;", "Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;", "<init>", "()V", "apiUrlRegex", "Lkotlin/text/Regex;", "customHttpMethodModels", "visitClassDeclaration", "classDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "data", "getClassModel", "getApiUrl", "", "getApiScopeModels", "Lcn/ktorfitx/multiplatform/ksp/model/ApiScopeModel;", "getVisibilityKModifier", "Lcom/squareup/kotlinpoet/KModifier;", "getFunModel", "Lcn/ktorfitx/multiplatform/ksp/model/FunModel;", "urlRegex", "getRouteModel", "Lcn/ktorfitx/multiplatform/ksp/model/RouteModel;", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "getReturnModel", "Lcn/ktorfitx/multiplatform/ksp/model/ReturnModel;", "isWebSocket", "", "isPrepareType", "isMock", "defaultHandler", "node", "Lcom/google/devtools/ksp/symbol/KSNode;", "multiplatform-ksp"})
@SourceDebugExtension(value={"SMAP\nApiVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVisitor.kt\ncn/ktorfitx/multiplatform/ksp/visitor/ApiVisitor\n+ 2 Checks.kt\ncn/ktorfitx/common/ksp/util/check/ChecksKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n26#2,5:245\n26#2,5:251\n26#2,5:256\n44#2,5:261\n26#2,5:280\n26#2,5:289\n26#2,5:302\n26#2,5:315\n26#2,5:320\n26#2,5:325\n26#2,5:330\n26#2,5:335\n26#2,5:340\n26#2,5:345\n26#2,5:350\n26#2,5:357\n26#2,5:362\n26#2,5:367\n26#2,5:372\n26#2,5:377\n26#2,5:382\n26#2,5:387\n26#2,5:392\n26#2,5:397\n1#3:250\n10676#4:266\n10901#4,3:267\n10904#4,3:277\n11228#4:285\n11563#4,3:286\n382#5,7:270\n230#6,2:294\n774#6:296\n865#6,2:297\n1563#6:299\n1634#6,2:300\n1636#6:307\n1563#6:308\n1634#6,3:309\n774#6:312\n865#6,2:313\n230#6,2:355\n*S KotlinDebug\n*F\n+ 1 ApiVisitor.kt\ncn/ktorfitx/multiplatform/ksp/visitor/ApiVisitor\n*L\n42#1:245,5\n60#1:251,5\n64#1:256,5\n73#1:261,5\n77#1:280,5\n88#1:289,5\n98#1:302,5\n133#1:315,5\n138#1:320,5\n146#1:325,5\n152#1:330,5\n157#1:335,5\n161#1:340,5\n165#1:345,5\n169#1:350,5\n193#1:357,5\n196#1:362,5\n199#1:367,5\n206#1:372,5\n213#1:377,5\n218#1:382,5\n225#1:387,5\n232#1:392,5\n235#1:397,5\n76#1:266\n76#1:267,3\n76#1:277,3\n80#1:285\n80#1:286,3\n76#1:270,7\n91#1:294,2\n96#1:296\n96#1:297,2\n97#1:299\n97#1:300,2\n97#1:307\n130#1:308\n130#1:309,3\n132#1:312\n132#1:313,2\n178#1:355,2\n*E\n"})
public final class ApiVisitor
extends KSEmptyVisitor<List<? extends CustomHttpMethodModel>, ClassModel> {
    @NotNull
    public static final ApiVisitor INSTANCE = new ApiVisitor();
    @NotNull
    private static final Regex apiUrlRegex = new Regex("^\\S*[a-zA-Z0-9]+\\S*$");
    @Nullable
    private static List<CustomHttpMethodModel> customHttpMethodModels;
    @NotNull
    private static final Regex urlRegex;

    private ApiVisitor() {
    }

    @NotNull
    public ClassModel visitClassDeclaration(@NotNull KSClassDeclaration classDeclaration, @NotNull List<CustomHttpMethodModel> data) {
        Intrinsics.checkNotNullParameter((Object)classDeclaration, (String)"classDeclaration");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        customHttpMethodModels = data;
        return this.getClassModel(classDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassModel getClassModel(KSClassDeclaration $this$getClassModel) {
        String[] node$iv;
        void value$iv;
        boolean bl = !KSPSymbolExpendsKt.isGeneric((KSDeclaration)((KSDeclaration)$this$getClassModel));
        KSNode kSNode = (KSNode)$this$getClassModel;
        Function0 lazyMessage$iv = () -> ApiVisitor.getClassModel$lambda$0($this$getClassModel);
        boolean $i$f$ktorfitxCheck = false;
        if (value$iv == false) {
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        node$iv = new String[]{$this$getClassModel.getSimpleName().asString() + "Impl"};
        ClassName className = new ClassName($this$getClassModel.getPackageName().asString() + ".impls", node$iv);
        ClassName superinterface = KsClassDeclarationsKt.toClassName((KSClassDeclaration)$this$getClassModel);
        return new ClassModel(className, superinterface, this.getVisibilityKModifier($this$getClassModel), this.getApiUrl($this$getClassModel), this.getApiScopeModels($this$getClassModel), this.getFunModel($this$getClassModel));
    }

    /*
     * WARNING - void declaration
     */
    private final String getApiUrl(KSClassDeclaration $this$getApiUrl) {
        KSNode node$iv;
        void value$iv222;
        String string;
        KSAnnotation annotation;
        block6: {
            block5: {
                String string2;
                KSAnnotation kSAnnotation = KSPSymbolExpendsKt.getKSAnnotationByType((KSAnnotated)((KSAnnotated)$this$getApiUrl), (ClassName)TypeNames.INSTANCE.getApi());
                Intrinsics.checkNotNull((Object)kSAnnotation);
                annotation = kSAnnotation;
                string = (String)KSPSymbolExpendsKt.getValueOrNull((KSAnnotation)annotation, (String)"url");
                if (string == null) break block5;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block6;
            }
            return null;
        }
        String url = string;
        boolean bl = !StringExpendsKt.containsSchemeSeparator((String)url);
        KSNode kSNode = (KSNode)annotation;
        Function0 lazyMessage$iv = () -> ApiVisitor.getApiUrl$lambda$2($this$getApiUrl);
        boolean $i$f$ktorfitxCheck = false;
        if (value$iv222 == false) {
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        char[] value$iv222 = new char[]{'/'};
        url = StringsKt.trim((String)((Object)StringsKt.trim((CharSequence)url)).toString(), (char[])value$iv222);
        boolean value$iv222 = apiUrlRegex.matches((CharSequence)url);
        node$iv = (KSNode)annotation;
        lazyMessage$iv = () -> ApiVisitor.getApiUrl$lambda$3($this$getApiUrl);
        $i$f$ktorfitxCheck = false;
        if (!value$iv222) {
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ApiScopeModel> getApiScopeModels(KSClassDeclaration $this$getApiScopeModels) {
        void $this$mapTo$iv$iv;
        void value$iv;
        List list$iv$iv;
        void it;
        void $this$groupByTo$iv$iv;
        void value$iv2;
        KSNode apiScopeClassNames;
        Object object;
        KSNode kSNode;
        KSAnnotation kSAnnotation = KSPSymbolExpendsKt.getKSAnnotationByType((KSAnnotated)((KSAnnotated)$this$getApiScopeModels), (ClassName)TypeNames.INSTANCE.getApiScope());
        if (kSAnnotation == null) {
            return CollectionsKt.listOf((Object)new ApiScopeModel(TypeNames.INSTANCE.getDefaultApiScope()));
        }
        KSAnnotation apiScopeAnnotation = kSAnnotation;
        KSNode kSNode2 = KSPSymbolExpendsKt.getClassNamesOrNull((KSAnnotation)apiScopeAnnotation, (String)"scopes");
        if (kSNode2 != null) {
            KSNode it2 = kSNode = kSNode2;
            boolean bl = false;
            object = !(((ClassName[])it2).length == 0) ? kSNode : null;
        } else {
            object = null;
        }
        KSNode kSNode3 = apiScopeClassNames = object;
        kSNode = (KSNode)apiScopeAnnotation;
        Function0 lazyMessage$iv = () -> ApiVisitor.getApiScopeModels$lambda$5($this$getApiScopeModels);
        boolean $i$f$ktorfitxCheckNotNull22 = false;
        if (value$iv2 == null) {
            void node$iv;
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        KSNode $this$groupBy$iv22 = apiScopeClassNames;
        boolean $i$f$groupBy22 = false;
        KSNode $i$f$ktorfitxCheckNotNull22 = $this$groupBy$iv22;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            void element$iv$iv;
            it = element$iv$iv = $this$groupByTo$iv$iv[i];
            boolean bl = false;
            String key$iv$iv = CollectionsKt.joinToString$default((Iterable)it.getSimpleNames(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        int groupSize = destination$iv$iv.size();
        boolean $this$groupBy$iv22 = ((KSNode)apiScopeClassNames).length == groupSize;
        KSNode $i$f$groupBy22 = (KSNode)$this$getApiScopeModels;
        Function0 lazyMessage$iv2 = () -> ApiVisitor.getApiScopeModels$lambda$7($this$getApiScopeModels);
        boolean $i$f$ktorfitxCheck = false;
        if (value$iv == false) {
            void node$iv;
            String message$iv = (String)lazyMessage$iv2.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        KSNode $this$map$iv = apiScopeClassNames;
        boolean $i$f$map = false;
        lazyMessage$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(((KSNode)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new ApiScopeModel((ClassName)it));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final KModifier getVisibilityKModifier(KSClassDeclaration $this$getVisibilityKModifier) {
        Object element$iv2;
        block2: {
            void value$iv;
            Visibility visibility = UtilsKt.getVisibility((KSDeclaration)((KSDeclaration)$this$getVisibilityKModifier));
            boolean bl = visibility == Visibility.PUBLIC || visibility == Visibility.INTERNAL;
            KSNode kSNode = (KSNode)$this$getVisibilityKModifier;
            Function0 lazyMessage$iv = () -> ApiVisitor.getVisibilityKModifier$lambda$9($this$getVisibilityKModifier);
            boolean $i$f$ktorfitxCheck = false;
            if (value$iv == false) {
                void node$iv;
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            Iterable $this$first$iv = (Iterable)KModifier.getEntries();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                KModifier it = (KModifier)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)visibility.name())) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (KModifier)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunModel> getFunModel(KSClassDeclaration $this$getFunModel) {
        void $this$mapTo$iv$iv;
        KSFunctionDeclaration it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = SequencesKt.toList((Sequence)UtilsKt.getDeclaredFunctions((KSClassDeclaration)$this$getFunModel));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KSFunctionDeclaration)element$iv$iv;
            boolean bl = false;
            if (!it.isAbstract()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value$iv;
            void function;
            it = (KSFunctionDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = function.getModifiers().contains(Modifier.SUSPEND);
            KSNode kSNode = (KSNode)function;
            Function0 lazyMessage$iv = () -> ApiVisitor.getFunModel$lambda$13$lambda$12((KSFunctionDeclaration)function);
            boolean $i$f$ktorfitxCheck = false;
            if (value$iv == false) {
                void node$iv;
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            RouteModel routeModel = INSTANCE.getRouteModel((KSFunctionDeclaration)function);
            boolean isWebSocket = routeModel instanceof WebSocketModel;
            MockModel mockModel = ParameterResolverKt.getMockModel((KSFunctionDeclaration)function, isWebSocket);
            boolean isPrepareType = KSPSymbolExpendsKt.hasAnnotation((KSAnnotated)((KSAnnotated)function), (ClassName)TypeNames.INSTANCE.getPrepare());
            collection.add(new FunModel(function.getSimpleName().asString(), INSTANCE.getReturnModel((KSFunctionDeclaration)function, isWebSocket, isPrepareType, mockModel != null), ParameterResolverKt.getParameterModels((KSFunctionDeclaration)function, isWebSocket), routeModel, mockModel, ParameterResolverKt.hasBearerAuth((KSFunctionDeclaration)function), isPrepareType, ParameterResolverKt.getTimeoutModel((KSFunctionDeclaration)function), ParameterResolverKt.getQueryModels((KSFunctionDeclaration)function), ParameterResolverKt.getPathModels((KSFunctionDeclaration)function, routeModel.getUrl(), isWebSocket), ParameterResolverKt.getCookieModels((KSFunctionDeclaration)function), ParameterResolverKt.getAttributeModels((KSFunctionDeclaration)function), ParameterResolverKt.getHeaderModels((KSFunctionDeclaration)function), ParameterResolverKt.getHeadersModel((KSFunctionDeclaration)function), RequestBodyResolverKt.getRequestBodyModel((KSFunctionDeclaration)function), ParameterResolverKt.getQueriesModels((KSFunctionDeclaration)function), ParameterResolverKt.getAttributesModels((KSFunctionDeclaration)function)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final RouteModel getRouteModel(KSFunctionDeclaration $this$getRouteModel) {
        RouteModel routeModel;
        Url url;
        String rawUrl;
        Object lazyMessage$iv22;
        KSNode node$iv;
        boolean value$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        List<CustomHttpMethodModel> list = customHttpMethodModels;
        Intrinsics.checkNotNull(list);
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            CustomHttpMethodModel customHttpMethodModel = (CustomHttpMethodModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CustomHttpMethodModel)((Object)it)).getClassName());
        }
        List customClassNames = (List)destination$iv$iv;
        List availableRoutes = CollectionsKt.plus((Collection)TypeNames.INSTANCE.getRoutes(), (Iterable)customClassNames);
        Iterable $this$filter$iv22 = availableRoutes;
        boolean $i$f$filter22 = false;
        Iterable $i$f$mapTo22 = $this$filter$iv22;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClassName it = (ClassName)element$iv$iv;
            boolean bl = false;
            if (!KSPSymbolExpendsKt.hasAnnotation((KSAnnotated)((KSAnnotated)$this$getRouteModel), (ClassName)it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List classNames = (List)destination$iv$iv2;
        boolean $this$filter$iv22 = classNames.size() <= 1;
        KSNode $i$f$filter22 = (KSNode)$this$getRouteModel;
        Function0 lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$17(classNames, $this$getRouteModel);
        boolean $i$f$ktorfitxCheck = false;
        if (!value$iv) {
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        value$iv = classNames.size() == 1;
        node$iv = (KSNode)$this$getRouteModel;
        lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$18($this$getRouteModel);
        $i$f$ktorfitxCheck = false;
        if (!value$iv) {
            String message$iv = (String)lazyMessage$iv.invoke();
            ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
            throw new KotlinNothingValueException();
        }
        ClassName className = (ClassName)CollectionsKt.single((List)classNames);
        boolean isWebSocket = Intrinsics.areEqual((Object)className, (Object)TypeNames.INSTANCE.getWebSocket());
        DynamicUrl dynamicUrl = ParameterResolverKt.getDynamicUrl($this$getRouteModel);
        if (isWebSocket) {
            void value$iv2;
            $i$f$ktorfitxCheck = dynamicUrl == null;
            KSNode message$iv = (KSNode)$this$getRouteModel;
            lazyMessage$iv22 = () -> ApiVisitor.getRouteModel$lambda$19($this$getRouteModel);
            boolean $i$f$ktorfitxCheck2 = false;
            if (value$iv2 == false) {
                void node$iv2;
                String message$iv2 = (String)lazyMessage$iv22.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv2, (String)message$iv2);
                throw new KotlinNothingValueException();
            }
        }
        KSAnnotation kSAnnotation = KSPSymbolExpendsKt.getKSAnnotationByType((KSAnnotated)((KSAnnotated)$this$getRouteModel), (ClassName)className);
        Intrinsics.checkNotNull((Object)kSAnnotation);
        String string = (String)KSPSymbolExpendsKt.getValueOrNull((KSAnnotation)kSAnnotation, (String)"url");
        if (string != null) {
            lazyMessage$iv22 = new char[1];
            lazyMessage$iv22[0] = (Function0)47;
            v3 = StringsKt.trim((String)string, (char[])lazyMessage$iv22);
        } else {
            v3 = rawUrl = null;
        }
        if (dynamicUrl != null) {
            lazyMessage$iv22 = rawUrl;
            boolean lazyMessage$iv22 = lazyMessage$iv22 == null || StringsKt.isBlank((CharSequence)lazyMessage$iv22);
            KSNode $i$f$ktorfitxCheck2 = (KSNode)$this$getRouteModel;
            lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$20($this$getRouteModel, className);
            $i$f$ktorfitxCheck = false;
            if (!value$iv2) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            url = dynamicUrl;
        } else {
            CharSequence value$iv2 = rawUrl;
            value$iv2 = !(value$iv2 == null || StringsKt.isBlank((CharSequence)value$iv2));
            node$iv = (KSNode)$this$getRouteModel;
            lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$21($this$getRouteModel, className);
            $i$f$ktorfitxCheck = false;
            if (!value$iv2) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            if (isWebSocket) {
                value$iv2 = !StringExpendsKt.containsSchemeSeparator((String)rawUrl) || StringExpendsKt.isWSOrWSS((String)rawUrl);
                node$iv = (KSNode)$this$getRouteModel;
                lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$22($this$getRouteModel, className);
                $i$f$ktorfitxCheck = false;
                if (!value$iv2) {
                    String message$iv = (String)lazyMessage$iv.invoke();
                    ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                    throw new KotlinNothingValueException();
                }
            } else {
                value$iv2 = !StringExpendsKt.containsSchemeSeparator((String)rawUrl) || StringExpendsKt.isHttpOrHttps((String)rawUrl);
                node$iv = (KSNode)$this$getRouteModel;
                lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$23($this$getRouteModel, className);
                $i$f$ktorfitxCheck = false;
                if (!value$iv2) {
                    String message$iv = (String)lazyMessage$iv.invoke();
                    ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                    throw new KotlinNothingValueException();
                }
            }
            value$iv2 = urlRegex.matches((CharSequence)rawUrl);
            node$iv = (KSNode)$this$getRouteModel;
            lazyMessage$iv = () -> ApiVisitor.getRouteModel$lambda$24($this$getRouteModel, className);
            $i$f$ktorfitxCheck = false;
            if (!value$iv2) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            url = new StaticUrl(rawUrl);
        }
        Url url2 = url;
        ClassName className2 = className;
        if (Intrinsics.areEqual((Object)className2, (Object)TypeNames.INSTANCE.getWebSocket())) {
            routeModel = new WebSocketModel((StaticUrl)url2);
        } else if (TypeNames.INSTANCE.getHttpMethods().contains(className2)) {
            routeModel = new HttpRequestModel(url2, className.getSimpleName(), false);
        } else {
            Object element$iv2;
            block22: {
                List<CustomHttpMethodModel> list2 = customHttpMethodModels;
                Intrinsics.checkNotNull(list2);
                Iterable $this$first$iv = list2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    CustomHttpMethodModel it = (CustomHttpMethodModel)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)className)) continue;
                    break block22;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String method = ((CustomHttpMethodModel)element$iv2).getMethod();
            routeModel = new HttpRequestModel(url2, method, true);
        }
        return routeModel;
    }

    /*
     * WARNING - void declaration
     */
    private final ReturnModel getReturnModel(KSFunctionDeclaration $this$getReturnModel, boolean isWebSocket, boolean isPrepareType, boolean isMock) {
        ReturnModel returnModel;
        KSTypeReference kSTypeReference = $this$getReturnModel.getReturnType();
        Intrinsics.checkNotNull((Object)kSTypeReference);
        KSTypeReference returnType = kSTypeReference;
        TypeName typeName = KsTypesKt.toTypeName$default((KSTypeReference)returnType, null, (int)1, null);
        if (isPrepareType) {
            KSNode node$iv;
            boolean value$iv;
            boolean bl = Intrinsics.areEqual((Object)KsTypesKt.toTypeName$default((KSTypeReference)returnType, null, (int)1, null), (Object)TypeNames.INSTANCE.getHttpStatement());
            KSNode kSNode = (KSNode)returnType;
            Function0 lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$26($this$getReturnModel);
            boolean $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            value$iv = !isMock;
            node$iv = (KSNode)$this$getReturnModel;
            lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$27($this$getReturnModel);
            $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            value$iv = !isWebSocket;
            node$iv = (KSNode)$this$getReturnModel;
            lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$28($this$getReturnModel);
            $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            returnModel = new ReturnModel(typeName, typeName, ReturnKind.Any);
        } else if (isWebSocket) {
            boolean value$iv = !typeName.isNullable() && Intrinsics.areEqual((Object)typeName, (Object)TypeNames.INSTANCE.getUnit());
            KSNode node$iv = (KSNode)returnType;
            Function0 lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$29($this$getReturnModel);
            boolean $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            returnModel = new ReturnModel(typeName, typeName, ReturnKind.Unit);
        } else if (Intrinsics.areEqual((Object)KotlinPoetExpendsKt.getRawType((TypeName)typeName), (Object)TypeNames.INSTANCE.getResult())) {
            void value$iv3;
            boolean value$iv2 = !typeName.isNullable() && typeName instanceof ParameterizedTypeName;
            KSNode node$iv = (KSNode)returnType;
            Function0 lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$30($this$getReturnModel);
            boolean $i$f$ktorfitxCheck = false;
            if (!value$iv2) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            TypeName serializedTypeName = (TypeName)CollectionsKt.single((List)((ParameterizedTypeName)typeName).getTypeArguments());
            boolean node$iv2 = SerializableTypeResolverKt.isSerializableType$default((TypeName)serializedTypeName, null, (int)1, null);
            lazyMessage$iv = (KSNode)returnType;
            Function0 lazyMessage$iv2 = () -> ApiVisitor.getReturnModel$lambda$31($this$getReturnModel);
            boolean $i$f$ktorfitxCheck2 = false;
            if (value$iv3 == false) {
                void node$iv3;
                String message$iv = (String)lazyMessage$iv2.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv3, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            returnModel = new ReturnModel(typeName, serializedTypeName, ReturnKind.Result);
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.INSTANCE.getUnit())) {
            void value$iv;
            boolean serializedTypeName = !typeName.isNullable();
            KSNode value$iv3 = (KSNode)returnType;
            Function0 lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$32($this$getReturnModel);
            boolean $i$f$ktorfitxCheck = false;
            if (value$iv == false) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            returnModel = new ReturnModel(typeName, typeName, ReturnKind.Unit);
        } else {
            boolean value$iv = !KotlinPoetExpendsKt.equals((TypeName)typeName, (TypeName)((TypeName)TypeNames.INSTANCE.getNothing()), (boolean)true);
            node$iv = (KSNode)returnType;
            Function0 lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$33($this$getReturnModel, typeName);
            boolean $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            value$iv = SerializableTypeResolverKt.isSerializableType$default((TypeName)typeName, null, (int)1, null);
            node$iv = (KSNode)returnType;
            lazyMessage$iv = () -> ApiVisitor.getReturnModel$lambda$34($this$getReturnModel);
            $i$f$ktorfitxCheck = false;
            if (!value$iv) {
                String message$iv = (String)lazyMessage$iv.invoke();
                ChecksKt.ktorfitxCompilationError((KSNode)node$iv, (String)message$iv);
                throw new KotlinNothingValueException();
            }
            returnModel = new ReturnModel(typeName, typeName, ReturnKind.Any);
        }
        return returnModel;
    }

    @NotNull
    public ClassModel defaultHandler(@NotNull KSNode node, @NotNull List<CustomHttpMethodModel> data) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        throw new IllegalStateException("Not Implemented.".toString());
    }

    private static final String getClassModel$lambda$0(KSClassDeclaration $this_getClassModel) {
        Object[] objectArray = new Object[]{$this_getClassModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_INTERFACE_NOT_ALLOW_GENERICS(), (Object[])objectArray);
    }

    private static final String getApiUrl$lambda$2(KSClassDeclaration $this_getApiUrl) {
        Object[] objectArray = new Object[]{$this_getApiUrl.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_NOT_ALLOW_USE_PROTOCOL_FROM_STRINGS(), (Object[])objectArray);
    }

    private static final String getApiUrl$lambda$3(KSClassDeclaration $this_getApiUrl) {
        Object[] objectArray = new Object[]{$this_getApiUrl.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_URL_PARAMETER_FORMAT_INCORRECT(), (Object[])objectArray);
    }

    private static final String getApiScopeModels$lambda$5(KSClassDeclaration $this_getApiScopeModels) {
        Object[] objectArray = new Object[]{$this_getApiScopeModels.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_SCOPES_PARAMETER_NOT_ALLOW_NULLABLE_TYPE(), (Object[])objectArray);
    }

    private static final String getApiScopeModels$lambda$7(KSClassDeclaration $this_getApiScopeModels) {
        Object[] objectArray = new Object[]{$this_getApiScopeModels.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_SCOPES_NOT_ALLOWED_USE_SAME_CLASS_NAME_K_CLASS(), (Object[])objectArray);
    }

    private static final String getVisibilityKModifier$lambda$9(KSClassDeclaration $this_getVisibilityKModifier) {
        Object[] objectArray = new Object[]{$this_getVisibilityKModifier.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_INTERFACE_MUST_BE_DECLARED_PUBLIC_OR_INTERNAL_ACCESS_PERMISSION(), (Object[])objectArray);
    }

    private static final String getFunModel$lambda$13$lambda$12(KSFunctionDeclaration $function) {
        Object[] objectArray = new Object[]{$function.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_LACKS_SUSPEND_MODIFIER(), (Object[])objectArray);
    }

    private static final CharSequence getRouteModel$lambda$17$lambda$16(ClassName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "@" + it.getSimpleName();
    }

    private static final String getRouteModel$lambda$17(List $classNames, KSFunctionDeclaration $this_getRouteModel) {
        String useAnnotations = CollectionsKt.joinToString$default((Iterable)$classNames, null, null, null, (int)0, null, ApiVisitor::getRouteModel$lambda$17$lambda$16, (int)31, null);
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), useAnnotations, $classNames.size() > 1 ? "s" : ""};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_ONLY_ALLOW_USE_ONE_REQUEST_TYPE_ANNOTATION(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$18(KSFunctionDeclaration $this_getRouteModel) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_USE_ROUTE_ANNOTATION(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$19(KSFunctionDeclaration $this_getRouteModel) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_USE_PATH_PARAMETER(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$20(KSFunctionDeclaration $this_getRouteModel, ClassName $className) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), $className.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOW_ALLOW_SETTING_URL_WHEN_MARKED_DYNAMIC_URL(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$21(KSFunctionDeclaration $this_getRouteModel, ClassName $className) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), $className.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_NOT_SET_URL_OR_ADDED_DYNAMIC_URL(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$22(KSFunctionDeclaration $this_getRouteModel, ClassName $className) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), $className.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_URL_ONLY_SUPPORTED_WS_AND_WSS_PROTOCOLS(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$23(KSFunctionDeclaration $this_getRouteModel, ClassName $className) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), $className.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_URL_ONLY_SUPPORTED_HTTP_AND_HTTPS_PROTOCOLS(), (Object[])objectArray);
    }

    private static final String getRouteModel$lambda$24(KSFunctionDeclaration $this_getRouteModel, ClassName $className) {
        Object[] objectArray = new Object[]{$this_getRouteModel.getSimpleName(), $className.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_ANNOTATION_URL_FORMAT_INCORRECT(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$26(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_MUST_USE_HTTP_STATEMENT_RETURN_TYPE(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$27(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_SIMULTANEOUS_USE_PREPARE_AND_MOCK_ANNOTATIONS(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$28(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_SIMULTANEOUS_USE_PREPARE_AND_WEBSOCKET_ANNOTATIONS(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$29(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_HAS_BEEN_WEBSOCKET_SO_RETURN_TYPE_MUST_BE_UNIT(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$30(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_RETURN_TYPE_RESULT_SET_NULLABLE_TYPE(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$31(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_CLASS_NOT_MEET_SERIALIZATION_REQUIREMENTS(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$32(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_RETURN_TYPE_UNIT_USE_NULLABLE_TYPE(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$33(KSFunctionDeclaration $this_getReturnModel, TypeName $typeName) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName(), $typeName.isNullable() ? "?" : ""};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_FUNCTION_NOT_ALLOW_USE_RETURN_TYPE_NOTHING(), (Object[])objectArray);
    }

    private static final String getReturnModel$lambda$34(KSFunctionDeclaration $this_getReturnModel) {
        Object[] objectArray = new Object[]{$this_getReturnModel.getSimpleName()};
        return MessageKt.getString(MultiplatformMessagesKt.getMESSAGE_CLASS_NOT_MEET_SERIALIZATION_REQUIREMENTS(), (Object[])objectArray);
    }

    static {
        urlRegex = new Regex("^\\S*[a-zA-Z0-9]+\\S*$");
    }
}

