/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.ksp;

import cn.ktorfitx.common.ksp.util.check.ChecksKt;
import cn.ktorfitx.common.ksp.util.log.LoggerKt;
import cn.ktorfitx.common.ksp.util.message.Language;
import cn.ktorfitx.common.ksp.util.message.MessageKt;
import cn.ktorfitx.multiplatform.ksp.AndroidOnlySourceSetModel;
import cn.ktorfitx.multiplatform.ksp.KtorfitxMultiplatformSymbolProcessor;
import cn.ktorfitx.multiplatform.ksp.MultiplatformSourceSetModel;
import cn.ktorfitx.multiplatform.ksp.SourceSetModel;
import cn.ktorfitx.multiplatform.ksp.message.MultiplatformMessagesKt;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import com.google.devtools.ksp.symbol.KSAnnotated;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcn/ktorfitx/multiplatform/ksp/KtorfitxMultiplatformSymbolProcessorProvider;", "Lcom/google/devtools/ksp/processing/SymbolProcessorProvider;", "<init>", "()V", "create", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "getSharedSourceSets", "", "", "projectPath", "Companion", "EmptySymbolProcessor", "multiplatform-ksp"})
@SourceDebugExtension(value={"SMAP\nKtorfitxMultiplatformSymbolProcessorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorfitxMultiplatformSymbolProcessorProvider.kt\ncn/ktorfitx/multiplatform/ksp/KtorfitxMultiplatformSymbolProcessorProvider\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,79:1\n222#2:80\n222#2:81\n*S KotlinDebug\n*F\n+ 1 KtorfitxMultiplatformSymbolProcessorProvider.kt\ncn/ktorfitx/multiplatform/ksp/KtorfitxMultiplatformSymbolProcessorProvider\n*L\n42#1:80\n64#1:81\n*E\n"})
public final class KtorfitxMultiplatformSymbolProcessorProvider
implements SymbolProcessorProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OPTION_IS_MULTIPLATFORM = "ktorfitx.isMultiplatform";
    @NotNull
    private static final String OPTION_LANGUAGE = "ktorfitx.language";
    @NotNull
    private static final String OPTION_SOURCE_SETS_NON_SHARED_NAMES = "ktorfitx.sourceSets.nonSharedNames";
    @NotNull
    private static final String OPTION_PROJECT_PATH = "ktorfitx.project.path";
    @NotNull
    private static final String PATH_BUILD_KTORFITX = "/build/ktorfitx";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SymbolProcessor create(@NotNull SymbolProcessorEnvironment environment) {
        SourceSetModel sourceSetModel;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (environment.getPlatforms().size() > 1) {
            return EmptySymbolProcessor.INSTANCE;
        }
        String string = (String)environment.getOptions().get(OPTION_IS_MULTIPLATFORM);
        if (string == null) {
            ChecksKt.ktorfitxConfigError((String)MessageKt.invoke(MultiplatformMessagesKt.getMESSAGE_MISSING_GRADLE_PLUGIN(), (Object[])new Object[0]));
            throw new KotlinNothingValueException();
        }
        boolean isMultiplatform = Boolean.parseBoolean(string);
        LoggerKt.setKspLogger((KSPLogger)environment.getLogger());
        Object v = environment.getOptions().get(OPTION_LANGUAGE);
        Intrinsics.checkNotNull(v);
        Language.Companion.set((String)v);
        boolean bl = isMultiplatform;
        if (bl) {
            void this_$iv;
            Object v2 = environment.getOptions().get(OPTION_PROJECT_PATH);
            Intrinsics.checkNotNull(v2);
            String projectPath = (String)v2;
            Set<String> sharedSourceSets = this.getSharedSourceSets(projectPath);
            Json json = (Json)Json.Default;
            Object v3 = environment.getOptions().get(OPTION_SOURCE_SETS_NON_SHARED_NAMES);
            Intrinsics.checkNotNull(v3);
            String string$iv = (String)v3;
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            KType kType = Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            Set nonSharedSourceSets = (Set)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
            sourceSetModel = new MultiplatformSourceSetModel(projectPath, sharedSourceSets, nonSharedSourceSets);
        } else if (!bl) {
            sourceSetModel = AndroidOnlySourceSetModel.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SourceSetModel sourceSetModel2 = sourceSetModel;
        return new KtorfitxMultiplatformSymbolProcessor(environment.getCodeGenerator(), sourceSetModel2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getSharedSourceSets(String projectPath) {
        Object object;
        File file = new File(StringsKt.replace$default((String)(projectPath + PATH_BUILD_KTORFITX), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), "sharedSourceSets.json");
        if (!file.exists()) {
            return SetsKt.emptySet();
        }
        try {
            void this_$iv;
            object = (Json)Json.Default;
            String string$iv = FilesKt.readText$default((File)file, null, (int)1, null);
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            KType kType = Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = (Set)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
        }
        catch (Exception exception) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcn/ktorfitx/multiplatform/ksp/KtorfitxMultiplatformSymbolProcessorProvider$Companion;", "", "<init>", "()V", "OPTION_IS_MULTIPLATFORM", "", "OPTION_LANGUAGE", "OPTION_SOURCE_SETS_NON_SHARED_NAMES", "OPTION_PROJECT_PATH", "PATH_BUILD_KTORFITX", "multiplatform-ksp"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcn/ktorfitx/multiplatform/ksp/KtorfitxMultiplatformSymbolProcessorProvider$EmptySymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "<init>", "()V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "multiplatform-ksp"})
    private static final class EmptySymbolProcessor
    implements SymbolProcessor {
        @NotNull
        public static final EmptySymbolProcessor INSTANCE = new EmptySymbolProcessor();

        private EmptySymbolProcessor() {
        }

        @NotNull
        public List<KSAnnotated> process(@NotNull Resolver resolver) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            return CollectionsKt.emptyList();
        }
    }
}

