/*
 * Decompiled with CFR 0.152.
 */
package cn.ktorfitx.multiplatform.ksp.kotlinpoet.block;

import cn.ktorfitx.common.ksp.util.builders.FileSpecBuilderKt;
import cn.ktorfitx.common.ksp.util.expends.StringExpendsKt;
import cn.ktorfitx.multiplatform.ksp.model.ClassModel;
import cn.ktorfitx.multiplatform.ksp.model.FunModel;
import cn.ktorfitx.multiplatform.ksp.model.ParameterModel;
import cn.ktorfitx.multiplatform.ksp.model.TimeoutModel;
import cn.ktorfitx.multiplatform.ksp.model.WebSocketModel;
import com.squareup.kotlinpoet.CodeBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011JY\u0010\u0012\u001a\u00020\u0010*\u00020\u00112\u001d\u0010\u0013\u001a\u0019\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\u0002\b\u00152,\u0010\u0016\u001a(\u0012\u0004\u0012\u00020\u0011\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\u0002\b\u0015H\u0002J\u0014\u0010\u0013\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\f\u0010\u001c\u001a\u00020\u0010*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcn/ktorfitx/multiplatform/ksp/kotlinpoet/block/WebSocketCodeBuilder;", "", "classModel", "Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;", "funModel", "Lcn/ktorfitx/multiplatform/ksp/model/FunModel;", "webSocketModel", "Lcn/ktorfitx/multiplatform/ksp/model/WebSocketModel;", "tokenVarName", "", "<init>", "(Lcn/ktorfitx/multiplatform/ksp/model/ClassModel;Lcn/ktorfitx/multiplatform/ksp/model/FunModel;Lcn/ktorfitx/multiplatform/ksp/model/WebSocketModel;Ljava/lang/String;)V", "parameterModels", "", "Lcn/ktorfitx/multiplatform/ksp/model/ParameterModel;", "buildCodeBlock", "", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "buildRequestCodeBlock", "buildBearerAuth", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "buildTimeout", "Lcn/ktorfitx/multiplatform/ksp/model/TimeoutModel;", "Lkotlin/ParameterName;", "name", "timeoutModel", "varName", "buildBlock", "multiplatform-ksp"})
@SourceDebugExtension(value={"SMAP\nWebSocketCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketCodeBuilder.kt\ncn/ktorfitx/multiplatform/ksp/kotlinpoet/block/WebSocketCodeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class WebSocketCodeBuilder {
    @NotNull
    private final ClassModel classModel;
    @NotNull
    private final FunModel funModel;
    @NotNull
    private final WebSocketModel webSocketModel;
    @Nullable
    private final String tokenVarName;
    @NotNull
    private final List<ParameterModel> parameterModels;

    public WebSocketCodeBuilder(@NotNull ClassModel classModel, @NotNull FunModel funModel, @NotNull WebSocketModel webSocketModel, @Nullable String tokenVarName) {
        Intrinsics.checkNotNullParameter((Object)classModel, (String)"classModel");
        Intrinsics.checkNotNullParameter((Object)funModel, (String)"funModel");
        Intrinsics.checkNotNullParameter((Object)webSocketModel, (String)"webSocketModel");
        this.classModel = classModel;
        this.funModel = funModel;
        this.webSocketModel = webSocketModel;
        this.tokenVarName = tokenVarName;
        this.parameterModels = this.funModel.getParameterModels();
    }

    public final void buildCodeBlock(@NotNull CodeBlock.Builder $this$buildCodeBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$buildCodeBlock, (String)"<this>");
        Object[] objectArray = new String[]{"webSocket"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.client.plugins.websocket", (String[])objectArray);
        $this$buildCodeBlock.addStatement("this.config.httpClient.webSocket(", new Object[0]);
        $this$buildCodeBlock.indent();
        if (this.classModel.getApiUrl() != null && !StringExpendsKt.isWSOrWSS((String)this.webSocketModel.getUrl().getUrl())) {
            v0 = $this$buildCodeBlock.addStatement("urlString = \"$API_URL/" + this.webSocketModel.getUrl().getUrl() + "\",", new Object[0]);
        } else {
            objectArray = new Object[]{this.webSocketModel.getUrl().getUrl()};
            v0 = $this$buildCodeBlock.addStatement("urlString = %S,", objectArray);
        }
        this.buildRequestCodeBlock($this$buildCodeBlock, (Function2<? super CodeBlock.Builder, ? super String, Unit>)((Function2)(arg_0, arg_1) -> WebSocketCodeBuilder.buildCodeBlock$lambda$0(this, arg_0, arg_1)), (Function2<? super CodeBlock.Builder, ? super TimeoutModel, Unit>)((Function2)(arg_0, arg_1) -> WebSocketCodeBuilder.buildCodeBlock$lambda$1(this, arg_0, arg_1)));
        this.buildBlock($this$buildCodeBlock);
        $this$buildCodeBlock.unindent();
        $this$buildCodeBlock.addStatement(")", new Object[0]);
    }

    private final void buildRequestCodeBlock(CodeBlock.Builder $this$buildRequestCodeBlock, Function2<? super CodeBlock.Builder, ? super String, Unit> buildBearerAuth, Function2<? super CodeBlock.Builder, ? super TimeoutModel, Unit> buildTimeout) {
        TimeoutModel timeoutModel = this.funModel.getTimeoutModel();
        if (this.tokenVarName == null && timeoutModel == null) {
            return;
        }
        $this$buildRequestCodeBlock.beginControlFlow("request = ", new Object[0]);
        String string = this.tokenVarName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            buildBearerAuth.invoke((Object)$this$buildRequestCodeBlock, (Object)it);
        }
        TimeoutModel timeoutModel2 = timeoutModel;
        if (timeoutModel2 != null) {
            TimeoutModel it = timeoutModel2;
            boolean bl = false;
            buildTimeout.invoke((Object)$this$buildRequestCodeBlock, (Object)it);
        }
        $this$buildRequestCodeBlock.endControlFlow();
        $this$buildRequestCodeBlock.add(",", new Object[0]);
    }

    private final void buildBearerAuth(CodeBlock.Builder $this$buildBearerAuth, String varName) {
        Object[] objectArray = new String[]{"bearerAuth"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.client.request", (String[])objectArray);
        objectArray = new Object[]{varName};
        $this$buildBearerAuth.addStatement("%N?.let { this.bearerAuth(it) }", objectArray);
    }

    private final void buildTimeout(CodeBlock.Builder $this$buildTimeout, TimeoutModel timeoutModel) {
        Object[] objectArray = new String[]{"timeout"};
        FileSpecBuilderKt.getFileSpecBuilder().addImport("io.ktor.client.plugins", (String[])objectArray);
        $this$buildTimeout.beginControlFlow("this.timeout", new Object[0]);
        if (timeoutModel.getRequestTimeoutMillis() != null) {
            objectArray = new Object[]{timeoutModel.getRequestTimeoutMillis()};
            $this$buildTimeout.addStatement("this.requestTimeoutMillis = %LL", objectArray);
        }
        if (timeoutModel.getConnectTimeoutMillis() != null) {
            objectArray = new Object[]{timeoutModel.getConnectTimeoutMillis()};
            $this$buildTimeout.addStatement("this.connectTimeoutMillis = %LL", objectArray);
        }
        if (timeoutModel.getSocketTimeoutMillis() != null) {
            objectArray = new Object[]{timeoutModel.getSocketTimeoutMillis()};
            $this$buildTimeout.addStatement("this.socketTimeoutMillis = %LL", objectArray);
        }
        $this$buildTimeout.endControlFlow();
    }

    private final void buildBlock(CodeBlock.Builder $this$buildBlock) {
        String varName = ((ParameterModel)CollectionsKt.single(this.parameterModels)).getVarName();
        Object[] objectArray = new Object[]{varName};
        $this$buildBlock.addStatement("block = %N", objectArray);
    }

    private static final Unit buildCodeBlock$lambda$0(WebSocketCodeBuilder this$0, CodeBlock.Builder $this$buildRequestCodeBlock, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$buildRequestCodeBlock, (String)"$this$buildRequestCodeBlock");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.buildBearerAuth($this$buildRequestCodeBlock, it);
        return Unit.INSTANCE;
    }

    private static final Unit buildCodeBlock$lambda$1(WebSocketCodeBuilder this$0, CodeBlock.Builder $this$buildRequestCodeBlock, TimeoutModel it) {
        Intrinsics.checkNotNullParameter((Object)$this$buildRequestCodeBlock, (String)"$this$buildRequestCodeBlock");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.buildTimeout($this$buildRequestCodeBlock, it);
        return Unit.INSTANCE;
    }
}

