/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.core;

import cn.langpy.core.DataHandlerInterface;
import cn.langpy.core.MapFrame;
import cn.langpy.model.DataBaseConfig;
import cn.langpy.model.ExpressionMap;
import cn.langpy.util.DataBaseUtil;
import cn.langpy.util.ExpressUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class ListFrame<E>
extends ArrayList<E> {
    private static Pattern doublePattern = Pattern.compile("^[0-9]+\\.[0-9]+$");
    DataSource dataSource = null;
    ListFrame<E> data = null;
    Map<String, ListFrame<Object>> columnData = new LinkedHashMap<String, ListFrame<Object>>();
    private List<String> columns;

    private Map<String, ListFrame<Object>> getColumnData() {
        return this.columnData;
    }

    private void setColumnData(Map<String, ListFrame<Object>> columnData) {
        this.columnData = columnData;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public ListFrame(int initialCapacity) {
        super(initialCapacity);
    }

    public ListFrame() {
        this.data = this;
    }

    public ListFrame(Collection<E> c) {
        super(c);
        this.data = (ListFrame)c;
    }

    public static <E> ListFrame<E> fromList(List<E> list) {
        if (list instanceof ListFrame) {
            return (ListFrame)list;
        }
        ListFrame<E> listFrame = new ListFrame<E>();
        for (E e : list) {
            listFrame.add(e);
        }
        return listFrame;
    }

    public void initDataSource(DataSource dataSource) {
        if (this.dataSource == null) {
            this.dataSource = dataSource;
        }
    }

    public void initDataSource(DataBaseConfig dataBaseConfig) {
        if (this.dataSource == null) {
            this.dataSource = DataBaseUtil.getDataSource(dataBaseConfig);
        }
    }

    public ListFrame<Map<String, Object>> readSql(String sql) {
        if (this.dataSource == null) {
            throw new RuntimeException("please initilize datasource first!");
        }
        return DataBaseUtil.readSql(sql, this.dataSource);
    }

    public static ListFrame<Map<String, Object>> readSql(String sql, DataSource dataSource) {
        return DataBaseUtil.readSql(sql, dataSource);
    }

    public static ListFrame<Map<String, Object>> readSql(String sql, DataBaseConfig config) {
        return DataBaseUtil.readSql(sql, config);
    }

    public static ListFrame<String> readString(String path) {
        File file = new File(path);
        ListFrame<String> listFrame = new ListFrame<String>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            while ((line = br.readLine()) != null) {
                listFrame.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    public static ListFrame<Map<String, Object>> readMap(String path) {
        return ListFrame.readMap(path, ",");
    }

    public <T> ListFrame<T> toObject(Class<T> beanClass) {
        ListFrame<T> listFrame = new ListFrame<T>();
        try {
            for (Object datum : this.data) {
                Map map = (Map)datum;
                T object = ListFrame.mapToObject(map, beanClass);
                listFrame.add(object);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    private static <T> T mapToObject(Map map, Class<T> beanClass) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        T object = beanClass.newInstance();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(object, map.get(field.getName()));
        }
        return object;
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, List<Class> columnTypes) {
        File file = new File(path);
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            String[] titles = null;
            line = br.readLine();
            if (line != null) {
                titles = line.split(splitBy);
                listFrame.setColumns(Arrays.stream(titles).collect(Collectors.toList()));
            }
            while ((line = br.readLine()) != null) {
                String[] split = line.split(splitBy);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (int i = 0; i < split.length; ++i) {
                    map.put(titles[i], ListFrame.getTypeValue(split[i], columnTypes.get(i)));
                    ListFrame.setListColumns(listFrame, titles[i], ListFrame.getTypeValue(split[i], columnTypes.get(i)));
                }
                listFrame.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, Class[] columnTypes) {
        return ListFrame.readMap(path, splitBy, Arrays.stream(columnTypes).collect(Collectors.toList()));
    }

    private static Object getTypeValue(Object v, Class<?> c) {
        if (c == Integer.class) {
            return Integer.valueOf(v.toString());
        }
        if (c == Double.class) {
            return Double.valueOf(v.toString());
        }
        if (c == Float.class) {
            return Float.valueOf(v.toString());
        }
        return v.toString();
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy) {
        File file = new File(path);
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader(fileInputStream);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            String[] titles = null;
            line = br.readLine();
            if (line != null) {
                titles = line.split(splitBy);
                listFrame.setColumns(Arrays.stream(titles).collect(Collectors.toList()));
            }
            while ((line = br.readLine()) != null) {
                String[] split = line.split(splitBy);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (int i = 0; i < split.length; ++i) {
                    map.put(titles[i], split[i]);
                    ListFrame.setListColumns(listFrame, titles[i], split[i]);
                }
                listFrame.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    private static void setListColumns(ListFrame<Map<String, Object>> listFrame, String title, Object value) {
        if (listFrame.columnData.containsKey(title)) {
            listFrame.columnData.get(title).add(value);
        } else {
            ListFrame<Object> columnsData = new ListFrame<Object>();
            columnsData.add(value);
            listFrame.columnData.put(title, columnsData);
        }
    }

    public <T> ListFrame<T> get(Function<E, T> fun) {
        ListFrame<T> listFrame = new ListFrame<T>();
        Object o = this.data.get(0);
        if (o instanceof String || o instanceof Map) {
            throw new RuntimeException("unsupported operate!");
        }
        for (Object datum : this.data) {
            listFrame.add(fun.apply(datum));
        }
        return listFrame;
    }

    public <T> ListFrame<T> get(String columnName) {
        ListFrame<Object> objects = this.columnData.get(columnName);
        if (null != objects) {
            return objects;
        }
        ListFrame<Object> listFrame = new ListFrame<Object>();
        Object o = this.data.get(0);
        if (o instanceof String) {
            throw new RuntimeException("unsupported operate!");
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map e = (Map)datum;
                listFrame.add(e.get(columnName));
            }
            this.columnData.put(columnName, listFrame);
            return listFrame;
        }
        for (Object datum : this.data) {
            listFrame.add(ExpressUtil.getValue(columnName, datum));
        }
        this.columnData.put(columnName, listFrame);
        return listFrame;
    }

    public ListFrame<E> replace(String src, String tar) {
        if (this.data.size() == 0) {
            return this.data;
        }
        Object o = this.data.get(0);
        if (o instanceof String) {
            ListFrame<String> numFrame = new ListFrame<String>();
            for (Object datum : this.data) {
                String map = (String)datum;
                numFrame.add(map.replaceAll(src, tar));
            }
            return numFrame;
        }
        if (o instanceof Map) {
            ListFrame<Map> numFrame = new ListFrame<Map>();
            for (Object datum : this.data) {
                Map map = (Map)datum;
                for (Object o1 : map.keySet()) {
                    map.put(o1, map.get(o1).toString().replaceAll(src, tar));
                }
                numFrame.add(map);
            }
            numFrame.setColumns(this.data.getColumns());
            return numFrame;
        }
        throw new RuntimeException("please define a property that you want to replace!");
    }

    public ListFrame<E> replace(String column, String src, String tar) {
        if (this.data.size() == 0) {
            return this.data;
        }
        Object o = this.data.get(0);
        if (o instanceof String) {
            ListFrame<String> numFrame = new ListFrame<String>();
            for (Object datum : this.data) {
                String map = (String)datum;
                numFrame.add(map.replaceAll(src, tar));
            }
            return numFrame;
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map map = (Map)datum;
                String columnValue = map.get(column).toString().replaceAll(src, tar);
                map.put(column, columnValue);
            }
            return this.data;
        }
        for (Object datum : this.data) {
            Object columnValue = ExpressUtil.getValue(column, datum);
            datum = ExpressUtil.setValue(column, columnValue.toString().replaceAll(src, tar), datum);
        }
        return this.data;
    }

    public ListFrame<E> handle(DataHandlerInterface<E> dataProcess) {
        ListFrame<E> numFrame = new ListFrame<E>();
        for (Object datum : this.data) {
            numFrame.add(dataProcess.handle(datum));
        }
        numFrame.setColumns(this.data.getColumns());
        return numFrame;
    }

    public ListFrame<E> handle(String expressions) {
        List<ExpressionMap> ops = ExpressUtil.getOperates(expressions);
        ListFrame numFrame = new ListFrame();
        for (Object datum : this.data) {
            for (ExpressionMap op : ops) {
                datum = ExpressUtil.operate(datum, op);
            }
            numFrame.add(datum);
        }
        numFrame.setColumns(this.data.getColumns());
        return numFrame;
    }

    public <T> ListFrame<T> handle(Function<E, T> fun) {
        ListFrame<T> numFrame = new ListFrame<T>();
        for (Object datum : this.data) {
            numFrame.add(fun.apply(datum));
        }
        numFrame.setColumns(this.data.getColumns());
        return numFrame;
    }

    public MapFrame<Object, ListFrame> groupBy(String columnName) {
        MapFrame<Object, ListFrame> groupMap = new MapFrame<Object, ListFrame>();
        Object o = this.data.get(0);
        if (o instanceof String) {
            throw new RuntimeException("unsupported operate for String!");
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map map = (Map)datum;
                Object columnValue = map.get(columnName);
                if (groupMap.containsKey(columnValue)) {
                    ((ListFrame)groupMap.get(columnValue)).add(datum);
                    continue;
                }
                ListFrame listFrame = new ListFrame();
                listFrame.add(datum);
                groupMap.put(columnValue, listFrame);
            }
        } else {
            for (Object datum : this.data) {
                Object columnValue = ExpressUtil.getValue(columnName, datum);
                if (groupMap.containsKey(columnValue)) {
                    ((ListFrame)groupMap.get(columnValue)).add(datum);
                    continue;
                }
                ListFrame listFrame = new ListFrame();
                listFrame.add(datum);
                groupMap.put(columnValue, listFrame);
            }
        }
        return groupMap;
    }

    public int argmax() {
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = 0.0;
            int index = 0;
            int n = 0;
            for (Object datum : this.data) {
                double a = Double.valueOf(datum + "");
                if (a > max) {
                    max = a;
                    index = n;
                }
                ++n;
            }
            return index;
        }
        Integer max = 0;
        int index = 0;
        int n = 0;
        for (Object datum : this.data) {
            int a = Integer.valueOf(datum + "");
            if (a > max) {
                max = a;
                index = n;
            }
            ++n;
        }
        return index;
    }

    public <T> T max() {
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = 0.0;
            for (Object datum : this.data) {
                double a = Double.valueOf(datum + "");
                if (!(a > max)) continue;
                max = a;
            }
            return (T)max;
        }
        Integer max = 0;
        for (Object datum : this.data) {
            int a = Integer.valueOf(datum + "");
            if (a <= max) continue;
            max = a;
        }
        return (T)max;
    }

    public int argmin() {
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = Double.MAX_VALUE;
            int index = 0;
            int n = 0;
            for (Object datum : this.data) {
                double a = Double.valueOf(datum + "");
                if (a < max) {
                    max = a;
                    index = n;
                }
                ++n;
            }
            return index;
        }
        Integer max = Integer.MAX_VALUE;
        int index = 0;
        int n = 0;
        for (Object datum : this.data) {
            int a = Integer.valueOf(datum + "");
            if (a < max) {
                max = a;
                index = n;
            }
            ++n;
        }
        return index;
    }

    public <T> T min() {
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = Double.MAX_VALUE;
            for (Object datum : this.data) {
                double a = Double.valueOf(datum + "");
                if (!(a < max)) continue;
                max = a;
            }
            return (T)max;
        }
        Integer max = Integer.MAX_VALUE;
        for (Object datum : this.data) {
            int a = Integer.valueOf(datum + "");
            if (a >= max) continue;
            max = a;
        }
        return (T)max;
    }

    public double avg() {
        double sum = 0.0;
        for (Object datum : this.data) {
            double a = Double.valueOf(datum + "");
            sum += a;
        }
        return sum / (double)this.data.size();
    }

    public double sum() {
        double sum = 0.0;
        for (Object datum : this.data) {
            double a = Double.valueOf(datum + "");
            sum += a;
        }
        return sum;
    }

    public List<E> toList() {
        return this.data;
    }

    public void toFile(String path) {
        try (FileWriter writer = new FileWriter(path);
             BufferedWriter bw = new BufferedWriter(writer);){
            List<String> columns = this.getColumns();
            bw.write(String.join((CharSequence)",", columns) + "\n");
            for (Object datum : this.data) {
                if (datum instanceof String) {
                    bw.write(datum.toString() + "\n");
                    continue;
                }
                if (!(datum instanceof Map)) continue;
                Map map = (Map)datum;
                StringBuffer line = new StringBuffer();
                int columnsSize = columns.size();
                for (int i = 0; i < columnsSize; ++i) {
                    String column = columns.get(i);
                    if (i < columnsSize - 1) {
                        line.append(map.get(column) + ",");
                        continue;
                    }
                    line.append(map.get(column));
                }
                line.append("\n");
                bw.write(line.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

