/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.core;

import cn.langpy.core.DataHandlerInterface;
import cn.langpy.core.MapFrame;
import cn.langpy.model.DataBaseConfig;
import cn.langpy.model.ExpressionMap;
import cn.langpy.util.DataBaseUtil;
import cn.langpy.util.ExpressUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class ListFrame<E>
extends ArrayList<E> {
    private static Pattern doublePattern = Pattern.compile("^[0-9]+\\.[0-9]+$");
    DataSource dataSource = null;
    private ListFrame<E> data = null;
    private Map<String, ListFrame<Object>> columnData = new LinkedHashMap<String, ListFrame<Object>>();
    private List<String> columns = new ArrayList<String>();
    private static List<DataHandlerInterface> dataHandlers = new ArrayList<DataHandlerInterface>();
    private static List<String> expHandlers = new ArrayList<String>();

    private Map<String, ListFrame<Object>> getColumnData() {
        return this.columnData;
    }

    private void setColumnData(Map<String, ListFrame<Object>> columnData) {
        this.columnData = columnData;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public ListFrame() {
        this.data = this;
    }

    public ListFrame(Collection<E> c) {
        super(c);
        this.data = (ListFrame)c;
    }

    @Override
    public boolean add(E e) {
        this.addInnerColumnData(e);
        return super.add(e);
    }

    private void addInnerColumnData(E e) {
        if (e instanceof Map) {
            Map map = (Map)e;
            for (Object o : map.keySet()) {
                ListFrame<Object> columnList;
                if (!this.columns.contains((String)o)) {
                    this.columns.add((String)o);
                }
                if ((columnList = this.columnData.get(o)) == null) {
                    columnList = new ListFrame<E>();
                    columnList.add(map.get(o));
                    this.columnData.put((String)o, columnList);
                    continue;
                }
                columnList.add(map.get(o));
            }
        } else {
            Field[] fields;
            for (Field field : fields = e.getClass().getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                if (!this.columns.contains(field.getName())) {
                    this.columns.add(field.getName());
                }
                field.setAccessible(true);
                Object value = null;
                try {
                    value = field.get(e);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                ListFrame<Object> columnList = this.columnData.get(field.getName());
                if (columnList == null) {
                    columnList = new ListFrame<E>();
                    columnList.add(value);
                    this.columnData.put(field.getName(), columnList);
                } else {
                    columnList.add(value);
                }
                field.setAccessible(false);
            }
        }
    }

    public static <E> ListFrame<E> fromList(List<E> list) {
        if (list instanceof ListFrame) {
            return (ListFrame)list;
        }
        ListFrame<E> listFrame = new ListFrame<E>();
        Iterator<E> iterator = list.iterator();
        while (iterator.hasNext()) {
            listFrame.add(iterator.next());
        }
        return listFrame;
    }

    public void initDataSource(DataSource dataSource) {
        if (this.dataSource == null) {
            this.dataSource = dataSource;
        }
    }

    public void initDataSource(DataBaseConfig dataBaseConfig) {
        if (this.dataSource == null) {
            this.dataSource = DataBaseUtil.getDataSource(dataBaseConfig);
        }
    }

    public ListFrame<Map<String, Object>> readSql(String sql) {
        if (this.dataSource == null) {
            throw new RuntimeException("please initilize datasource first!");
        }
        return DataBaseUtil.readSql(sql, this.dataSource);
    }

    public static ListFrame<Map<String, Object>> readSql(String sql, DataSource dataSource) {
        return DataBaseUtil.readSql(sql, dataSource);
    }

    public static ListFrame<Map<String, Object>> readSql(String sql, DataBaseConfig config) {
        return DataBaseUtil.readSql(sql, config);
    }

    public static ListFrame<String> readString(String path, Charset charset) {
        File file = new File(path);
        ListFrame<String> listFrame = new ListFrame<String>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            while ((line = br.readLine()) != null) {
                listFrame.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    public static ListFrame<String> readString(String path) {
        return ListFrame.readString(path, Charset.defaultCharset());
    }

    public static ListFrame<Map<String, Object>> readMap(String path) {
        return ListFrame.readMap(path, ",");
    }

    public static ListFrame<Map<String, Object>> readMap(String path, Charset charset) {
        return ListFrame.readMap(path, ",", charset);
    }

    public <T> ListFrame<T> toObjectList(Class<T> beanClass) {
        ListFrame<T> listFrame = new ListFrame<T>();
        if (this.data == null) {
            return null;
        }
        if (this.data.size() == 0) {
            return listFrame;
        }
        Object e1 = this.data.get(0);
        if (e1 instanceof Map) {
            try {
                for (Object datum : this.data) {
                    Map map = (Map)datum;
                    T object = ListFrame.mapToObject(map, beanClass);
                    listFrame.add(object);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                for (Object datum : this.data) {
                    T object = ListFrame.objectToObject(datum, beanClass);
                    listFrame.add(object);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return listFrame;
    }

    public ListFrame<Map<String, Object>> toMapList() {
        if (this.data == null) {
            return null;
        }
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        if (this.data.size() == 0) {
            return listFrame;
        }
        Object e1 = this.data.get(0);
        if (e1 instanceof Map) {
            return this.data;
        }
        Field[] fields = this.data.get(0).getClass().getDeclaredFields();
        for (Object datum : this.data) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                try {
                    field.setAccessible(true);
                    map.put(field.getName(), field.get(datum));
                    field.setAccessible(false);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            listFrame.add(map);
        }
        return listFrame;
    }

    private static <T> T mapToObject(Map map, Class<T> beanClass) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        T object = beanClass.newInstance();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(object, map.get(field.getName()));
        }
        return object;
    }

    private static <T> T objectToObject(Object map, Class<T> beanClass) throws IllegalAccessException, InstantiationException {
        T object = beanClass.newInstance();
        Field[] fields = object.getClass().getDeclaredFields();
        Field[] targetFields = map.getClass().getDeclaredFields();
        for (Field field : fields) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            Optional<Field> keyFieldOption = Arrays.stream(targetFields).filter(name -> name.getName().equals(field.getName())).findFirst();
            if (keyFieldOption.isPresent()) {
                Field field1 = keyFieldOption.get();
                field1.setAccessible(true);
                field.set(object, field1.get(map));
                field1.setAccessible(false);
            }
            field.setAccessible(false);
        }
        return object;
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, List<Class> columnTypes, Charset charset) {
        File file = new File(path);
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            String[] titles = null;
            line = br.readLine();
            if (line != null) {
                titles = line.split(splitBy);
            }
            while ((line = br.readLine()) != null) {
                String[] split = line.split(splitBy);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (int i = 0; i < split.length; ++i) {
                    map.put(titles[i], ListFrame.getTypeValue(split[i], columnTypes.get(i)));
                }
                listFrame.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, Class[] columnTypes, Charset charset) {
        return ListFrame.readMap(path, splitBy, Arrays.stream(columnTypes).collect(Collectors.toList()), charset);
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, Class[] columnTypes) {
        return ListFrame.readMap(path, splitBy, Arrays.stream(columnTypes).collect(Collectors.toList()), Charset.defaultCharset());
    }

    public static ListFrame<Map<String, Object>> readMap(String path, Class[] columnTypes, Charset charset) {
        return ListFrame.readMap(path, ",", Arrays.stream(columnTypes).collect(Collectors.toList()), charset);
    }

    public static ListFrame<Map<String, Object>> readMap(String path, Class[] columnTypes) {
        return ListFrame.readMap(path, ",", Arrays.stream(columnTypes).collect(Collectors.toList()), Charset.defaultCharset());
    }

    private static Object getTypeValue(Object v, Class<?> c) {
        if (c == Integer.class) {
            return Integer.valueOf(v.toString());
        }
        if (c == Double.class) {
            return Double.valueOf(v.toString());
        }
        if (c == Float.class) {
            return Float.valueOf(v.toString());
        }
        return v.toString();
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy) {
        return ListFrame.readMap(path, splitBy, Charset.defaultCharset());
    }

    public static ListFrame<Map<String, Object>> readMap(String path, String splitBy, Charset charset) {
        File file = new File(path);
        ListFrame<Map<String, Object>> listFrame = new ListFrame<Map<String, Object>>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader streamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader br = new BufferedReader(streamReader);){
            String line = "";
            String[] titles = null;
            line = br.readLine();
            if (line != null) {
                titles = line.split(splitBy);
            }
            while ((line = br.readLine()) != null) {
                String[] split = line.split(splitBy);
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (int i = 0; i < split.length; ++i) {
                    map.put(titles[i], split[i]);
                }
                listFrame.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listFrame;
    }

    private static void setListColumns(ListFrame<Map<String, Object>> listFrame, String title, Object value) {
        if (listFrame.columnData.containsKey(title)) {
            listFrame.columnData.get(title).add(value);
        } else {
            ListFrame<Object> columnsData = new ListFrame<Object>();
            columnsData.add(value);
            listFrame.columnData.put(title, columnsData);
        }
    }

    public <T> ListFrame<T> get(Function<E, T> fun) {
        ListFrame<T> listFrame = new ListFrame<T>();
        if (this.data == null) {
            return new ListFrame<E>();
        }
        if (this.data.size() == 0) {
            return listFrame;
        }
        Object o = this.data.get(0);
        if (o instanceof String || o instanceof Map) {
            throw new RuntimeException("unsupported operate!");
        }
        for (Object datum : this.data) {
            listFrame.add(fun.apply(datum));
        }
        return listFrame;
    }

    public <T> ListFrame<T> get(String columnName) {
        ListFrame<Object> objects = this.columnData.get(columnName);
        if (null != objects) {
            return objects;
        }
        ListFrame<Object> listFrame = new ListFrame<Object>();
        if (this.data == null) {
            return new ListFrame<E>();
        }
        if (this.data.size() == 0) {
            return new ListFrame<E>();
        }
        Object o = this.data.get(0);
        if (o instanceof String) {
            throw new RuntimeException("unsupported operate!");
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map e = (Map)datum;
                listFrame.add(e.get(columnName));
            }
            this.columnData.put(columnName, listFrame);
            return listFrame;
        }
        for (Object datum : this.data) {
            listFrame.add(ExpressUtil.getValue(columnName, datum));
        }
        this.columnData.put(columnName, listFrame);
        return listFrame;
    }

    public <T> ListFrame<T> distinct() {
        ListFrame listFrame = new ListFrame();
        for (Object datum : this.data) {
            if (listFrame.contains(datum)) continue;
            listFrame.add(datum);
        }
        return listFrame;
    }

    public ListFrame<E> replace(String src, String tar) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        Object o = this.data.get(0);
        if (o instanceof String) {
            ListFrame<String> numFrame = new ListFrame<String>();
            for (Object datum : this.data) {
                String map = (String)datum;
                numFrame.add(map.replaceAll(src, tar));
            }
            return numFrame;
        }
        if (o instanceof Map) {
            ListFrame<Map> numFrame = new ListFrame<Map>();
            for (Object datum : this.data) {
                Map map = (Map)datum;
                for (Object o1 : map.keySet()) {
                    map.put(o1, map.get(o1).toString().replaceAll(src, tar));
                }
                numFrame.add(map);
            }
            return numFrame;
        }
        throw new RuntimeException("please define a property that you want to replace!");
    }

    public ListFrame<E> replace(String column, String src, String tar) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        Object o = this.data.get(0);
        if (o instanceof String) {
            ListFrame<String> numFrame = new ListFrame<String>();
            for (Object datum : this.data) {
                String map = (String)datum;
                numFrame.add(map.replaceAll(src, tar));
            }
            return numFrame;
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map map = (Map)datum;
                String columnValue = map.get(column).toString().replaceAll(src, tar);
                map.put(column, columnValue);
            }
            return this.data;
        }
        for (Object datum : this.data) {
            Object columnValue = ExpressUtil.getValue(column, datum);
            datum = ExpressUtil.setValue(column, columnValue.toString().replaceAll(src, tar), datum);
        }
        return this.data;
    }

    public ListFrame<E> addHandler(DataHandlerInterface<E> dataProcess) {
        dataHandlers.add(dataProcess);
        return this;
    }

    public ListFrame<E> addHandler(String expressions) {
        expHandlers.add(expressions);
        return this;
    }

    public synchronized ListFrame<E> execute() {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        ListFrame numFrame = new ListFrame();
        for (Object datum : this.data) {
            for (DataHandlerInterface eDataHandlerInterface : dataHandlers) {
                datum = eDataHandlerInterface.handle(datum);
            }
            for (String expHandler : expHandlers) {
                List<ExpressionMap> ops = ExpressUtil.getOperates(expHandler);
                for (ExpressionMap op : ops) {
                    datum = ExpressUtil.operate(datum, op);
                }
            }
            numFrame.add(datum);
        }
        dataHandlers.clear();
        expHandlers.clear();
        return numFrame;
    }

    public ListFrame<E> handle(Predicate<E> condition, DataHandlerInterface<E> ... dataProcessArray) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        ListFrame numFrame = new ListFrame();
        for (Object datum : this.data) {
            if (condition.test(datum)) {
                for (DataHandlerInterface eDataHandlerInterface : dataProcessArray) {
                    datum = eDataHandlerInterface.handle(datum);
                }
                numFrame.add(datum);
                continue;
            }
            numFrame.add(datum);
        }
        return numFrame;
    }

    public ListFrame<E> handle(DataHandlerInterface<E> dataProcess) {
        return this.handle((E a) -> true, dataProcess);
    }

    public ListFrame<E> handle(DataHandlerInterface<E> ... dataProcess) {
        return this.handle((E a) -> true, dataProcess);
    }

    public ListFrame<E> handle(Predicate<E> condition, String ifExpressions, String elseExpressions) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        List<ExpressionMap> ifOps = ExpressUtil.getOperates(ifExpressions);
        List<ExpressionMap> elseOps = ExpressUtil.getOperates(elseExpressions);
        ListFrame numFrame = new ListFrame();
        for (Object datum : this.data) {
            for (ExpressionMap op : ifOps) {
                if (!condition.test(datum)) continue;
                datum = ExpressUtil.operate(datum, op);
            }
            for (ExpressionMap op : elseOps) {
                if (condition.test(datum)) continue;
                datum = ExpressUtil.operate(datum, op);
            }
            numFrame.add(datum);
        }
        return numFrame;
    }

    public ListFrame<E> handle(Predicate<E> condition, String ... expressions) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        List<ExpressionMap> ops = ExpressUtil.getOperates(expressions);
        ListFrame numFrame = new ListFrame();
        for (Object datum : this.data) {
            if (condition.test(datum)) {
                for (ExpressionMap op : ops) {
                    datum = ExpressUtil.operate(datum, op);
                }
            }
            numFrame.add(datum);
        }
        return numFrame;
    }

    public ListFrame<E> handle(String expressions) {
        return this.handle((E a) -> true, expressions);
    }

    public ListFrame<E> handle(String ... expressions) {
        return this.handle((E a) -> true, expressions);
    }

    public <T> ListFrame<T> handle(Predicate<E> condition, Function<E, T> fun) {
        if (this.data == null || this.data.size() == 0) {
            return new ListFrame<E>();
        }
        ListFrame<Object> numFrame = new ListFrame<Object>();
        for (Object datum : this.data) {
            if (condition.test(datum)) {
                numFrame.add(fun.apply(datum));
                continue;
            }
            numFrame.add(datum);
        }
        return numFrame;
    }

    public <T> ListFrame<T> handle(Function<E, T> fun) {
        return this.handle((E a) -> true, fun);
    }

    public MapFrame<Object, ListFrame> groupBy(String columnName) {
        if (this.data == null || this.data.size() == 0) {
            return new MapFrame<Object, ListFrame>();
        }
        MapFrame<Object, ListFrame> groupMap = new MapFrame<Object, ListFrame>();
        Object o = this.data.get(0);
        if (o instanceof String) {
            throw new RuntimeException("unsupported operate for String!");
        }
        if (o instanceof Map) {
            for (Object datum : this.data) {
                Map map = (Map)datum;
                Object columnValue = map.get(columnName);
                if (groupMap.containsKey(columnValue)) {
                    ((ListFrame)groupMap.get(columnValue)).add(datum);
                    continue;
                }
                ListFrame listFrame = new ListFrame();
                listFrame.add(datum);
                groupMap.put(columnValue, listFrame);
            }
        } else {
            for (Object datum : this.data) {
                Object columnValue = ExpressUtil.getValue(columnName, datum);
                if (groupMap.containsKey(columnValue)) {
                    ((ListFrame)groupMap.get(columnValue)).add(datum);
                    continue;
                }
                ListFrame listFrame = new ListFrame();
                listFrame.add(datum);
                groupMap.put(columnValue, listFrame);
            }
        }
        return groupMap;
    }

    public int argmax() {
        if (this.data == null || this.data.size() == 0) {
            return 0;
        }
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = 0.0;
            int index = 0;
            int n = 0;
            for (Object datum : this.data) {
                if (datum == null) continue;
                double a = Double.valueOf(datum + "");
                if (a > max) {
                    max = a;
                    index = n;
                }
                ++n;
            }
            return index;
        }
        Integer max = 0;
        int index = 0;
        int n = 0;
        for (Object datum : this.data) {
            if (datum == null) continue;
            int a = Integer.valueOf(datum + "");
            if (a > max) {
                max = a;
                index = n;
            }
            ++n;
        }
        return index;
    }

    public <T> T max() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = Double.MIN_VALUE;
            for (Object datum : this.data) {
                double a;
                if (datum == null || !((a = Double.valueOf(datum + "").doubleValue()) > max)) continue;
                max = a;
            }
            return (T)max;
        }
        Integer max = 0;
        for (Object datum : this.data) {
            int a;
            if (datum == null || (a = Integer.valueOf(datum + "").intValue()) <= max) continue;
            max = a;
        }
        return (T)max;
    }

    public int argmin() {
        if (this.data == null || this.data.size() == 0) {
            return 0;
        }
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = Double.MAX_VALUE;
            int index = 0;
            int n = 0;
            for (Object datum : this.data) {
                if (datum == null) continue;
                double a = Double.valueOf(datum + "");
                if (a < max) {
                    max = a;
                    index = n;
                }
                ++n;
            }
            return index;
        }
        Integer max = Integer.MAX_VALUE;
        int index = 0;
        int n = 0;
        for (Object datum : this.data) {
            if (datum == null) continue;
            int a = Integer.valueOf(datum + "");
            if (a < max) {
                max = a;
                index = n;
            }
            ++n;
        }
        return index;
    }

    public <T> T min() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        if (doublePattern.matcher(this.data.get(0).toString()).find()) {
            Double max = Double.MAX_VALUE;
            for (Object datum : this.data) {
                double a;
                if (datum == null || !((a = Double.valueOf(datum + "").doubleValue()) < max)) continue;
                max = a;
            }
            return (T)max;
        }
        Integer max = Integer.MAX_VALUE;
        for (Object datum : this.data) {
            int a;
            if (datum == null || (a = Integer.valueOf(datum + "").intValue()) >= max) continue;
            max = a;
        }
        return (T)max;
    }

    public double avg() {
        if (this.data == null || this.data.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Object datum : this.data) {
            if (datum == null) continue;
            double a = Double.valueOf(datum + "");
            sum += a;
        }
        return sum / (double)this.data.size();
    }

    public double sum() {
        if (this.data == null || this.data.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Object datum : this.data) {
            if (datum == null) continue;
            double a = Double.valueOf(datum + "");
            sum += a;
        }
        return sum;
    }

    public ListFrame<Double> asDouble() {
        ListFrame<Double> listFrame = new ListFrame<Double>();
        for (Object datum : this.data) {
            if (datum instanceof Double) {
                listFrame.add((Double)datum);
                continue;
            }
            listFrame.add(Double.valueOf(datum + ""));
        }
        return listFrame;
    }

    public ListFrame<Float> asFloat() {
        ListFrame<Float> listFrame = new ListFrame<Float>();
        for (Object datum : this.data) {
            if (datum instanceof Float) {
                listFrame.add((Float)datum);
                continue;
            }
            listFrame.add(Float.valueOf(datum + ""));
        }
        return listFrame;
    }

    public ListFrame<Integer> asInteger() {
        ListFrame<Integer> listFrame = new ListFrame<Integer>();
        for (Object datum : this.data) {
            if (datum instanceof Integer) {
                listFrame.add((Integer)datum);
                continue;
            }
            listFrame.add(Integer.valueOf(datum + ""));
        }
        return listFrame;
    }

    public ListFrame<String> asString() {
        ListFrame<String> listFrame = new ListFrame<String>();
        for (Object datum : this.data) {
            if (datum instanceof String) {
                listFrame.add((String)datum);
                continue;
            }
            listFrame.add(datum + "");
        }
        return listFrame;
    }

    public List<E> toList() {
        return new CopyOnWriteArrayList<E>(this.data);
    }

    public void toFile(String path) {
        try (FileWriter writer = new FileWriter(path);
             BufferedWriter bw = new BufferedWriter(writer);){
            List<String> columns = this.getColumns();
            bw.write(String.join((CharSequence)",", columns) + "\n");
            for (Object datum : this.data) {
                if (datum instanceof String) {
                    bw.write(datum.toString() + "\n");
                    continue;
                }
                if (!(datum instanceof Map)) continue;
                Map map = (Map)datum;
                StringBuffer line = new StringBuffer();
                int columnsSize = columns.size();
                for (int i = 0; i < columnsSize; ++i) {
                    String column = columns.get(i);
                    if (i < columnsSize - 1) {
                        line.append(map.get(column) + ",");
                        continue;
                    }
                    line.append(map.get(column));
                }
                line.append("\n");
                bw.write(line.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double variance() {
        double avg = this.avg();
        double sum = 0.0;
        for (Object datum : this.data) {
            double a = Double.valueOf(datum + "");
            sum += Math.pow(a - avg, 2.0);
        }
        return sum / (double)this.data.size();
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public MapFrame<E, Integer> frequency() {
        MapFrame mapFrame = new MapFrame();
        for (Object datum : this.data) {
            if (mapFrame.containsKey(datum)) {
                mapFrame.put(datum, (Integer)mapFrame.get(datum) + 1);
                continue;
            }
            mapFrame.put(datum, 1);
        }
        return mapFrame;
    }

    public <T> ListFrame<T> dropNull() {
        ListFrame listFrame = new ListFrame();
        for (Object datum : this.data) {
            if (datum == null) continue;
            listFrame.add(datum);
        }
        return listFrame;
    }
}

